/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.ClassLoaderManager;
import com.mathworks.jmi.MatlabErrorException;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OpaqueJavaInterface {
    private static Method sReloadableFindClass = null;
    private static Vector sClassLoaders = new Vector();
    private static Hashtable sSearchedClass = new Hashtable(1997);
    private static String sNull = "";

    public static void enableClassReloading(boolean bl) {
        if (bl) {
            try {
                Class<?> clazz = Class.forName("com.mathworks.jmi.ClassLoaderManager");
                if (clazz != null) {
                    sReloadableFindClass = clazz.getDeclaredMethod("findClass", OpaqueJavaInterface.findClass("java.lang.String"));
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            sReloadableFindClass = null;
        }
    }

    public static String getObjectClassname(Object object) {
        return object.getClass().getName().replace('.', '/');
    }

    public static boolean doesMethodExist(String string, String string2) {
        boolean bl = false;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string2) || !Modifier.isPublic(methodArray[i].getModifiers())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearJavaClassCache() {
        Hashtable hashtable = sSearchedClass;
        synchronized (hashtable) {
            Enumeration enumeration = sSearchedClass.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = sSearchedClass.get(k);
                if (!sNull.equals(v) && !ClassLoaderManager.isReloadable((Class)v)) continue;
                sSearchedClass.remove(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class findClass(String string) {
        Class clazz = null;
        String string2 = string.replace('/', '.');
        Object v = sSearchedClass.get(string2);
        if (v != null) {
            if (sNull.equals(v)) {
                return null;
            }
            return (Class)v;
        }
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Hashtable hashtable = sSearchedClass;
            synchronized (hashtable) {
                sSearchedClass.put(string2, sNull);
            }
            throw exceptionInInitializerError;
        }
        if (clazz == null) {
            int n = sClassLoaders.size();
            for (int i = 0; i < n; ++i) {
                ClassLoader classLoader = (ClassLoader)sClassLoaders.elementAt(i);
                try {
                    clazz = classLoader.loadClass(string2);
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (clazz != null) break;
            }
            if (sReloadableFindClass != null && clazz == null) {
                try {
                    clazz = (Class)sReloadableFindClass.invoke(null, string2);
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    Hashtable hashtable = sSearchedClass;
                    synchronized (hashtable) {
                        sSearchedClass.put(string2, sNull);
                    }
                    throw exceptionInInitializerError;
                }
            }
        }
        Hashtable hashtable = sSearchedClass;
        synchronized (hashtable) {
            sSearchedClass.put(string2, clazz == null ? sNull : clazz);
        }
        return clazz;
    }

    public static void registerClassLoader(ClassLoader classLoader) {
        sClassLoaders.addElement(classLoader);
    }

    public static String[] getMethodsName(String string, String string2) {
        String[] stringArray = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            int n;
            int n2 = 0;
            Method[] methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (methodArray[n].getName().equals(string2) && Modifier.isPublic(methodArray[n].getModifiers())) {
                    ++n2;
                    continue;
                }
                methodArray[n] = null;
            }
            if (n2 > 0) {
                int n3 = 0;
                stringArray = new String[n2];
                for (n = 0; n < methodArray.length; ++n) {
                    if (methodArray[n] == null) continue;
                    stringArray[n3] = methodArray[n].toString();
                    ++n3;
                }
            }
        }
        return stringArray;
    }

    public static String[] getMethodDescriptions(String string) {
        String[] stringArray = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            int n;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < constructorArray.length; ++n) {
                if (!Modifier.isPublic(constructorArray[n].getModifiers())) continue;
                ++n2;
            }
            for (n = 0; n < methodArray.length; ++n) {
                if (!Modifier.isPublic(methodArray[n].getModifiers())) continue;
                ++n3;
            }
            stringArray = new String[n2 + n3];
            n2 = 0;
            for (n = 0; n < constructorArray.length; ++n) {
                if (!Modifier.isPublic(constructorArray[n].getModifiers())) continue;
                stringArray[n2++] = constructorArray[n].toString();
            }
            n3 = 0;
            for (n = 0; n < methodArray.length; ++n) {
                if (!Modifier.isPublic(methodArray[n].getModifiers())) continue;
                stringArray[n2 + n3++] = methodArray[n].toString();
            }
        }
        return stringArray;
    }

    public static boolean doesFieldExist(String string, String string2) {
        boolean bl = false;
        Field field = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            try {
                field = clazz.getField(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (field != null && Modifier.isPublic(field.getModifiers())) {
            bl = true;
        }
        return bl;
    }

    public static String[] getFieldNames(String string) {
        String[] stringArray = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            int n;
            Field[] fieldArray = clazz.getFields();
            Hashtable<String, Integer> hashtable = null;
            int n2 = 0;
            if (fieldArray.length > 0) {
                hashtable = new Hashtable<String, Integer>(fieldArray.length);
            }
            for (n = 0; n < fieldArray.length; ++n) {
                if (!Modifier.isPublic(fieldArray[n].getModifiers())) {
                    fieldArray[n] = null;
                    continue;
                }
                Integer n3 = new Integer(n);
                Integer n4 = hashtable.put(fieldArray[n].getName(), n3);
                if (n4 == null) {
                    ++n2;
                    continue;
                }
                fieldArray[n3.intValue()] = null;
                fieldArray[n4.intValue()] = null;
            }
            stringArray = new String[n2];
            n2 = 0;
            for (n = 0; n < fieldArray.length; ++n) {
                if (fieldArray[n] == null) continue;
                stringArray[n2++] = fieldArray[n].getName();
            }
        }
        return stringArray;
    }

    public static String getFieldsName(String string, String string2) {
        String string3 = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string2) || !Modifier.isPublic(fieldArray[i].getModifiers())) continue;
                string3 = fieldArray[i].toString();
                break;
            }
        }
        return string3;
    }

    public static String[] getFieldDescriptions(String string) {
        String[] stringArray = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            Field[] fieldArray = clazz.getFields();
            stringArray = new String[fieldArray.length];
            stringArray = new String[fieldArray.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                stringArray[i] = fieldArray[i].toString();
            }
        }
        return stringArray;
    }

    public static String getSignatureOfClass(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            stringBuffer.append('[');
            clazz2 = clazz.getComponentType();
            stringBuffer.append(OpaqueJavaInterface.getSignatureOfClass(clazz2));
        } else if (clazz2.isPrimitive()) {
            if (clazz2.equals(Void.TYPE)) {
                stringBuffer.append('V');
            } else if (clazz2.equals(Boolean.TYPE)) {
                stringBuffer.append('Z');
            } else if (clazz2.equals(Byte.TYPE)) {
                stringBuffer.append('B');
            } else if (clazz2.equals(Character.TYPE)) {
                stringBuffer.append('C');
            } else if (clazz2.equals(Short.TYPE)) {
                stringBuffer.append('S');
            } else if (clazz2.equals(Integer.TYPE)) {
                stringBuffer.append('I');
            } else if (clazz2.equals(Long.TYPE)) {
                stringBuffer.append('J');
            } else if (clazz2.equals(Float.TYPE)) {
                stringBuffer.append('F');
            } else if (clazz2.equals(Double.TYPE)) {
                stringBuffer.append('D');
            }
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz2.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public static String getSignatureOfClassname(String string) {
        String string2 = null;
        Class clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            string2 = OpaqueJavaInterface.getSignatureOfClass(clazz);
        }
        return string2;
    }

    public static String getFieldSignature(String string, String string2) {
        String string3 = null;
        Field field = null;
        Class<?> clazz = OpaqueJavaInterface.findClass(string);
        if (clazz != null) {
            try {
                field = clazz.getField(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (field != null && Modifier.isPublic(field.getModifiers())) {
            clazz = field.getType();
            string3 = OpaqueJavaInterface.getSignatureOfClass(clazz);
        }
        return string3;
    }

    public static String getSignatureOfObjectClass(Object object) {
        String string = null;
        if (object != null) {
            Class<?> clazz = object.getClass();
            string = OpaqueJavaInterface.getSignatureOfClass(clazz);
        }
        return string;
    }

    private static String makeSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(OpaqueJavaInterface.getSignatureOfClass(classArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append(OpaqueJavaInterface.getSignatureOfClass(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String makeSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(OpaqueJavaInterface.getSignatureOfClass(classArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append('V');
        return stringBuffer.toString();
    }

    public static String[] getMethodSignatures(String string, String string2) {
        String[] stringArray;
        block5: {
            stringArray = null;
            Class clazz = OpaqueJavaInterface.findClass(string);
            if (clazz == null) break block5;
            if (string2 == null) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                stringArray = new String[constructorArray.length];
                for (int i = 0; i < constructorArray.length; ++i) {
                    stringArray[i] = OpaqueJavaInterface.makeSignature(constructorArray[i]);
                }
            } else {
                int n;
                Vector<Method> vector = new Vector<Method>();
                Method[] methodArray = clazz.getMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equals(string2)) continue;
                    vector.addElement(methodArray[n]);
                }
                int n2 = vector.size();
                stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = OpaqueJavaInterface.makeSignature((Method)vector.elementAt(n));
                }
            }
        }
        return stringArray;
    }

    public static int[] getArrayDimensions(Object object) {
        int[] nArray = null;
        if (object.getClass().isArray()) {
            nArray = new int[]{Array.getLength(object), 1};
        }
        return nArray;
    }

    public static boolean isEqual(Object object, Object object2) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (object == null || object2 == null) {
            return object == object2;
        }
        clazz = object.getClass();
        if (clazz != (clazz2 = object2.getClass()) && !clazz.isInstance(object2) && !clazz2.isInstance(object)) {
            return false;
        }
        if (!clazz.isArray()) {
            if (clazz2.isArray() || !object.equals(object2)) {
                return false;
            }
        } else {
            int n = Array.getLength(object);
            int n2 = -1;
            if (clazz2.isArray()) {
                n2 = Array.getLength(object2);
            }
            if (n != n2) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (OpaqueJavaInterface.isEqual(Array.get(object, i), Array.get(object2, i))) continue;
                return false;
            }
        }
        return true;
    }

    public static Object[] serializeObject(Object object) {
        byte[] byArray = null;
        String string = null;
        Object[] objectArray = new Object[2];
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                string = "Could not serialize object: " + object + "\n" + exception;
            }
        } else {
            string = object + " is not serializable";
        }
        objectArray[0] = byArray;
        objectArray[1] = string;
        return objectArray;
    }

    public static Object[] unserializeObject(byte[] byArray) {
        Object object = null;
        String string = null;
        Object[] objectArray = new Object[2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ClassLoaderObjectInputStream classLoaderObjectInputStream = new ClassLoaderObjectInputStream(byteArrayInputStream);
            object = classLoaderObjectInputStream.readObject();
            classLoaderObjectInputStream.close();
        }
        catch (Exception exception) {
            string = "Could not deserialize object: " + exception + "/n";
        }
        objectArray[0] = object;
        objectArray[1] = string;
        return objectArray;
    }

    public static boolean isObjectInstanceOfClass(Object object, String string) {
        boolean bl = false;
        Class clazz = null;
        try {
            String string2 = string.startsWith("[") ? string : string.replace('/', '.');
            clazz = OpaqueJavaInterface.findClass(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            bl = clazz.isInstance(object);
        }
        return bl;
    }

    public static boolean doesClassImplementInterface(Class clazz, String string) {
        boolean bl = false;
        Class clazz2 = null;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray == null) {
            return bl;
        }
        try {
            clazz2 = OpaqueJavaInterface.findClass(string.replace('/', '.'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz2 == null) {
            return bl;
        }
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            if (!classArray[i].equals(clazz2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static int getInterfaceDistance(Class clazz, Class clazz2, int n) {
        Class clazz3;
        int n2 = -1;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            int n3 = classArray.length;
            for (int i = 0; i < n3; ++i) {
                if (classArray[i].equals(clazz2)) {
                    n2 = n;
                    break;
                }
                if (!clazz2.isAssignableFrom(classArray[i])) continue;
                n2 = OpaqueJavaInterface.getInterfaceDistance(classArray[i], clazz2, n + 1);
                break;
            }
        }
        if (n2 == -1 && (clazz3 = clazz.getSuperclass()) != null) {
            n2 = clazz3.equals(clazz2) ? n + 1 : OpaqueJavaInterface.getInterfaceDistance(clazz3, clazz2, n + 1);
        }
        return n2;
    }

    public static int getClassDistance(Object object, String string) {
        int n = -1;
        Class<?> clazz = null;
        try {
            clazz = OpaqueJavaInterface.findClass(string.replace('/', '.'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && clazz.isInstance(object)) {
            Class<?> clazz2 = object.getClass();
            if (clazz2.equals(clazz)) {
                n = 0;
            } else {
                int n2 = 0;
                while (clazz.isArray()) {
                    ++n2;
                    clazz = clazz.getComponentType();
                }
                int n3 = 0;
                while (clazz2.isArray()) {
                    ++n3;
                    clazz2 = clazz2.getComponentType();
                }
                if (n2 == n3) {
                    if (!clazz.isInterface()) {
                        int n4 = 1;
                        for (Class<?> clazz3 = clazz2.getSuperclass(); clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                            if (clazz.equals(clazz3)) {
                                n = n4;
                                break;
                            }
                            ++n4;
                        }
                    } else {
                        n = OpaqueJavaInterface.getInterfaceDistance(clazz2, clazz, 0);
                    }
                }
            }
        }
        return n;
    }

    public static String[] getBaseClassAndInterfaces(String string) {
        Class<?>[] classArray;
        Vector<String> vector = new Vector<String>();
        Class clazz = OpaqueJavaInterface.findClass(string);
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            vector.addElement(clazz2.getName());
        }
        if ((classArray = clazz.getInterfaces()) != null) {
            for (int i = 0; i < classArray.length; ++i) {
                vector.addElement(classArray[i].getName());
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String getExceptionMessage(Throwable throwable) {
        String string = null;
        if (throwable instanceof MatlabErrorException) {
            string = throwable.getMessage();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Java exception occurred: \n");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            stringBuffer.append(byteArrayOutputStream.toString());
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static Object localRef(Object object) {
        Object object2 = object;
        return object2;
    }

    private static void printStrings(String[] stringArray, String string) {
        System.out.println(string);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("     " + stringArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        String string = new String("foo");
        Color color = new Color(0, 0, 100);
        String string2 = OpaqueJavaInterface.getObjectClassname(string).replace('.', '/');
        String string3 = OpaqueJavaInterface.getObjectClassname(color).replace('.', '/');
        System.out.println("String classname: " + string2);
        System.out.println("Color classname: " + string3);
        boolean bl = OpaqueJavaInterface.doesMethodExist(string2, "getClass");
        boolean bl2 = OpaqueJavaInterface.doesMethodExist(string2, "toString");
        boolean bl3 = OpaqueJavaInterface.doesMethodExist(string3, "getRed");
        boolean bl4 = OpaqueJavaInterface.doesMethodExist(string3, "getFooBar");
        System.out.println("method existence: " + bl + bl2 + bl3 + bl4);
        String[] stringArray2 = OpaqueJavaInterface.getMethodDescriptions(string2);
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray2, "String methods");
        String[] stringArray3 = OpaqueJavaInterface.getMethodSignatures(string2, "toString");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "toString sigs");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures(string3, "RGBtoHSB");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "RGBtoHSB sigs");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures(string3, "getRed");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "getRed sigs");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures(string3, "getColor");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "getColor sigs");
        Color color2 = Color.getColor("biteme");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures(string3, null);
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "Color constructor sigs");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures("java/lang/StringBuffer", "append");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "append sigs");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures(string2, "notify");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "notify");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures("com/mathworks/jmi/TestClass", "testMethod");
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "TestClass testMethod");
        stringArray3 = OpaqueJavaInterface.getMethodSignatures("com/mathworks/jmi/TestClass", null);
        System.out.println();
        OpaqueJavaInterface.printStrings(stringArray3, "TestClass constructors");
        try {
            int[] nArray = new int[5];
            nArray[6] = 10;
        }
        catch (Exception exception) {
            String string4 = OpaqueJavaInterface.getExceptionMessage(exception);
            System.out.println(string4);
        }
    }

    private static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        public ClassLoaderObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return ClassLoaderManager.findClass(objectStreamClass.getName());
            }
        }
    }
}

