/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import java.util.Hashtable;

class TypeInfo {
    public static final int sBooleanType = 1;
    public static final int sByteType = 2;
    public static final int sCharType = 3;
    public static final int sShortType = 4;
    public static final int sIntType = 5;
    public static final int sLongType = 6;
    public static final int sDoubleType = 7;
    public static final int sFloatType = 8;
    public static final int sObjectType = 9;
    private static Hashtable sBasicTypes = new Hashtable();
    public int storageClass;
    public String typeName;
    public String className;

    private TypeInfo(int n, String string) {
        this.storageClass = n;
        this.typeName = string;
        this.className = string;
    }

    private TypeInfo(String string) {
        this.storageClass = 9;
        int n = string.indexOf("[]");
        if (n > 0) {
            String string2 = "";
            String string3 = string.substring(0, n).replace('.', '/');
            while (n > 0) {
                n = string.indexOf("[]", n + 1);
                string2 = string2 + "[";
            }
            TypeInfo typeInfo = TypeInfo.getTypeInfoFromName(string3);
            this.className = this.typeName = string2 + typeInfo.typeName;
        } else {
            this.className = string.replace('.', '/');
            this.typeName = "L" + this.className + ";";
        }
    }

    private static void initBasicTypes() {
        sBasicTypes.put("boolean", new TypeInfo(1, "Z"));
        sBasicTypes.put("byte", new TypeInfo(2, "B"));
        sBasicTypes.put("char", new TypeInfo(3, "C"));
        sBasicTypes.put("short", new TypeInfo(4, "S"));
        sBasicTypes.put("int", new TypeInfo(5, "I"));
        sBasicTypes.put("float", new TypeInfo(8, "F"));
        sBasicTypes.put("double", new TypeInfo(7, "D"));
        sBasicTypes.put("long", new TypeInfo(6, "J"));
    }

    public static TypeInfo getTypeInfoFromName(String string) {
        TypeInfo.initBasicTypes();
        TypeInfo typeInfo = (TypeInfo)sBasicTypes.get(string);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(string);
        }
        return typeInfo;
    }
}

