/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.attribute_info;
import com.mathworks.jmi.bean.constant_double_info;
import com.mathworks.jmi.bean.constant_long_info;
import com.mathworks.jmi.bean.cp_info;
import com.mathworks.jmi.bean.field_info;
import com.mathworks.jmi.bean.method_info;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class class_file
implements Cloneable {
    public int magic;
    public int minor_version;
    public int major_version;
    public int constant_pool_count;
    public cp_info[] constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public int fields_count;
    public field_info[] fields;
    public int methods_count;
    public method_info[] methods;
    public int attributes_count;
    public attribute_info[] attributes;

    class_file() {
    }

    public void displayFile() {
        int n;
        System.out.println("magic: " + Integer.toHexString(this.magic));
        System.out.println("minor_version: " + this.minor_version);
        System.out.println("major_version: " + this.major_version);
        System.out.println("constant_pool_count: " + this.constant_pool_count);
        for (n = 1; n < this.constant_pool_count; ++n) {
            System.out.println("Constant[" + n + "]: " + this.constant_pool[n]);
        }
        System.out.println("access_flags: " + this.access_flags);
        System.out.println("this_class: " + this.this_class);
        System.out.println("super_class: " + this.super_class);
        System.out.println("interfaces_count: " + this.interfaces_count);
        for (n = 0; n < this.interfaces_count; ++n) {
            System.out.println("interfaces[" + n + "]: " + this.interfaces[n]);
        }
        System.out.println("fields_count: " + this.fields_count);
        for (n = 0; n < this.fields_count; ++n) {
            System.out.println("Field[" + n + "]: ");
            this.fields[n].displayInfo(this.constant_pool);
        }
        System.out.println("methods_count: " + this.methods_count);
        for (n = 0; n < this.methods_count; ++n) {
            System.out.println("Method[" + n + "]: ");
            this.methods[n].displayInfo(this.constant_pool);
        }
        System.out.println("attributes_count: " + this.attributes_count);
        for (n = 0; n < this.attributes_count; ++n) {
            System.out.println("Attribute[" + n + "]:");
            this.attributes[n].displayInfo(this.constant_pool);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        class_file class_file2 = (class_file)super.clone();
        class_file2.constant_pool = new cp_info[this.constant_pool_count];
        for (n = 1; n < this.constant_pool_count; ++n) {
            class_file2.constant_pool[n] = (cp_info)this.constant_pool[n].clone();
        }
        class_file2.interfaces = new int[this.interfaces_count];
        for (n = 0; n < this.interfaces_count; ++n) {
            class_file2.interfaces[n] = this.interfaces[n];
        }
        class_file2.fields = new field_info[this.fields_count];
        for (n = 0; n < this.fields_count; ++n) {
            class_file2.fields[n] = (field_info)this.fields[n].clone();
        }
        class_file2.methods = new method_info[this.methods_count];
        for (n = 0; n < this.methods_count; ++n) {
            class_file2.methods[n] = (method_info)this.methods[n].clone();
        }
        class_file2.attributes = new attribute_info[this.attributes_count];
        for (n = 0; n < this.attributes_count; ++n) {
            class_file2.attributes[n] = (attribute_info)this.attributes[n].clone();
        }
        return class_file2;
    }

    public void readValues(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        this.magic = randomAccessFile.readInt();
        this.minor_version = randomAccessFile.readUnsignedShort();
        this.major_version = randomAccessFile.readUnsignedShort();
        this.constant_pool_count = randomAccessFile.readUnsignedShort();
        this.constant_pool = new cp_info[this.constant_pool_count];
        for (n = 1; n < this.constant_pool_count; ++n) {
            this.constant_pool[n] = cp_info.getConstantPoolInfo(randomAccessFile);
            if (!(this.constant_pool[n] instanceof constant_double_info) && !(this.constant_pool[n] instanceof constant_long_info)) continue;
            ++n;
        }
        this.access_flags = randomAccessFile.readUnsignedShort();
        this.this_class = randomAccessFile.readUnsignedShort();
        this.super_class = randomAccessFile.readUnsignedShort();
        this.interfaces_count = randomAccessFile.readUnsignedShort();
        this.interfaces = new int[this.interfaces_count];
        for (n = 0; n < this.interfaces_count; ++n) {
            this.interfaces[n] = randomAccessFile.readUnsignedShort();
        }
        this.fields_count = randomAccessFile.readUnsignedShort();
        this.fields = new field_info[this.fields_count];
        for (n = 0; n < this.fields_count; ++n) {
            this.fields[n] = new field_info();
            this.fields[n].readValues(this.constant_pool, randomAccessFile);
        }
        this.methods_count = randomAccessFile.readUnsignedShort();
        this.methods = new method_info[this.methods_count];
        for (n = 0; n < this.methods_count; ++n) {
            this.methods[n] = new method_info();
            this.methods[n].readValues(this.constant_pool, randomAccessFile);
        }
        this.attributes_count = randomAccessFile.readUnsignedShort();
        this.attributes = new attribute_info[this.attributes_count];
        for (n = 0; n < this.attributes_count; ++n) {
            this.attributes[n] = attribute_info.getAttributeInfo(this.constant_pool, randomAccessFile);
        }
    }

    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(this.magic);
        dataOutputStream.writeShort(this.minor_version);
        dataOutputStream.writeShort(this.major_version);
        dataOutputStream.writeShort(this.constant_pool_count);
        for (n = 1; n < this.constant_pool_count; ++n) {
            this.constant_pool[n].writeValues(dataOutputStream);
            if (!(this.constant_pool[n] instanceof constant_double_info) && !(this.constant_pool[n] instanceof constant_long_info)) continue;
            ++n;
        }
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.this_class);
        dataOutputStream.writeShort(this.super_class);
        dataOutputStream.writeShort(this.interfaces_count);
        for (n = 0; n < this.interfaces_count; ++n) {
            dataOutputStream.writeShort(this.interfaces[n]);
        }
        dataOutputStream.writeShort(this.fields_count);
        for (n = 0; n < this.fields_count; ++n) {
            this.fields[n].writeValues(this.constant_pool, dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods_count);
        for (n = 0; n < this.methods_count; ++n) {
            this.methods[n].writeValues(this.constant_pool, dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes_count);
        for (n = 0; n < this.attributes_count; ++n) {
            this.attributes[n].writeValues(dataOutputStream);
        }
    }
}

