/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.hg.peer.UnitPos;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.export.PrintExportPanel;
import com.mathworks.page.export.PrintExportSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreviewTabLayout
extends MJPanel
implements ChangeListener,
ActionListener,
PropertyChangeListener {
    private PrintExportSettings fPrintSettings;
    private MJRadioButton fRadBtnModeAuto;
    private MJRadioButton fRadBtnModeManual;
    private MJSpinner fPaperPosLeft;
    private MJSpinner fPaperPosTop;
    private MJSpinner fPaperPosWidth;
    private MJSpinner fPaperPosHeight;
    private MJButton fBtnCenter;
    private MJButton fBtnFillPage;
    private MJButton fBtnAspectRatio;
    private MJButton fBtnDefaultSize;
    private MJComboBox fComboPaperType;
    private MJSpinner fTextPaperWidth;
    private MJSpinner fTextPaperHeight;
    private MJRadioButton fRadBtnIn;
    private MJRadioButton fRadBtnCm;
    private MJRadioButton fRadBtnPts;
    private MJRadioButton fRadBtnPortrait;
    private MJRadioButton fRadBtnLandscape;
    private MJRadioButton fRadBtnRotated;

    public PreviewTabLayout(PrintExportSettings printExportSettings) {
        this.fPrintSettings = printExportSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PreviewTabLayout.this.createUI();
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.createUI();
        }
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.placement")));
        this.add((Component)mJPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 6, 3, 6), 0, 0));
        this.fRadBtnModeAuto = new MJRadioButton(PrintExportPanel.sResHandle.getString("button.usescreensize"));
        this.fRadBtnModeAuto.setName("RadBtn_ModeAuto");
        this.fRadBtnModeManual = new MJRadioButton(PrintExportPanel.sResHandle.getString("button.usemanualsize"));
        this.fRadBtnModeManual.setName("RadBtn_ModeManual");
        mJPanel.add((Component)this.fRadBtnModeAuto, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fRadBtnModeManual, (Object)new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 13, 3), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBtnModeAuto);
        buttonGroup.add((AbstractButton)this.fRadBtnModeManual);
        this.fRadBtnModeAuto.addActionListener((ActionListener)this);
        this.fRadBtnModeManual.addActionListener((ActionListener)this);
        MJLabel mJLabel = new MJLabel(PrintExportPanel.sResHandle.getString("spin.FigLeft"));
        MJLabel mJLabel2 = new MJLabel(PrintExportPanel.sResHandle.getString("spin.FigTop"));
        MJLabel mJLabel3 = new MJLabel(PrintExportPanel.sResHandle.getString("spin.FigWidth"));
        MJLabel mJLabel4 = new MJLabel(PrintExportPanel.sResHandle.getString("spin.FigHeight"));
        this.fPaperPosLeft = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fPaperPosLeft.setName("Spinner_PaperPosLeft");
        this.fPaperPosTop = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fPaperPosTop.setName("Spinner_PaperPosTop");
        this.fPaperPosWidth = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.01));
        this.fPaperPosWidth.setName("Spinner_PaperPosWidth");
        this.fPaperPosHeight = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.01));
        this.fPaperPosHeight.setName("Spinner_PaperPosHeight");
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)this.fPaperPosLeft, "###0.00");
        numberEditor.getTextField().setColumns(10);
        this.fPaperPosLeft.setEditor((JComponent)numberEditor);
        numberEditor = new JSpinner.NumberEditor((JSpinner)this.fPaperPosTop, "###0.00");
        numberEditor.getTextField().setColumns(10);
        this.fPaperPosTop.setEditor((JComponent)numberEditor);
        numberEditor = new JSpinner.NumberEditor((JSpinner)this.fPaperPosWidth, "###0.00");
        numberEditor.getTextField().setColumns(10);
        this.fPaperPosWidth.setEditor((JComponent)numberEditor);
        numberEditor = new JSpinner.NumberEditor((JSpinner)this.fPaperPosHeight, "###0.00");
        numberEditor.getTextField().setColumns(10);
        this.fPaperPosHeight.setEditor((JComponent)numberEditor);
        mJPanel.add((Component)mJLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fPaperPosLeft, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)mJLabel2, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fPaperPosTop, (Object)new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)mJLabel3, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fPaperPosWidth, (Object)new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)mJLabel4, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)this.fPaperPosHeight, (Object)new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 6, 3), 0, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.add((Component)mJPanel2, (Object)new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.fBtnDefaultSize = new MJButton(PrintExportPanel.sResHandle.getString("button.fDefaultSize"));
        this.fBtnDefaultSize.setName("Btn_PaperPosDefault");
        this.fBtnFillPage = new MJButton(PrintExportPanel.sResHandle.getString("button.fFillPage"));
        this.fBtnFillPage.setName("Btn_PaperPosFillPage");
        this.fBtnAspectRatio = new MJButton(PrintExportPanel.sResHandle.getString("button.fAspectRatio"));
        this.fBtnAspectRatio.setName("Btn_PaperPosAspectRatio");
        this.fBtnCenter = new MJButton(PrintExportPanel.sResHandle.getString("button.fCenter"));
        this.fBtnCenter.setName("Btn_PaperPosCenter");
        Dimension dimension = this.fBtnAspectRatio.getPreferredSize();
        dimension.width = 150;
        this.fBtnDefaultSize.setPreferredSize(dimension);
        this.fBtnFillPage.setPreferredSize(dimension);
        this.fBtnAspectRatio.setPreferredSize(dimension);
        this.fBtnCenter.setPreferredSize(dimension);
        this.fBtnDefaultSize.addActionListener((ActionListener)this);
        this.fBtnFillPage.addActionListener((ActionListener)this);
        this.fBtnAspectRatio.addActionListener((ActionListener)this);
        this.fBtnCenter.addActionListener((ActionListener)this);
        mJPanel2.add((Component)this.fBtnDefaultSize, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        mJPanel2.add((Component)this.fBtnFillPage, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        mJPanel2.add((Component)this.fBtnAspectRatio, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        mJPanel2.add((Component)this.fBtnCenter, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setLayout((LayoutManager)new GridBagLayout());
        mJPanel3.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.paperType")));
        this.add((Component)mJPanel3, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 3, 3, 3), 0, 0));
        MJLabel mJLabel5 = new MJLabel(PrintExportPanel.sResHandle.getString("label.papersize"));
        this.fComboPaperType = new MJComboBox();
        this.fComboPaperType.setName("Combo_PaperType");
        this.fComboPaperType.setEditorColumnCount(10);
        for (int i = 0; i < PrintExportSettings.MATLAB_PAPER_TYPES.length; ++i) {
            this.fComboPaperType.addItem((Object)PrintExportSettings.MATLAB_PAPER_TYPES[i]);
        }
        this.fComboPaperType.addActionListener((ActionListener)this);
        mJPanel3.add((Component)mJLabel5, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel3.add((Component)this.fComboPaperType, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        MJLabel mJLabel6 = new MJLabel(PrintExportPanel.sResHandle.getString("spin.width"));
        MJLabel mJLabel7 = new MJLabel(PrintExportPanel.sResHandle.getString("spin.height"));
        this.fTextPaperWidth = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.5));
        this.fTextPaperWidth.setName("Spinner_PaperWidth");
        this.fTextPaperHeight = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, 0.0, 2.147483647E9, 0.5));
        this.fTextPaperHeight.setName("Spinner_PaperHeight");
        numberEditor = new JSpinner.NumberEditor((JSpinner)this.fTextPaperWidth, "###0.00");
        numberEditor.getTextField().setColumns(10);
        numberEditor.getTextField().setName("Text_PaperWidth");
        this.fTextPaperWidth.setEditor((JComponent)numberEditor);
        numberEditor = new JSpinner.NumberEditor((JSpinner)this.fTextPaperHeight, "###0.00");
        this.fTextPaperHeight.setEditor((JComponent)numberEditor);
        numberEditor.getTextField().setColumns(10);
        numberEditor.getTextField().setName("Text_PaperHeight");
        this.fTextPaperWidth.addChangeListener((ChangeListener)this);
        this.fTextPaperHeight.addChangeListener((ChangeListener)this);
        Dimension dimension2 = this.fTextPaperWidth.getPreferredSize();
        dimension2.width = 60;
        this.fTextPaperWidth.setPreferredSize(dimension2);
        this.fTextPaperHeight.setPreferredSize(dimension2);
        mJPanel3.add((Component)mJLabel6, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel3.add((Component)mJLabel7, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 3, 3), 0, 0));
        mJPanel3.add((Component)this.fTextPaperWidth, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel3.add((Component)this.fTextPaperHeight, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 12, 2, new Insets(3, 3, 3, 3), 0, 0));
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        this.add((Component)mJPanel4, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel5.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("label.units")));
        mJPanel4.add((Component)mJPanel5, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 3, 0, 3), 0, 0));
        this.fRadBtnIn = new MJRadioButton(PrintExportPanel.sResHandle.getString("units.inches"));
        this.fRadBtnIn.setName("RadBtn_Inches");
        this.fRadBtnCm = new MJRadioButton(PrintExportPanel.sResHandle.getString("units.centimeters"));
        this.fRadBtnCm.setName("RadBtn_Centimeters");
        this.fRadBtnPts = new MJRadioButton(PrintExportPanel.sResHandle.getString("units.points"));
        this.fRadBtnPts.setName("RadBtn_Points");
        this.fRadBtnIn.addActionListener((ActionListener)this);
        this.fRadBtnCm.addActionListener((ActionListener)this);
        this.fRadBtnPts.addActionListener((ActionListener)this);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this.fRadBtnIn);
        buttonGroup2.add((AbstractButton)this.fRadBtnCm);
        buttonGroup2.add((AbstractButton)this.fRadBtnPts);
        mJPanel5.add((Component)this.fRadBtnIn, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 6), 0, 0));
        mJPanel5.add((Component)this.fRadBtnCm, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel5.add((Component)this.fRadBtnPts, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        MJPanel mJPanel6 = new MJPanel();
        mJPanel6.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.orientation")));
        mJPanel6.setLayout((LayoutManager)new GridBagLayout());
        mJPanel4.add((Component)mJPanel6, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 3, 3, 3), 0, 0));
        this.fRadBtnPortrait = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.por"));
        this.fRadBtnPortrait.setName("RadBtn_OrientPortrait");
        this.fRadBtnLandscape = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.lan"));
        this.fRadBtnLandscape.setName("RadBtn_OrientLandscape");
        this.fRadBtnRotated = new MJRadioButton(PrintExportPanel.sResHandle.getString("checkbox.rot"));
        this.fRadBtnRotated.setName("RadBtn_OrientRotated");
        this.fRadBtnPortrait.addActionListener((ActionListener)this);
        this.fRadBtnLandscape.addActionListener((ActionListener)this);
        this.fRadBtnRotated.addActionListener((ActionListener)this);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add((AbstractButton)this.fRadBtnPortrait);
        buttonGroup3.add((AbstractButton)this.fRadBtnLandscape);
        buttonGroup3.add((AbstractButton)this.fRadBtnRotated);
        mJPanel6.add((Component)this.fRadBtnPortrait, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 6), 0, 0));
        mJPanel6.add((Component)this.fRadBtnLandscape, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel6.add((Component)this.fRadBtnRotated, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        MJPanel mJPanel7 = new MJPanel();
        this.add((Component)mJPanel7, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.fTextPaperWidth)) {
            this.onPaperSizeChanged();
        } else if (object.equals(this.fTextPaperHeight)) {
            this.onPaperSizeChanged();
        } else if (object.equals(this.fPaperPosLeft) || object.equals(this.fPaperPosTop) || object.equals(this.fPaperPosWidth) || object.equals(this.fPaperPosHeight)) {
            this.onPaperPositionChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fComboPaperType)) {
            this.onPaperTypeChanged();
        } else if (object.equals(this.fRadBtnIn) || object.equals(this.fRadBtnCm) || object.equals(this.fRadBtnPts)) {
            this.onUnitsChanged();
        } else if (object.equals(this.fRadBtnPortrait) || object.equals(this.fRadBtnLandscape) || object.equals(this.fRadBtnRotated)) {
            this.onOrientationChanged();
        } else if (object.equals(this.fRadBtnModeAuto) || object.equals(this.fRadBtnModeManual)) {
            this.onPaperPositionModeChanged();
        } else if (object.equals(this.fBtnCenter)) {
            this.onPositionCenter();
        } else if (object.equals(this.fBtnFillPage)) {
            this.onPositionFillPage();
        } else if (object.equals(this.fBtnAspectRatio)) {
            this.onPositionAspectRatio();
        } else if (object.equals(this.fBtnDefaultSize)) {
            this.onPositionDefault();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("PaperType")) {
            this.setPaperType(PrintExportSettings.convertMatlabPaperType((String)object));
        } else if (string.equals("PaperSize")) {
            this.setPaperSize((double[])object);
        } else if (string.equals("PaperUnits")) {
            this.setUnits((String)object);
        } else if (string.equals("PaperOrientation")) {
            this.setOrientation(object.toString());
        } else if (string.equals("PaperPositionMode")) {
            this.setPaperPositionMode(object.toString());
        } else if (string.equals("PaperPosition")) {
            this.setPaperPosition((double[])object);
        }
    }

    private void onPaperTypeChanged() {
        String string = (String)this.fComboPaperType.getSelectedItem();
        this.fPrintSettings.setPaperType(this, string);
        this.fComboPaperType.removeItem((Object)"<custom>");
    }

    private void onPaperSizeChanged() {
        double[] dArray = new double[]{((Number)this.fTextPaperWidth.getValue()).doubleValue(), ((Number)this.fTextPaperHeight.getValue()).doubleValue()};
        this.fPrintSettings.setPaperSize(this, dArray);
    }

    private void onUnitsChanged() {
        String string = PrintExportSettings.MATLAB_PAPER_UNITS[0];
        if (this.fRadBtnCm.isSelected()) {
            string = PrintExportSettings.MATLAB_PAPER_UNITS[1];
        } else if (this.fRadBtnPts.isSelected()) {
            string = PrintExportSettings.MATLAB_PAPER_UNITS[2];
        }
        this.fPrintSettings.setUnits(this, string);
    }

    private void setPaperType(String string) {
        this.fComboPaperType.removeActionListener((ActionListener)this);
        if (string.equals("<custom>")) {
            int n = this.fComboPaperType.getItemCount();
            if (!this.fComboPaperType.getItemAt(n - 1).equals("<custom>")) {
                this.fComboPaperType.addItem((Object)"<custom>");
            }
        } else {
            this.fComboPaperType.removeItem((Object)"<custom>");
        }
        this.fComboPaperType.setSelectedItem((Object)string);
        this.fComboPaperType.addActionListener((ActionListener)this);
    }

    private void setPaperSize(double[] dArray) {
        this.fTextPaperWidth.removeChangeListener((ChangeListener)this);
        this.fTextPaperHeight.removeChangeListener((ChangeListener)this);
        this.fTextPaperWidth.setValue((Object)new Double(dArray[0]));
        this.fTextPaperHeight.setValue((Object)new Double(dArray[1]));
        this.fTextPaperWidth.addChangeListener((ChangeListener)this);
        this.fTextPaperHeight.addChangeListener((ChangeListener)this);
    }

    private void setUnits(String string) {
        this.fRadBtnIn.removeActionListener((ActionListener)this);
        this.fRadBtnCm.removeActionListener((ActionListener)this);
        this.fRadBtnPts.removeActionListener((ActionListener)this);
        if (string.equals(PrintExportSettings.MATLAB_PAPER_UNITS[0])) {
            this.fRadBtnIn.setSelected(true);
        } else if (string.equals(PrintExportSettings.MATLAB_PAPER_UNITS[1])) {
            this.fRadBtnCm.setSelected(true);
        } else {
            this.fRadBtnPts.setSelected(true);
        }
        this.fRadBtnIn.addActionListener((ActionListener)this);
        this.fRadBtnCm.addActionListener((ActionListener)this);
        this.fRadBtnPts.addActionListener((ActionListener)this);
    }

    private double getDefaultMargin() {
        int n = UnitPos.unitsToInt((String)this.fPrintSettings.getUnits());
        double[] dArray = this.fPrintSettings.convertUnits(0.25, 0.0, 0, n);
        return dArray[0];
    }

    private void onOrientationChanged() {
        String string = PrintExportSettings.MATLAB_PAPER_ORIENTATION_TYPES[0];
        if (this.fRadBtnLandscape.isSelected()) {
            string = PrintExportSettings.MATLAB_PAPER_ORIENTATION_TYPES[1];
        } else if (this.fRadBtnRotated.isSelected()) {
            string = PrintExportSettings.MATLAB_PAPER_ORIENTATION_TYPES[2];
        }
        this.fPrintSettings.setPaperOrientation(this, string);
    }

    private void setOrientation(String string) {
        this.fRadBtnPortrait.removeActionListener((ActionListener)this);
        this.fRadBtnLandscape.removeActionListener((ActionListener)this);
        this.fRadBtnRotated.removeActionListener((ActionListener)this);
        if (string.equals(PrintExportSettings.MATLAB_PAPER_ORIENTATION_TYPES[0])) {
            this.fRadBtnPortrait.setSelected(true);
        } else if (string.equals(PrintExportSettings.MATLAB_PAPER_ORIENTATION_TYPES[1])) {
            this.fRadBtnLandscape.setSelected(true);
        } else {
            this.fRadBtnRotated.setSelected(true);
        }
        this.fRadBtnPortrait.addActionListener((ActionListener)this);
        this.fRadBtnLandscape.addActionListener((ActionListener)this);
        this.fRadBtnRotated.addActionListener((ActionListener)this);
    }

    private void onPositionCenter() {
        double[] dArray = this.fPrintSettings.getPaperSize();
        double[] dArray2 = this.fPrintSettings.getPaperPosition();
        dArray2[0] = 0.5 * (dArray[0] - dArray2[2]);
        dArray2[1] = 0.5 * (dArray[1] - dArray2[3]);
        this.fPrintSettings.setPaperPosition(null, dArray2);
    }

    private void onPositionFillPage() {
        double[] dArray = this.fPrintSettings.getPaperSize();
        double d = this.getDefaultMargin();
        double[] dArray2 = new double[]{d, d, dArray[0] - 2.0 * d, dArray[1] - 2.0 * d};
        this.fPrintSettings.setPaperPosition(null, dArray2);
    }

    private void onPositionAspectRatio() {
        double[] dArray;
        double d;
        double[] dArray2 = this.fPrintSettings.getPaperPosition();
        double d2 = dArray2[2] / dArray2[3];
        if (d2 < (d = (dArray = this.fPrintSettings.getFigSize())[0] / dArray[1])) {
            dArray2[3] = dArray2[2] / d;
        } else {
            dArray2[2] = dArray2[3] * d;
        }
        this.fPrintSettings.setPaperPosition(null, dArray2);
    }

    private void onPositionDefault() {
        int n = UnitPos.unitsToInt((String)this.fPrintSettings.getUnits());
        double[] dArray = this.fPrintSettings.convertUnits(0.25, 2.5, 8.0, 6.0, 0, n);
        double[] dArray2 = this.fPrintSettings.getPaperSize();
        dArray[1] = dArray2[1] - dArray[3] - dArray[1];
        this.fPrintSettings.setPaperPosition(null, dArray);
    }

    private void onPaperPositionModeChanged() {
        boolean bl = this.fRadBtnModeManual.isSelected();
        String string = bl ? "manual" : "auto";
        this.fPrintSettings.setPaperPositionMode(this, string);
        this.setPaperPositionMode(string);
    }

    private void onPaperPositionChanged() {
        double[] dArray = new double[]{((Number)this.fPaperPosLeft.getValue()).doubleValue(), ((Number)this.fPaperPosTop.getValue()).doubleValue(), ((Number)this.fPaperPosWidth.getValue()).doubleValue(), ((Number)this.fPaperPosHeight.getValue()).doubleValue()};
        this.fPrintSettings.setPaperPosition(this, dArray);
    }

    private void setPaperPositionMode(String string) {
        boolean bl = string.equals("manual");
        if (bl) {
            this.fRadBtnModeManual.setSelected(true);
            this.fPaperPosTop.setEnabled(true);
            this.fPaperPosLeft.setEnabled(true);
            this.fPaperPosWidth.setEnabled(true);
            this.fPaperPosHeight.setEnabled(true);
            this.fBtnCenter.setEnabled(true);
            this.fBtnFillPage.setEnabled(true);
            this.fBtnAspectRatio.setEnabled(true);
            this.fBtnDefaultSize.setEnabled(true);
        } else {
            this.fRadBtnModeAuto.setSelected(true);
            this.fPaperPosTop.setEnabled(false);
            this.fPaperPosLeft.setEnabled(false);
            this.fPaperPosWidth.setEnabled(false);
            this.fPaperPosHeight.setEnabled(false);
            this.fBtnCenter.setEnabled(false);
            this.fBtnFillPage.setEnabled(false);
            this.fBtnAspectRatio.setEnabled(false);
            this.fBtnDefaultSize.setEnabled(false);
        }
    }

    private void setPaperPosition(double[] dArray) {
        this.fPaperPosLeft.removeChangeListener((ChangeListener)this);
        this.fPaperPosTop.removeChangeListener((ChangeListener)this);
        this.fPaperPosWidth.removeChangeListener((ChangeListener)this);
        this.fPaperPosHeight.removeChangeListener((ChangeListener)this);
        this.fPaperPosLeft.setValue((Object)new Double(dArray[0]));
        this.fPaperPosTop.setValue((Object)new Double(dArray[1]));
        this.fPaperPosWidth.setValue((Object)new Double(dArray[2]));
        this.fPaperPosHeight.setValue((Object)new Double(dArray[3]));
        this.fPaperPosLeft.addChangeListener((ChangeListener)this);
        this.fPaperPosTop.addChangeListener((ChangeListener)this);
        this.fPaperPosWidth.addChangeListener((ChangeListener)this);
        this.fPaperPosHeight.addChangeListener((ChangeListener)this);
    }
}

