/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.hg.types.HGStyledColor;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.graphics.ColorPicker;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import com.mathworks.util.Log;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class ColorControl
extends PropertyControl {
    protected ColorControlColorPicker fColor;

    public ColorControl(String string, CellEditorListener cellEditorListener, int n, int n2, String string2, String string3) {
        super(string, cellEditorListener);
        this.constructorHelper(n, n2, string2);
        this.setMaximumSize(new Dimension(this.fColor.getPreferredSize().width, this.fColor.getPreferredSize().height));
        this.fColor.setName(string3 + "." + string);
    }

    private void constructorHelper(int n, int n2, String string) {
        this.fColor = new ColorControlColorPicker(n, n2, string);
        this.setCustomEditor((JComponent)((Object)this.fColor));
    }

    @Override
    public String getName() {
        if (this.fColor != null) {
            return this.fColor.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public void addEditStoppedSupport() {
        this.fColor.setColorActionListener(this.action);
    }

    @Override
    public void applyChanges(Object[] objectArray) {
        final Object object = this.getDisplayedValue();
        if (object == null && this.getPropertyType().getName().endsWith("HGColor")) {
            try {
                final Object[] objectArray2 = objectArray;
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Object object2 : objectArray2) {
                            Method method = ColorControl.this.fProperty.getWriteMethod();
                            if (method == null) {
                                return;
                            }
                            try {
                                method.invoke(object2, object);
                            }
                            catch (Exception exception) {
                                Log.log((String)exception.toString());
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {
                this.showBeanException(exception);
            }
        } else {
            super.applyChanges(objectArray);
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = this.getPropertyType().getName();
        if (object == PropertyControl.MIXED_VALUES) {
            this.fColor.setValueWithoutEvents(null);
        } else if (object instanceof Color) {
            this.fColor.setValueWithoutEvents(object);
        } else if (object instanceof HGStyledColor) {
            StyledColor styledColor = ((HGStyledColor)object).colorValue();
            if (styledColor.isColor()) {
                this.fColor.setValueWithoutEvents(styledColor);
            } else {
                this.fColor.setValueWithoutEvents(styledColor.getStyleName());
            }
        } else if (object instanceof HGColor) {
            this.fColor.setValueWithoutEvents(HGColor.getColor((HGColor)((HGColor)object)));
        } else if (object instanceof HGMeshColor) {
            this.fColor.setValueWithoutEvents(HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        } else if (object == null && string.endsWith("HGColor")) {
            this.fColor.setValueWithoutEvents(null);
        }
    }

    @Override
    public Object getDisplayedValue() {
        Object object;
        Object object2 = this.fColor.getValue();
        String string = this.getPropertyType().getName();
        if (string.endsWith("MLArrayRef") || string.equals("java.lang.Object")) {
            string = MLPropertyTypeConverter.lookupDataType(this.getPropertyName(), this.getValue().getClass().getName());
        }
        if (object2 instanceof Color) {
            Color color = (Color)object2;
            if (string.equals("com.mathworks.hg.types.HGColor")) {
                float[] fArray = color.getRGBColorComponents(null);
                object = new HGColor((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            } else if (string.equals("com.mathworks.hg.types.HGMeshColor")) {
                float[] fArray = color.getRGBColorComponents(null);
                object = new HGMeshColor((double)fArray[0], (double)fArray[1], (double)fArray[2], 0);
            } else if (string.equals("com.mathworks.hg.types.HGStyledColor")) {
                float[] fArray = color.getRGBColorComponents(null);
                object = new HGStyledColor((double)fArray[0], (double)fArray[1], (double)fArray[2], ((HGStyledColor)this.getValue()).getAllowedStyles());
            } else {
                object = color;
            }
        } else if (object2 instanceof String && string.equals("com.mathworks.hg.types.HGMeshColor")) {
            int n = 0;
            if (object2.equals("flat")) {
                n = 1;
            } else if (object2.equals("interp")) {
                n = 2;
            } else if (object2.equals("texturemap")) {
                n = 3;
            } else if (object2.equals("auto")) {
                n = 4;
            }
            object = new HGMeshColor(n, 0);
        } else {
            object = object2 instanceof String && string.equals("com.mathworks.hg.types.HGStyledColor") ? new HGStyledColor((String)object2, ((HGStyledColor)this.getValue()).getAllowedStyles()) : (object2 instanceof String && string.endsWith("HGColor") ? null : object2);
        }
        return object;
    }

    public static class ColorControlColorPicker
    extends ColorPicker {
        private ActionListener iColorActionListener;

        public ColorControlColorPicker(int n, int n2, String string) {
            super(n, n2, string);
        }

        private void setColorActionListener(ActionListener actionListener) {
            this.iColorActionListener = actionListener;
        }

        public void setValue(Object object) {
            super.setValue(object);
            if (this.iColorActionListener != null) {
                this.iColorActionListener.actionPerformed(new ActionEvent((Object)this, 1001, ""));
            }
        }
    }
}

