/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.hg.types.HGPoint3;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.AbstractMultiFieldControl;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;

public class PositionControl
extends AbstractMultiFieldControl {
    protected MJTextField fXTF = new MJTextField();
    protected MJTextField fYTF = new MJTextField();
    protected MJTextField fZTF = new MJTextField();
    protected double[] fCurrentPosition = new double[3];
    private String fPrevXText;
    private String fPrevYText;
    private String fPrevZText;

    public PositionControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.setName(string2 + "." + string);
    }

    public void setName(String string) {
        if (this.fXTF != null && this.fYTF != null && this.fZTF != null) {
            this.fXTF.setName(string + ".X");
            this.fYTF.setName(string + ".Y");
            this.fZTF.setName(string + ".Z");
        }
    }

    private void constructorHelper() {
        this.fXTF.addFocusListener(this.focusLsnr);
        this.fYTF.addFocusListener(this.focusLsnr);
        this.fZTF.addFocusListener(this.focusLsnr);
        this.fXTF.addActionListener(this.actionLsnr);
        this.fYTF.addActionListener(this.actionLsnr);
        this.fZTF.addActionListener(this.actionLsnr);
        this.fXTF.addKeyListener((KeyListener)this.enterLsnr);
        this.fYTF.addKeyListener((KeyListener)this.enterLsnr);
        this.fZTF.addKeyListener((KeyListener)this.enterLsnr);
        GridLayout gridLayout = new GridLayout(1, 3, 5, 5);
        MJPanel mJPanel = new MJPanel((LayoutManager)gridLayout);
        mJPanel.add((Component)this.fXTF);
        mJPanel.add((Component)this.fYTF);
        mJPanel.add((Component)this.fZTF);
        this.setCustomEditor((JComponent)mJPanel);
        this.fXTF.setToolTipText("X");
        this.fYTF.setToolTipText("Y");
        this.fZTF.setToolTipText("Z");
    }

    @Override
    protected void doEventResponse(JTextField jTextField) {
        String string = jTextField.getText();
        boolean bl = jTextField.getName().endsWith("X");
        boolean bl2 = jTextField.getName().endsWith("Y");
        boolean bl3 = jTextField.getName().endsWith("Z");
        if (string == null || string.length() == 0) {
            if (bl) {
                this.fXTF.setText(this.fPrevXText);
                this.fXTF.requestFocus();
            } else if (bl2) {
                this.fYTF.setText(this.fPrevYText);
                this.fYTF.requestFocus();
            } else if (bl3) {
                this.fZTF.setText(this.fPrevZText);
                this.fZTF.requestFocus();
            }
            return;
        }
        if (!string.equals((String)PropertyControl.MIXED_VALUES)) {
            double d;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString("PropertyControl.error.parse"), string), this.getTopLevelAncestor());
                if (bl) {
                    this.fXTF.setText(this.fPrevXText);
                    this.fXTF.requestFocus();
                } else if (bl2) {
                    this.fYTF.setText(this.fPrevYText);
                    this.fYTF.requestFocus();
                } else if (bl3) {
                    this.fZTF.setText(this.fPrevZText);
                    this.fZTF.requestFocus();
                }
                return;
            }
            if (bl) {
                this.fCurrentPosition[0] = d;
            } else if (bl2) {
                this.fCurrentPosition[1] = d;
            } else if (bl3) {
                this.fCurrentPosition[2] = d;
            }
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (object == null) {
            string = this.fPrevXText;
            string2 = this.fPrevYText;
            string3 = this.fPrevZText;
        } else if (object == PropertyControl.MIXED_VALUES) {
            string2 = string3 = (String)PropertyControl.MIXED_VALUES;
            string = string3;
        } else if (object instanceof HGPoint3) {
            HGPoint3 hGPoint3 = (HGPoint3)object;
            this.fCurrentPosition[0] = hGPoint3.getX();
            this.fCurrentPosition[1] = hGPoint3.getY();
            this.fCurrentPosition[2] = hGPoint3.getZ();
            string = this.fNumberFormat.format(hGPoint3.getX());
            string2 = this.fNumberFormat.format(hGPoint3.getY());
            string3 = this.fNumberFormat.format(hGPoint3.getZ());
        }
        this.fPrevXText = string;
        this.fPrevYText = string2;
        this.fPrevZText = string3;
        this.fXTF.setText(string);
        this.fYTF.setText(string2);
        this.fZTF.setText(string3);
    }

    @Override
    public Object getDisplayedValue() {
        HGPoint3 hGPoint3 = new HGPoint3(this.fCurrentPosition[0], this.fCurrentPosition[1], this.fCurrentPosition[2]);
        return hGPoint3;
    }

    @Override
    public void addEditStoppedSupport() {
        this.fXTF.addActionListener(this.action);
        this.fXTF.addFocusListener((FocusListener)this.focus);
        this.fXTF.addKeyListener((KeyListener)this.enterKey);
        this.fYTF.addActionListener(this.action);
        this.fYTF.addFocusListener((FocusListener)this.focus);
        this.fYTF.addKeyListener((KeyListener)this.enterKey);
        this.fZTF.addActionListener(this.action);
        this.fZTF.addFocusListener((FocusListener)this.focus);
        this.fZTF.addKeyListener((KeyListener)this.enterKey);
    }

    public void setEnabled(boolean bl) {
        this.fXTF.setEnabled(bl);
        this.fYTF.setEnabled(bl);
        this.fZTF.setEnabled(bl);
    }

    @Override
    protected void propertyEditStopped() {
        if (this.fXTF.getText().equals(PropertyControl.MIXED_VALUES) || this.fYTF.getText().equals(PropertyControl.MIXED_VALUES) || this.fZTF.getText().equals(PropertyControl.MIXED_VALUES)) {
            return;
        }
        super.propertyEditStopped();
    }
}

