/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.BuildManager;
import com.mathworks.toolbox.coder.app.TabbedOutputContext;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.mi.FevalCommand;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class AbstractMexBuildManager
implements BuildManager {
    private final Configuration fConfiguration;
    private final TabbedOutputContext fOutputContext;
    private final Runnable fNotifyOnBuild;
    private final Runnable fEnterReadyState;
    private final String fBuildFunction;
    private final int fOutputCount;
    private final int fSuccessOutputIndex;
    private final int fErrorListOutputIndex;
    private final int fFatalErrorMessageOutputIndex;
    private final String fBuildingStatusMessage;
    private final String fUpdatingStatusMessage;
    private final Collection<ParameterRunnable<Boolean>> fBuildCallbacks;

    public AbstractMexBuildManager(Configuration configuration, TabbedOutputContext tabbedOutputContext, String string, int n, int n2, int n3, int n4, String string2, String string3) {
        this(configuration, tabbedOutputContext, string, n, n2, n3, n4, string2, string3, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public AbstractMexBuildManager(Configuration configuration, TabbedOutputContext tabbedOutputContext, String string, int n, int n2, int n3, int n4, String string2, String string3, Runnable runnable, Runnable runnable2) {
        this.fConfiguration = configuration;
        this.fOutputContext = tabbedOutputContext;
        this.fBuildFunction = string;
        this.fOutputCount = n;
        this.fSuccessOutputIndex = n2;
        this.fErrorListOutputIndex = n3;
        this.fFatalErrorMessageOutputIndex = n4;
        this.fBuildingStatusMessage = string2;
        this.fUpdatingStatusMessage = string3;
        this.fNotifyOnBuild = runnable;
        this.fEnterReadyState = runnable2;
        this.fBuildCallbacks = new LinkedList<ParameterRunnable<Boolean>>();
    }

    protected abstract Object[] getBuildArguments();

    @Override
    public final void forceBuild() {
        FevalCommand fevalCommand = new FevalCommand(this.fBuildingStatusMessage, this.fBuildFunction, this.getBuildArguments());
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fConfiguration, (Command[])new Command[]{fevalCommand});
        this.fOutputContext.runWithLog("build", CoderResources.getString("f2f.tab.buildOutput"), deploymentProcess, new Runnable(){

            @Override
            public void run() {
                AbstractMexBuildManager.this.forceBuild();
            }
        }, CoderResources.getString("f2f.action.retryBuild"), new SuccessChecker());
    }

    @Override
    public final void doInitialBuildIfNecessary() {
        ParameterRunnable<Boolean> parameterRunnable = new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                if (bl.booleanValue()) {
                    MJUtilities.runOnEventDispatchThread((Runnable)AbstractMexBuildManager.this.fEnterReadyState);
                    return;
                }
                FevalCommand fevalCommand = new FevalCommand(AbstractMexBuildManager.this.fBuildingStatusMessage, AbstractMexBuildManager.this.fBuildFunction, AbstractMexBuildManager.this.getBuildArguments()){

                    @Override
                    protected boolean checkForSuccess(Object object, CommandStatus commandStatus) {
                        return AbstractMexBuildManager.this.checkForBuildSuccess(object, this, commandStatus);
                    }

                    @Override
                    protected void handleResult(Object object) {
                        MJUtilities.runOnEventDispatchThread((Runnable)AbstractMexBuildManager.this.fEnterReadyState);
                    }
                };
                fevalCommand.setOutputCount(AbstractMexBuildManager.this.fOutputCount);
                fevalCommand.setFatalErrorMessageIndex(AbstractMexBuildManager.this.fFatalErrorMessageOutputIndex);
                DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)AbstractMexBuildManager.this.fConfiguration, (Command[])new Command[]{fevalCommand});
                AbstractMexBuildManager.this.fOutputContext.runWithLog("build", CoderResources.getString("f2f.tab.buildOutput"), deploymentProcess, new Runnable(){

                    @Override
                    public void run() {
                        AbstractMexBuildManager.this.doInitialBuildIfNecessary();
                    }
                }, CoderResources.getString("f2f.action.retryBuild"), new SuccessChecker());
            }
        };
        if (this.shouldForceInitialBuild()) {
            parameterRunnable.run((Object)false);
        } else {
            this.checkInstrumentedMex(parameterRunnable);
        }
    }

    @Override
    public final void buildIfNecessaryAndRun(final Runnable runnable) {
        this.checkInstrumentedMex(new ParameterRunnable<Boolean>(){

            public void run(final Boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!bl.booleanValue()) {
                            FevalCommand fevalCommand = new FevalCommand(AbstractMexBuildManager.this.fUpdatingStatusMessage, AbstractMexBuildManager.this.fBuildFunction, AbstractMexBuildManager.this.getBuildArguments()){

                                @Override
                                protected boolean checkForSuccess(Object object, CommandStatus commandStatus) {
                                    return AbstractMexBuildManager.this.checkForBuildSuccess(object, this, commandStatus);
                                }

                                @Override
                                protected void handleResult(Object object) {
                                    AbstractMexBuildManager.this.updateFinished();
                                }
                            };
                            fevalCommand.setOutputCount(6);
                            fevalCommand.setFatalErrorMessageIndex(5);
                            DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)AbstractMexBuildManager.this.fConfiguration, (Command[])new Command[]{fevalCommand});
                            deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){

                                public void finished() {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            runnable.run();
                                        }
                                    });
                                }
                            });
                            AbstractMexBuildManager.this.fOutputContext.runWithLog("build", CoderResources.getString("f2f.tab.buildOutput"), deploymentProcess, new Runnable(){

                                @Override
                                public void run() {
                                    AbstractMexBuildManager.this.buildIfNecessaryAndRun(runnable);
                                }
                            }, CoderResources.getString("f2f.action.retryBuild"), new SuccessChecker());
                        } else {
                            runnable.run();
                        }
                    }
                });
            }
        });
    }

    @Override
    public final void buildIfNecessaryAndRun(final String string, final String string2, final DeploymentProcess deploymentProcess) {
        this.buildIfNecessaryAndRun(new Runnable(){

            @Override
            public void run() {
                AbstractMexBuildManager.this.fOutputContext.runWithLog(string, string2, deploymentProcess);
            }
        });
    }

    public final void checkInstrumentedMex(final ParameterRunnable<Boolean> parameterRunnable) {
        File file = this.getMexFile();
        if (file == null || !file.exists()) {
            parameterRunnable.run((Object)false);
        } else {
            String string = this.getLastMexInputChecksum();
            if (string == null || !string.equals(this.generateMexInputChecksum())) {
                parameterRunnable.run((Object)false);
            } else if (this.isUseStrictMexValidation()) {
                new Matlab().feval("emlcprivate", new Object[]{"isMexFileUpToDate", file.getAbsolutePath()}, 1, new CompletionObserver(){

                    public void completed(int n, final Object object) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                parameterRunnable.run((Object)((boolean[])object)[0]);
                            }
                        });
                    }
                });
            } else {
                parameterRunnable.run((Object)true);
            }
        }
    }

    public final void addBuildCallback(ParameterRunnable<Boolean> parameterRunnable) {
        this.fBuildCallbacks.add(parameterRunnable);
    }

    private void fireBuildCompleted(boolean bl) {
        for (ParameterRunnable<Boolean> parameterRunnable : this.fBuildCallbacks) {
            parameterRunnable.run((Object)bl);
        }
    }

    private boolean checkForBuildSuccess(final Object object, Command command, CommandStatus commandStatus) {
        final Object[] objectArray = (Object[])object;
        final boolean bl = ((boolean[])objectArray[this.fSuccessOutputIndex])[0];
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractMexBuildManager.this.handleBuildOutput(objectArray);
                List<BuildError> list = ConversionUtils.convertErrors(((Object[])object)[AbstractMexBuildManager.this.fErrorListOutputIndex]);
                if (!list.isEmpty()) {
                    AbstractMexBuildManager.this.fOutputContext.showErrors("build", "build-errors", CoderResources.getString("f2f.errors.build"), true, false, null, list);
                }
                if (bl) {
                    AbstractMexBuildManager.this.updateMexInputChecksum();
                }
                AbstractMexBuildManager.this.fNotifyOnBuild.run();
                AbstractMexBuildManager.this.fireBuildCompleted(bl);
            }
        });
        if (!bl) {
            commandStatus.failed(new CommandExecutionException(command));
            return false;
        }
        return true;
    }

    protected abstract void handleBuildOutput(Object[] var1);

    protected boolean shouldForceInitialBuild() {
        return false;
    }

    protected void updateFinished() {
    }

    protected boolean isUseStrictMexValidation() {
        return true;
    }

    public abstract File getMexFile();

    protected abstract String getLastMexInputChecksum();

    protected abstract String generateMexInputChecksum();

    protected abstract void updateMexInputChecksum();

    private static class SuccessChecker
    implements Predicate<BufferedLogSource> {
        private SuccessChecker() {
        }

        public boolean accept(BufferedLogSource bufferedLogSource) {
            return !bufferedLogSource.getPlainText().contains("Warning");
        }
    }
}

