/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.workflowui.WorkflowSplitPane;
import com.mathworks.toolbox.coder.app.BuildErrorTable;
import com.mathworks.toolbox.coder.app.BuildManager;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.NotificationManager;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.PopupBar;
import com.mathworks.toolbox.coder.app.PopupBarAdapter;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.app.TabbedPane;
import com.mathworks.toolbox.coder.app.ide.EditManager;
import com.mathworks.toolbox.coder.app.ide.EditorFileViewProvider;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCodeInfoView {
    private final Window fParent;
    private final GlassPaneManager fGlassPane;
    private final Animator fAnimator;
    private final MJPanel fComponent;
    private final NotificationManager fNotificationManager;
    private final EditorView fCodePane;
    private final MulticastChangeListener fChangeListeners;
    private final FindAdapter fFindAdapter;
    private final PopupBarManager fPopupBarManager;
    private final MJPanel fSplitPaneAndPopupBar;
    private final ChangeListener fOutputPaneListener;
    private final boolean fUseLeftBorder;
    private OutputPane fOutputPane;
    private BuildManager fBuildManager;
    private WorkflowSplitPane fSplitPane;
    private int fPreferredWidth;
    private boolean fActivated;
    private boolean fPopupBarStretched;

    protected AbstractCodeInfoView(Window window, GlassPaneManager glassPaneManager, Animator animator, boolean bl) {
        this(window, glassPaneManager, animator, bl, false);
    }

    protected AbstractCodeInfoView(Window window, GlassPaneManager glassPaneManager, Animator animator, boolean bl, boolean bl2) {
        this.fParent = window;
        this.fGlassPane = glassPaneManager;
        this.fNotificationManager = new NotificationManager(glassPaneManager);
        this.fAnimator = animator;
        this.fUseLeftBorder = bl;
        this.fComponent = new MJPanel(){

            public void removeNotify() {
                super.removeNotify();
                AbstractCodeInfoView.this.fPopupBarManager.closePopup();
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(AbstractCodeInfoView.this.fPreferredWidth + 10, dimension.height);
            }
        };
        this.fNotificationManager.setComponent((JComponent)this.fComponent);
        this.fChangeListeners = new MulticastChangeListener();
        this.fFindAdapter = new FindAdapter(){

            @Override
            public int find(String string) {
                AbstractCodeInfoView.this.filterInfo(string);
                return AbstractCodeInfoView.this.fCodePane.find(string);
            }

            @Override
            public void findNext() {
                AbstractCodeInfoView.this.fCodePane.findNext();
            }

            @Override
            public void clearSearch() {
                AbstractCodeInfoView.this.clearInfoFilter();
                AbstractCodeInfoView.this.fCodePane.clearSearch();
            }
        };
        this.fPopupBarManager = new PopupBarManager(animator, this.fFindAdapter);
        this.fPopupBarManager.setHintProvider(this.createHintProvider(this.fPopupBarManager, this.fFindAdapter));
        this.fPopupBarManager.getPopupBar().addPopupBarListener(new PopupBarAdapter(){

            @Override
            public void popupBarWillCollapse(PopupBar popupBar) {
                AbstractCodeInfoView.this.setPopupBarStretched(false, null);
            }
        });
        this.fCodePane = new EditorView(this.fGlassPane, null, this.fPopupBarManager, this.createEditorFileViewProvider(), this.createEntityLocator(), bl2, true){

            @Override
            protected void selectionChanged(Function function) {
                AbstractCodeInfoView.this.handleFunctionSelectionFromCode(function);
            }

            @Override
            protected void postInitializeTextPane(final SyntaxTextPane syntaxTextPane, final Function function) {
                final 4 var3_3 = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setPopupController(AbstractCodeInfoView.this.createCodePopupController(AbstractCodeInfoView.this.fParent, var3_3, syntaxTextPane, function));
                    }
                });
            }

            @Override
            protected void preShowContextMenu() {
                AbstractCodeInfoView.this.preShowCodeContextMenu();
            }
        };
        this.fSplitPaneAndPopupBar = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fSplitPaneAndPopupBar.add((Component)this.fPopupBarManager.getPopupBarComponent(), (Object)"North");
        this.fChangeListeners.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AbstractCodeInfoView.this.getOutputPane().isRunningTask()) {
                    AbstractCodeInfoView.this.fSplitPane.setBottomVisible(true);
                }
            }
        });
        this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fComponent.add((Component)this.fSplitPaneAndPopupBar, (Object)"Center");
        this.fOutputPaneListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractCodeInfoView.this.fireChange();
            }
        };
        this.setOutputPane(null);
        this.configureEditor(this.fCodePane);
        this.installFindSupport();
        this.fireChange();
    }

    protected void configureEditor(final EditorView editorView) {
        EditManager editManager = new EditManager(null);
        editManager.setHandler(new EditManager.EditStateMediator(){

            @Override
            public void fileOutdated(EditorLoadContext editorLoadContext, boolean bl) {
                editorView.reload();
            }

            @Override
            public void fileSaving(EditorLoadContext editorLoadContext, boolean bl, boolean bl2, @NotNull ParameterRunnable<Boolean> parameterRunnable) {
                parameterRunnable.run((Object)true);
                editorView.reload();
            }

            @Override
            public void fileSavingErrored(EditorLoadContext editorLoadContext, IOException iOException) {
                editorView.reload();
            }
        });
        editorView.setEditManager(editManager);
        editorView.setEditable(false);
    }

    protected void setOutputPane(@Nullable OutputPane outputPane) {
        if (this.fOutputPane != null) {
            this.fOutputPane.removeChangeListener(this.fOutputPaneListener);
        }
        if (outputPane == null) {
            outputPane = new OutputPane(this.fPopupBarManager, this.fCodePane, this.fUseLeftBorder, new ParameterRunnable<TabbedPane>(){

                public void run(TabbedPane tabbedPane) {
                    AbstractCodeInfoView.this.initializeTabbedPane(tabbedPane);
                }
            }, new ParameterRunnable<OutputPane.ErrorContext>(){

                public void run(OutputPane.ErrorContext errorContext) {
                    AbstractCodeInfoView.this.showBuildError(errorContext.getError(), errorContext.getErrorTable());
                }
            });
        }
        this.fOutputPane = outputPane;
        this.fOutputPane.addChangeListener(this.fOutputPaneListener);
        this.fPopupBarManager.setOutputPane(this.fOutputPane);
        this.fBuildManager = this.createBuildManager(this.fOutputPane);
        this.rebuildSplitPane(this.fCodePane.getComponent(), this.fOutputPane.getComponent());
    }

    protected void rebuildSplitPane(Component component, Component component2) {
        if (this.fSplitPane != null) {
            this.fSplitPaneAndPopupBar.remove((Component)this.fSplitPane.getComponent());
        }
        this.fSplitPane = new WorkflowSplitPane(component, component2, 200);
        this.fSplitPaneAndPopupBar.add((Component)this.fSplitPane.getComponent());
    }

    public final JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fCodePane.dispose();
        this.fOutputPane.dispose();
    }

    public final void activate() {
        this.fActivated = true;
        this.fBuildManager.doInitialBuildIfNecessary();
    }

    public final boolean isActivated() {
        return this.fActivated;
    }

    public final void resetActivation() {
        this.fActivated = false;
    }

    public final DeploymentProcess getCurrentProcess() {
        return this.fOutputPane.getCurrentProcess();
    }

    public final OutputPane getOutputPane() {
        return this.fOutputPane;
    }

    public final BuildManager getBuildManager() {
        return this.fBuildManager;
    }

    public final EditorView getEditorView() {
        return this.fCodePane;
    }

    public final Window getParent() {
        return this.fParent;
    }

    public final GlassPaneManager getGlassPaneManager() {
        return this.fGlassPane;
    }

    public final NotificationManager getNotificationManager() {
        return this.fNotificationManager;
    }

    public final PopupBarManager getPopupBarManager() {
        return this.fPopupBarManager;
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public final void fireChange() {
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public final void incrementPreferredWidth(double d) {
        this.fPreferredWidth = (int)((double)this.fPreferredWidth + d);
    }

    protected abstract PopupHintProvider createHintProvider(PopupBarManager var1, FindAdapter var2);

    protected boolean isFunctionInTargetCodeBase(Function function) {
        return false;
    }

    protected void filterInfo(String string) {
    }

    protected void clearInfoFilter() {
    }

    protected void preShowCodeContextMenu() {
    }

    protected void forceFunctionSelection(Function function) {
    }

    protected void handleFunctionSelectionFromCode(Function function) {
    }

    protected abstract BuildManager createBuildManager(OutputPane var1);

    protected abstract CodePopupController createCodePopupController(Window var1, EditorView var2, SyntaxTextPane var3, Function var4);

    protected abstract FunctionScopedEntityLocator createEntityLocator();

    protected abstract void initializeTabbedPane(TabbedPane var1);

    protected EditorFileViewProvider createEditorFileViewProvider() {
        return new EditorFileViewProvider(new String[0]);
    }

    protected final void showBuildError(BuildError buildError, final BuildErrorTable buildErrorTable) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                buildErrorTable.clearSelection();
            }
        };
        if (buildError.getFunction() != null && CoderFileSupport.isMatlabSourceFile(buildError.getFunction().getFile())) {
            boolean bl = !this.isEntryPoint(buildError.getFunction().getFile()) && !this.isFunctionInTargetCodeBase(buildError.getFunction());
            this.showErrorInCodePane(buildError, bl, runnable);
            this.forceFunctionSelection(buildError.getFunction());
        } else if (buildError.getFunction() == null && buildError.getErrorSourceCode() != null) {
            this.showErrorInCodePane(buildError, true, runnable);
        }
    }

    protected void showErrorInCodePane(BuildError buildError, boolean bl, Runnable runnable) {
        this.fCodePane.displayError(buildError, true, runnable);
    }

    protected abstract boolean isEntryPoint(File var1);

    private void installFindSupport() {
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.getInputMap(1).put(KeyStroke.getKeyStroke(70, 256), "find");
        } else {
            this.fComponent.getInputMap(1).put(KeyStroke.getKeyStroke(70, 128), "find");
        }
        this.fComponent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "closePopup");
        this.fComponent.getActionMap().put("find", (Action)new MJAbstractAction("find"){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractCodeInfoView.this.fPopupBarManager.doFind();
            }
        });
        this.fComponent.getActionMap().put("closePopup", (Action)new MJAbstractAction("closePopup"){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractCodeInfoView.this.fPopupBarManager.closePopup();
            }
        });
    }

    public void setPopupBarStretched(final boolean bl, final Runnable runnable) {
        if (bl == this.fPopupBarStretched) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        this.fPopupBarStretched = bl;
        final JComponent jComponent = this.fPopupBarManager.getPopupBarComponent();
        final Holder holder = new Holder((Object)0.0);
        final int n = bl ? this.fPopupBarManager.getPopupBarComponent().getHeight() : ((Component)jComponent).getPreferredSize().height;
        final MJPanel mJPanel = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (jComponent.getParent() == this) {
                    int n2 = this.getHeight() - n;
                    AbstractCodeInfoView.this.fPopupBarManager.getPopupBarComponent().setBounds(0, 0, this.getWidth(), (int)((double)n + (double)n2 * (Double)holder.get()));
                }
            }
        };
        mJPanel.setLayout(null);
        mJPanel.add((Component)jComponent);
        this.fSplitPaneAndPopupBar.removeAll();
        this.fSplitPaneAndPopupBar.add((Component)mJPanel, (Object)"Center");
        this.fSplitPaneAndPopupBar.revalidate();
        this.fSplitPaneAndPopupBar.repaint();
        this.fAnimator.animate(AnimationTrack.ACCELERATING, new Animation(){

            @Override
            public void step(double d) {
                holder.set((Object)(bl ? d : 1.0 - d));
                if (d == 1.0 && !bl) {
                    AbstractCodeInfoView.this.fSplitPaneAndPopupBar.removeAll();
                    AbstractCodeInfoView.this.fSplitPaneAndPopupBar.add(jComponent, (Object)"North");
                    AbstractCodeInfoView.this.fSplitPaneAndPopupBar.add((Component)AbstractCodeInfoView.this.fSplitPane.getComponent(), (Object)"Center");
                    AbstractCodeInfoView.this.fSplitPaneAndPopupBar.revalidate();
                    AbstractCodeInfoView.this.fSplitPaneAndPopupBar.repaint();
                } else {
                    mJPanel.revalidate();
                    mJPanel.repaint();
                }
                if (d == 1.0 && runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    static {
        MJUtilities.initJIDE();
    }
}

