/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.fixedpoint.ActionWithPopupMenu;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.ToolstripPopupUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;

public class RunSimulationAction
extends MJAbstractAction
implements ActionWithPopupMenu {
    private final Window fParent;
    private final FixedPointController fController;
    private final OutputPane fOutputPane;
    private final Runnable fContinuation;
    private TSSplitButton fButton;
    private PopupList fList;

    public RunSimulationAction(Window window, FixedPointController fixedPointController, OutputPane outputPane, Runnable runnable) {
        super(CoderResources.getString("f2f.action.runSimulation"), CoderResources.getIcon("run_simulation.png"));
        this.fParent = window;
        this.fContinuation = runnable;
        this.fController = fixedPointController;
        this.fOutputPane = outputPane;
        this.setTip(CoderResources.getString("f2f.action.runSimulation.tooltip"));
        this.setComponentName("f2f.action.runSimulation");
    }

    public void setButton(TSSplitButton tSSplitButton) {
        this.fButton = tSSplitButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.tryToRun();
    }

    public boolean tryToRun() {
        this.fController.preRun();
        ToolstripPopupUtils.closePopup(this.fList);
        this.fList = null;
        FixedPointDataAdapter fixedPointDataAdapter = this.fController.getData();
        Set<File> set = fixedPointDataAdapter.getSimulationTestFiles().getFiles();
        Set<File> set2 = fixedPointDataAdapter.getSimulationTestFiles().getExcludedFiles();
        if (set.isEmpty()) {
            return this.chooseFileAndRun();
        }
        if (set2.containsAll(set)) {
            this.fButton.doDropDownClick();
            return false;
        }
        this.run();
        return true;
    }

    public void run() {
        this.fController.runSimulation(new Runnable(){

            @Override
            public void run() {
                RunSimulationAction.this.fOutputPane.activateTab("table");
                RunSimulationAction.this.fContinuation.run();
            }
        });
    }

    @Override
    public void showPopup(PopupListener.PopupCallback popupCallback) {
        this.fList = new PopupList();
        this.fList.setName("f2f.runSimulation.popup");
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        this.fList.setModel(defaultListModel);
        this.fList.setListStyle(ListStyle.ICON_TEXT);
        final FixedPointDataAdapter fixedPointDataAdapter = this.fController.getData();
        final HashMap<ListItem, Runnable> hashMap = new HashMap<ListItem, Runnable>();
        ToolstripPopupUtils.addMultiSelectTestFileList(this.fList, this.fParent, defaultListModel, fixedPointDataAdapter, fixedPointDataAdapter.getSimulationTestFiles(), hashMap);
        ListItem listItem = new ListItem("OPTIONS");
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.options"));
        listItem.setAttribute((Attribute)ListItem.HEADER, (Object)true);
        defaultListModel.addElement(listItem);
        ListItem listItem2 = new ListItem("logHistogramData");
        listItem2.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.logHistogramData"));
        listItem2.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem2.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)fixedPointDataAdapter.isHistogramLoggingEnabled());
        defaultListModel.addElement(listItem2);
        ListItem listItem3 = new ListItem("showCoverage");
        listItem3.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.showCoverage"));
        listItem3.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem3.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)fixedPointDataAdapter.isCoverageEnabled());
        defaultListModel.addElement(listItem3);
        hashMap.put(listItem2, new Runnable(){

            @Override
            public void run() {
                fixedPointDataAdapter.setHistogramLoggingEnabled(!fixedPointDataAdapter.isHistogramLoggingEnabled());
                OverlayManager overlayManager = OverlayManagers.get((Component)RunSimulationAction.this.fList);
                if (overlayManager != null) {
                    overlayManager.packOverlay((Component)RunSimulationAction.this.fList);
                }
            }
        });
        hashMap.put(listItem3, new Runnable(){

            @Override
            public void run() {
                fixedPointDataAdapter.setCoverageEnabled(!fixedPointDataAdapter.isCoverageEnabled());
                OverlayManager overlayManager = OverlayManagers.get((Component)RunSimulationAction.this.fList);
                if (overlayManager != null) {
                    overlayManager.packOverlay((Component)RunSimulationAction.this.fList);
                }
            }
        });
        this.fList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                ((Runnable)hashMap.get(listActionEvent.getListItem())).run();
            }
        });
        popupCallback.show((JComponent)this.fList);
        OverlayManager overlayManager = OverlayManagers.get((Component)this.fList);
        if (overlayManager != null) {
            overlayManager.setAllowMultiSelect((Component)this.fList, true);
        }
    }

    private boolean chooseFileAndRun() {
        final Holder holder = new Holder((Object)false);
        final FixedPointDataAdapter fixedPointDataAdapter = this.fController.getData();
        TestFileSelectorPanel.browseForTestFile(this.fParent, fixedPointDataAdapter.getConfiguration(), new ParameterRunnable<File>(){

            public void run(File file) {
                fixedPointDataAdapter.setDefaultTestFile(file);
                holder.set((Object)true);
                RunSimulationAction.this.run();
            }
        }, new Runnable(){

            @Override
            public void run() {
                holder.set((Object)false);
            }
        });
        return (Boolean)holder.get();
    }
}

