/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.model.TestFileSubset;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public final class ToolstripPopupUtils {
    private ToolstripPopupUtils() {
    }

    public static void addMultiSelectTestFileList(final PopupList popupList, final Window window, final DefaultListModel defaultListModel, final FixedPointDataAdapter fixedPointDataAdapter, final TestFileSubset testFileSubset, final Map<ListItem, Runnable> map) {
        ArrayList<File> arrayList = new ArrayList<File>(fixedPointDataAdapter.getTestFiles());
        ListItem listItem = new ListItem("FILES");
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.verify.files"));
        listItem.setAttribute((Attribute)ListItem.HEADER, (Object)true);
        defaultListModel.addElement(listItem);
        Set<File> set = testFileSubset.getExcludedFiles();
        int n = 1;
        for (File file : arrayList) {
            ToolstripPopupUtils.addItem(popupList, defaultListModel, file, testFileSubset, set, map, n++);
        }
        ListItem listItem2 = new ListItem("add");
        listItem2.setAttribute((Attribute)ListItem.ICON, (Object)CoderResources.getIcon("open_ts_16.png"));
        listItem2.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.verify.add"));
        defaultListModel.addElement(listItem2);
        map.put(listItem2, new Runnable(){

            @Override
            public void run() {
                ToolstripPopupUtils.chooseAndAddFile(window, popupList, defaultListModel, fixedPointDataAdapter, testFileSubset, map);
            }
        });
        popupList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                final int n = popupList.locationToIndex(mouseEvent.getPoint());
                if (!SwingUtilities.isLeftMouseButton(mouseEvent) && n > 0 && n <= fixedPointDataAdapter.getTestFiles().size()) {
                    MJPopupMenu mJPopupMenu = new MJPopupMenu();
                    mJPopupMenu.setName("f2f.testfile.popup");
                    MJMenuItem mJMenuItem = new MJMenuItem(CoderResources.getString("f2f.testFile.remove"));
                    mJMenuItem.setName("f2f.testfile.remove");
                    mJMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ToolstripPopupUtils.remove(popupList, defaultListModel, fixedPointDataAdapter, n);
                        }
                    });
                    mJPopupMenu.add((JMenuItem)mJMenuItem);
                    mJPopupMenu.show((Component)popupList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        popupList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (keyEvent.getKeyCode() == 127 && (n = popupList.getSelectedIndex()) > 0 && n <= fixedPointDataAdapter.getTestFiles().size()) {
                    ToolstripPopupUtils.remove(popupList, defaultListModel, fixedPointDataAdapter, n);
                }
            }
        });
    }

    private static void chooseAndAddFile(Window window, final PopupList popupList, final DefaultListModel defaultListModel, FixedPointDataAdapter fixedPointDataAdapter, final TestFileSubset testFileSubset, final Map<ListItem, Runnable> map) {
        final Set<File> set = fixedPointDataAdapter.getTestFiles();
        TestFileSelectorPanel.browseForTestFile(window, fixedPointDataAdapter.getConfiguration(), new ParameterRunnable<File>(){

            public void run(File file) {
                if (!set.contains(file)) {
                    int n = new ArrayList<File>(testFileSubset.getFiles()).indexOf(file) + 1;
                    ToolstripPopupUtils.addItem(popupList, defaultListModel, file, testFileSubset, testFileSubset.getExcludedFiles(), map, n);
                    ToolstripPopupUtils.packPopup(popupList);
                }
            }
        });
    }

    private static void packPopup(PopupList popupList) {
        popupList.revalidate();
        popupList.repaint();
        OverlayManager overlayManager = OverlayManagers.get((Component)popupList);
        if (overlayManager != null) {
            overlayManager.packOverlay((Component)popupList);
        }
    }

    private static void addItem(final PopupList popupList, DefaultListModel defaultListModel, final File file, final TestFileSubset testFileSubset, Set<File> set, Map<ListItem, Runnable> map, int n) {
        ListItem listItem = new ListItem(file.getName());
        Icon icon = UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
        listItem.setAttribute((Attribute)ListItem.DESCRIPTION, (Object)file.getAbsolutePath());
        listItem.setAttribute((Attribute)ListItem.ICON, (Object)icon);
        listItem.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)(!set.contains(file) ? 1 : 0));
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)file.getName());
        defaultListModel.add(n, listItem);
        map.put(listItem, new Runnable(){

            @Override
            public void run() {
                testFileSubset.toggleIncluded(file);
                popupList.revalidate();
                popupList.repaint();
            }
        });
    }

    private static void remove(PopupList popupList, DefaultListModel defaultListModel, FixedPointDataAdapter fixedPointDataAdapter, int n) {
        defaultListModel.remove(n);
        popupList.revalidate();
        popupList.repaint();
        ArrayList<File> arrayList = new ArrayList<File>(fixedPointDataAdapter.getTestFiles());
        fixedPointDataAdapter.removeTestFile((File)arrayList.get(n - 1));
        ToolstripPopupUtils.packPopup(popupList);
    }

    public static void closePopup(PopupList popupList) {
        OverlayManager overlayManager;
        if (popupList != null && (overlayManager = OverlayManagers.get((Component)popupList)) != null) {
            overlayManager.removePopups();
        }
    }
}

