/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.graph.CircuitComponent;
import com.mathworks.toolbox.coder.graph.ComponentKind;
import com.mathworks.toolbox.coder.graph.Widget;
import com.mathworks.toolbox.coder.graph.WidgetFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.SwingUtilities;

public class DefaultWidgetFactory
implements WidgetFactory {
    @Override
    public Widget createWidget(CircuitComponent circuitComponent) {
        return new DefaultWidget(circuitComponent);
    }

    private class DefaultWidget
    extends MJPanel
    implements Widget {
        private final IconWrapper fIconWrapper;
        private final LabelWrapper fLabelWrapper;

        DefaultWidget(CircuitComponent circuitComponent) {
            this.setOpaque(false);
            if (circuitComponent.getType() != ComponentKind.PORT) {
                this.setLayout((LayoutManager)new FormLayout("6px, center:d, 6px", "6px, fill:d, 2px, fill:d, 6px"));
                CellConstraints cellConstraints = new CellConstraints();
                this.fIconWrapper = new IconWrapper(circuitComponent);
                this.fLabelWrapper = new LabelWrapper(circuitComponent);
                this.add((Component)((Object)this.fIconWrapper), cellConstraints.xy(2, 2));
                this.add((Component)((Object)this.fLabelWrapper), cellConstraints.xy(2, 4));
            } else {
                this.fIconWrapper = null;
                this.fLabelWrapper = new LabelWrapper(circuitComponent);
                this.add((Component)((Object)this.fLabelWrapper));
            }
        }

        public Dimension getPreferredSize() {
            int n = 12 + (int)Math.max(this.fIconWrapper == null ? 0.0 : this.fIconWrapper.getPreferredSize().getWidth(), this.fLabelWrapper.getPreferredSize().getWidth());
            int n2 = (int)super.getPreferredSize().getHeight();
            return new Dimension(n, n2);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public Rectangle getIconBounds(Component component) {
            return this.fIconWrapper == null ? this.fLabelWrapper.getLabelBounds(component) : this.fIconWrapper.getIconBounds(component);
        }
    }

    private class LabelWrapper
    extends MJPanel {
        private final CircuitComponent fComponent;
        private final MJLabel fLabel;

        LabelWrapper(CircuitComponent circuitComponent) {
            this.fComponent = circuitComponent;
            this.setOpaque(false);
            this.setLayout((LayoutManager)new FormLayout("6px:grow, fill:d, 9px:grow", "3px:grow, fill:d, 5px:grow"));
            CellConstraints cellConstraints = new CellConstraints();
            this.fLabel = new MJLabel(circuitComponent.getName());
            this.fLabel.setFont(new Font("Lucida Grande", 0, 11));
            if (circuitComponent.getType() == ComponentKind.PORT) {
                this.fLabel.setForeground(Color.WHITE);
            }
            this.add((Component)this.fLabel, cellConstraints.xy(2, 2));
        }

        public Rectangle getLabelBounds(Component component) {
            Rectangle rectangle = this.fLabel.getBounds();
            rectangle = SwingUtilities.convertRectangle((Component)((Object)this), rectangle, component);
            return rectangle;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.4f));
            graphics2D.draw(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 4, this.getHeight() - 4, 15.0, 15.0));
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.2f));
            graphics2D.draw(new RoundRectangle2D.Double(2.0, 2.0, this.getWidth() - 4, this.getHeight() - 4, 15.0, 15.0));
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.1f));
            graphics2D.draw(new RoundRectangle2D.Double(3.0, 3.0, this.getWidth() - 4, this.getHeight() - 4, 15.0, 15.0));
            graphics2D.setColor(this.fComponent.getType() == ComponentKind.PORT ? new Color(0.15f, 0.15f, 0.15f, 1.0f) : Color.WHITE);
            graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 4, this.getHeight() - 4, 15.0, 15.0));
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.85f));
            graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 4, this.getHeight() - 4, 15.0, 15.0));
            graphics2D.dispose();
        }
    }

    private class IconWrapper
    extends MJPanel {
        private final CircuitComponent fComponent;
        private final IconPanel fIconPanel;

        IconWrapper(CircuitComponent circuitComponent) {
            this.fComponent = circuitComponent;
            this.setOpaque(false);
            this.setLayout((LayoutManager)new FormLayout("6px:grow, fill:d, 9px:grow", "6px:grow, fill:d, 9px:grow"));
            CellConstraints cellConstraints = new CellConstraints();
            this.fIconPanel = new IconPanel(circuitComponent.getType());
            this.add((Component)((Object)this.fIconPanel), cellConstraints.xy(2, 2));
        }

        public Rectangle getIconBounds(Component component) {
            Rectangle rectangle = this.getBounds();
            rectangle.width -= 4;
            rectangle.height -= 4;
            rectangle = SwingUtilities.convertRectangle(this.getParent(), rectangle, component);
            return rectangle;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.4f));
            graphics2D.drawRect(1, 1, this.getWidth() - 4, this.getHeight() - 4);
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.2f));
            graphics2D.drawRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.1f));
            graphics2D.drawRect(3, 3, this.getWidth() - 4, this.getHeight() - 4);
            graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            graphics2D.fillRect(0, 0, this.getWidth() - 4, this.getHeight() - 4);
            graphics2D.setColor(new Color(0.33f, 0.33f, 0.33f, 0.85f));
            graphics2D.drawRect(0, 0, this.getWidth() - 4, this.getHeight() - 4);
            graphics2D.dispose();
        }
    }

    private class IconPanel
    extends MJPanel {
        private final ComponentKind fKind;

        IconPanel(ComponentKind componentKind) {
            this.fKind = componentKind;
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            this.fKind.paintIcon((Graphics2D)graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.fKind.getIconWidth(), this.fKind.getIconHeight());
        }
    }
}

