/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.Interval;

public final class Expression
extends FunctionScopedKey<Interval>
implements CodableEntity {
    private final int fFocalPosition;

    public Expression(Function function, int n, int n2) {
        this(function, n, n2, -1);
    }

    public Expression(Function function, int n, int n2, int n3) {
        super(function, new Interval(n, n + n2));
        this.fFocalPosition = Math.max(-1, n3);
    }

    public int getStart() {
        return ((Interval)this.getKey()).getStart();
    }

    public int getEnd() {
        return ((Interval)this.getKey()).getEnd();
    }

    public int getLength() {
        return ((Interval)this.getKey()).getLength();
    }

    public int getFocalPosition() {
        return this.fFocalPosition;
    }

    @Override
    public CodableEntity.Type getEntityType() {
        return CodableEntity.Type.EXPRESSION;
    }

    public String toString() {
        return String.format("Expression [start=%d][end=%d]", this.getStart(), this.getEnd());
    }

    private static class PositionRange
    implements Comparable<PositionRange> {
        private final int fStart;
        private final int fEnd;
        private final Expression fExpression;

        public PositionRange(Expression expression, int n, int n2) {
            this.fStart = n;
            this.fEnd = n2;
            this.fExpression = expression;
        }

        public PositionRange(Expression expression, int n) {
            this(expression, expression.getStart(), expression.getStart() + n);
        }

        public int getLength() {
            return this.getEnd() - this.getStart();
        }

        public int getEnd() {
            return this.fEnd;
        }

        public int getStart() {
            return this.fStart;
        }

        public Expression getExpression() {
            return this.fExpression;
        }

        public boolean contains(int n) {
            return this.fStart <= n && n < this.fEnd;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PositionRange)) {
                return false;
            }
            PositionRange positionRange = (PositionRange)object;
            if (this.fEnd != positionRange.fEnd) {
                return false;
            }
            if (this.fStart != positionRange.fStart) {
                return false;
            }
            return this.fExpression.equals(positionRange.fExpression);
        }

        public int hashCode() {
            int n = this.fStart;
            n = 31 * n + this.fEnd;
            n = 31 * n + this.fExpression.hashCode();
            return n;
        }

        public boolean contains(PositionRange positionRange) {
            return this.fStart <= positionRange.fStart && this.fEnd > positionRange.fEnd || this.fStart < positionRange.fStart && this.fEnd >= positionRange.fEnd;
        }

        @Override
        public int compareTo(PositionRange positionRange) {
            int n = this.fExpression.getFunction().getName().compareTo(positionRange.getExpression().getFunction().getName());
            if (n != 0) {
                return n;
            }
            if (this.contains(positionRange)) {
                return 1;
            }
            if (positionRange.contains(this)) {
                return -1;
            }
            if (this.equals(positionRange)) {
                return 0;
            }
            if (this.fStart < positionRange.fStart) {
                return -1;
            }
            return 1;
        }
    }
}

