/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static String getFunctionName(File file) {
        try {
            MTree mTree = MTree.parse((String)CoderFileSupport.readMatlabSource(file), (boolean)true);
            List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
            return ((MTree.Node)list.iterator().next()).getFunctionName().getText();
        }
        catch (Exception exception) {
            return new FileLocation(file).getNameBeforeDot();
        }
    }

    public static Function createSpecialization(Function function, int n) {
        String string = "f" + n + "_" + function.getName();
        return new Function(function.getFile(), function.getName(), string, string, n);
    }

    public static MTree.Node getParentOfType(MTree.Node node, MTree.NodeType ... nodeTypeArray) {
        MTree.Node node2;
        for (node2 = node; node2 != MTree.NULL_NODE && !MTreeUtils.isType((MTree.Node)node2, (MTree.NodeType[])nodeTypeArray); node2 = node2.getTrueParent()) {
        }
        return node2 != null && Arrays.asList(nodeTypeArray).contains(node2.getType()) ? node2 : null;
    }

    @Nullable
    public static EntryPoint getEntryPoint(File file) {
        EntryPoint entryPoint = null;
        try {
            MTree mTree = MTree.parse((String)CoderFileSupport.readMatlabSource(file));
            List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
            String string = file.getName();
            String string2 = list.isEmpty() ? "unknown" : ((MTree.Node)list.get(0)).getFunctionName().getText();
            entryPoint = new EntryPoint(string, string2);
            ArrayList<String> arrayList = new ArrayList<String>(0);
            Utilities.getEntryPointInputNames(mTree, arrayList);
            for (String string3 : arrayList) {
                entryPoint.addInput(new InputDataProperty(entryPoint, string3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return entryPoint;
    }
}

