/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.mi.InferenceMI;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.FieldNature;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;

public final class InferenceModel
extends UnifiedModel {
    private final List<Function> fFunctions = new ArrayList<Function>();
    private final MulticastChangeListener fChangeListeners = new MulticastChangeListener();
    private final CoderAppModel fAppModel;

    public InferenceModel(CoderAppModel coderAppModel) {
        this.fAppModel = coderAppModel;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    @Override
    public List<Function> getFunctions() {
        return new ArrayList<Function>(this.fFunctions);
    }

    /*
     * WARNING - void declaration
     */
    public void setData(InferenceMI.Inference inference) {
        Function function;
        InferenceMI.InferFcnInfo inferFcnInfo;
        int n;
        MetadataTree<MatlabType> metadataTree = new MetadataTree<MatlabType>();
        MetadataTree<VariableKind> metadataTree2 = new MetadataTree<VariableKind>();
        MetadataTree<FieldNature> metadataTree3 = new MetadataTree<FieldNature>();
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        LinkedList<BuildError> linkedList2 = new LinkedList<BuildError>();
        this.fFunctions.clear();
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        Function[] functionArray = new Function[inference.functions.length];
        MTree[] mTreeArray = new MTree[inference.scripts.length];
        BaseDocument baseDocument = new BaseDocument(MLanguage.INSTANCE.createDefaultKit().getClass(), false);
        CallTree callTree = new CallTree();
        for (n = 0; n < inference.functions.length; ++n) {
            inferFcnInfo = inference.functions[n];
            if (inferFcnInfo.scriptID - 1 < 0) continue;
            InferenceMI.InferScript object = inference.scripts[inferFcnInfo.scriptID - 1];
            functionArray[n] = InferenceModel.createFunction(object, inferFcnInfo, hashMap);
        }
        for (n = 0; n < inference.functions.length; ++n) {
            Object object;
            Object object2;
            String string;
            void var14_18;
            int n2;
            inferFcnInfo = inference.functions[n];
            Function function2 = functionArray[n];
            if (inferFcnInfo.scriptID - 1 < 0) continue;
            int n3 = inferFcnInfo.scriptID - 1;
            InferenceMI.InferScript inferScript = inference.scripts[n3];
            int n4 = n2 = hashMap.containsKey(function2) ? (Integer)hashMap.get(function2) : 0;
            if (n2 != 0) {
                hashMap.put(function2, n2 + 1);
                Function function3 = functionArray[n] = FunctionUtils.createSpecialization(function2, n2);
            }
            this.fFunctions.add((Function)var14_18);
            function = mTreeArray[n3];
            if (function == null) {
                if (inferScript == null || !inferScript.isUserVisible || inferScript.scriptText.isEmpty()) continue;
                function = MTree.parse((String)inferScript.scriptText, (boolean)true);
                mTreeArray[n3] = function;
                try {
                    baseDocument.remove(0, baseDocument.getLength());
                    baseDocument.insertString(0, inferScript.scriptText, null);
                }
                catch (BadLocationException badLocationException) {
                    baseDocument = null;
                }
            }
            for (int i = 0; i < inferFcnInfo.mxInfoLocations.length; ++i) {
                InferenceMI.MxInfoLocation mxInfoLocation = inferFcnInfo.mxInfoLocations[i];
                String string2 = mxInfoLocation.nodeTypeName.toLowerCase(Locale.ENGLISH);
                InferenceMI.MxInfo mxInfo = inference.mxInfos[mxInfoLocation.mxInfoID - 1];
            }
            for (InferenceMI.MxInfoLocation mxInfoLocation : inferFcnInfo.mxInfoLocations) {
                Object object3;
                Object object4;
                string = mxInfoLocation.nodeTypeName.toLowerCase(Locale.ENGLISH);
                object2 = inference.mxInfos[mxInfoLocation.mxInfoID - 1];
                object = MTreeUtils.getNodeAtPosition((MTree)function, (int)mxInfoLocation.textStart, (BaseDocument)baseDocument, (boolean)false);
                if (object == null) continue;
                MatlabType matlabType = InferenceModel.createMatlabType(object2);
                if (string.equals("const") || string.equals("call") || !string.matches("^[a-zA-Z]+$") || object.getType() == MTree.NodeType.NOT) {
                    object4 = new Expression((Function)var14_18, mxInfoLocation.textStart, mxInfoLocation.textLength);
                    metadataTree.put((FunctionScopedKey<?>)object4, matlabType);
                    linkedList.add((Expression)object4);
                    continue;
                }
                if (object.getType() != MTree.NodeType.ID || object.getAttribute() != MTree.Attribute.VARIABLE) continue;
                object4 = object.getText();
                Variable variable = new Variable((Function)var14_18, (String)object4);
                if (metadataTree.get(variable) == null) {
                    object3 = InferenceModel.getVariableKind(mxInfoLocation.nodeTypeName);
                    metadataTree.put(variable, matlabType);
                    metadataTree2.put(variable, (VariableKind)((Object)object3));
                }
                if (!matlabType.isStruct() && !matlabType.isObject()) continue;
                object3 = new LinkedList();
                InferenceMI.FieldDefinition[] fieldDefinitionArray = matlabType.isStruct() ? object2.structFields : object2.classProperties;
                VariableKind variableKind = matlabType.isStruct() ? VariableKind.FIELD : VariableKind.PROPERTY;
                for (InferenceMI.FieldDefinition fieldDefinition : fieldDefinitionArray) {
                    Variable variable2 = new Variable((Function)var14_18, UnifiedModel.createStructAccessString(variable, fieldDefinition.fieldName));
                    InferenceMI.MxInfo mxInfo = inference.mxInfos[fieldDefinition.mxInfoID - 1];
                    metadataTree.put(variable2, InferenceModel.createMatlabType(mxInfo));
                    metadataTree2.put(variable2, variableKind);
                    object3.add(variable2);
                }
                metadataTree3.put(variable, new FieldNature((Collection<Variable>)object3));
            }
            for (InferenceMI.ErrorMessage errorMessage : inferFcnInfo.messages) {
                string = MTreeUtils.getNodeAtPosition((MTree)function, (int)errorMessage.textStart, (BaseDocument)baseDocument, (boolean)false);
                object2 = BuildErrorSeverity.valueOf(errorMessage.msgTypeName.toUpperCase());
                object = new BuildError((Function)var14_18, errorMessage.textStart, string.getStartLine(), errorMessage.textLength, (BuildErrorSeverity)((Object)object2), errorMessage.msgText);
                linkedList2.add((BuildError)object);
            }
        }
        for (n = 0; n < inference.functions.length; ++n) {
            inferFcnInfo = inference.functions[n];
            for (InferenceMI.InferCallSite inferCallSite : inferFcnInfo.callSites) {
                function = functionArray[inferCallSite.calledFunctionID - 1];
                if (function == null) continue;
                callTree.add(new CallTree.CallSite(inferCallSite.textStart, functionArray[n], function));
            }
        }
        this.startBatchingPropertyChangeEvents();
        this.setMatlabTypes(metadataTree);
        this.setKeyTree(metadataTree2);
        this.setVariableNames(metadataTree2);
        this.setVariableKinds(metadataTree2);
        this.setFieldNatures(metadataTree3);
        this.setExpressions(linkedList);
        this.setCallTree(callTree);
        this.fAppModel.setErrors(linkedList2);
        this.fAppModel.setCallTree(callTree);
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        this.fireBatchedPropertyChangeEvents();
    }

    private static MatlabType createMatlabType(InferenceMI.MxInfo mxInfo) {
        MatlabType.TypeFlag typeFlag = null;
        if (mxInfo.className.equals("struct")) {
            typeFlag = MatlabType.TypeFlag.STRUCT;
        } else if (mxInfo.classProperties != null) {
            typeFlag = MatlabType.TypeFlag.OBJECT;
        }
        return new MatlabType(mxInfo.className, mxInfo.size, mxInfo.sizeDynamic, mxInfo.complex, typeFlag);
    }

    public File findFile(String string) {
        for (Function function : this.fFunctions) {
            if (!new FileLocation(function.getFile()).getNameBeforeDot().equals(string) || !CoderFileSupport.isMatlabSourceFile(function.getFile())) continue;
            return function.getFile();
        }
        return null;
    }

    public Function getMainFunction(File file) {
        FileLocation fileLocation = new FileLocation(file);
        if (!CoderFileSupport.isMatlabSourceFile(file)) {
            file = this.findFile(fileLocation.getNameBeforeDot());
            if (file == null) {
                return null;
            }
            fileLocation = new FileLocation(file);
        }
        String string = fileLocation.getNameBeforeDot();
        Function function = null;
        for (Function function2 : this.fFunctions) {
            if (!function2.getFile().equals(fileLocation.toFile())) continue;
            function = function2;
            if (!function2.getName().equals(string)) continue;
            return function2;
        }
        return function;
    }

    private static VariableKind getVariableKind(String string) {
        VariableKind variableKind = VariableKind.mapFromInferenceNodeType(string);
        if (variableKind == null) {
            variableKind = VariableKind.LOCAL;
        }
        return variableKind;
    }

    private static Function createFunction(InferenceMI.InferScript inferScript, InferenceMI.InferFcnInfo inferFcnInfo, Map<Function, Integer> map) {
        Function function;
        boolean bl = FunctionUtils.getFunctionName(inferScript.scriptPath).equals(inferFcnInfo.functionName);
        map.put(function, map.containsKey(function = new Function(inferScript.scriptPath, inferFcnInfo.functionName, inferFcnInfo.functionName)) ? 1 : 0);
        return function;
    }
}

