/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.model.Range;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class NumericType {
    private static final Pattern INTERNAL_PATTERN = Pattern.compile("numerictype[ \\(]{1}(0|1|\\[\\])[ ,]+?[\\d]+[ ,]+?[\\d]+?[ ,]*('DataType'[ ,]+'ScaledDouble'){0,1}[\\)]{0,1}");
    private static final Pattern INTERNAL_TOKEN_PATTERN = Pattern.compile("[\\d\\[\\]]+");
    private final Signedness fSignedness;
    private final boolean fSigned;
    private final int fWordLength;
    private final int fFractionLength;
    private final boolean fScaledDouble;
    private final boolean fAutoScaling;

    public NumericType(boolean bl, int n, int n2, boolean bl2) {
        this(bl, n, n2, bl2, false);
    }

    public NumericType(boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.fSigned = bl;
        this.fSignedness = bl ? Signedness.SIGNED : Signedness.UNSIGNED;
        this.fWordLength = n;
        this.fFractionLength = n2;
        this.fScaledDouble = bl3;
        this.fAutoScaling = bl2;
    }

    public NumericType(String string) {
        Object object;
        Signedness signedness = Signedness.SIGNED;
        int n = 0;
        Integer n2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (NumericType.isCanonicalNumericType(string)) {
            object = INTERNAL_TOKEN_PATTERN.matcher(string);
            try {
                ((Matcher)object).find();
                signedness = NumericType.signednessFromUserRepresentation(((Matcher)object).group(), signedness);
                ((Matcher)object).find();
                n = Integer.parseInt(((Matcher)object).group());
                if (((Matcher)object).find()) {
                    n2 = Integer.valueOf(((Matcher)object).group());
                }
                if (string.contains("ScaledDouble")) {
                    bl2 = true;
                }
                bl = true;
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
        }
        if (!bl) {
            try {
                object = new StringTokenizer(string, "fix_E");
                signedness = ((StringTokenizer)object).nextToken().equals("s") ? Signedness.SIGNED : Signedness.UNSIGNED;
                int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                int n4 = 0;
                if (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    n4 = string2.startsWith("n") ? Integer.valueOf(string2.substring(1)) : -Integer.parseInt(string2);
                }
                n = n3;
                n2 = n4;
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException);
            }
        }
        this.fScaledDouble = bl2;
        this.fSignedness = signedness;
        this.fSigned = this.fSignedness == Signedness.SIGNED;
        this.fWordLength = n;
        this.fAutoScaling = n2 == null;
        this.fFractionLength = n2 != null ? n2 : 0;
    }

    public Signedness getSignedness() {
        return this.fSignedness;
    }

    public boolean isSigned() {
        return this.fSignedness == Signedness.SIGNED;
    }

    public int getWordLength() {
        return this.fWordLength;
    }

    public int getFractionLength() {
        return this.fFractionLength;
    }

    public int getMinBit() {
        return -this.fFractionLength;
    }

    public int getMaxBit() {
        return this.fWordLength - (this.fSigned ? 1 : 0) - this.fFractionLength;
    }

    public boolean isScaledDouble() {
        return this.fScaledDouble;
    }

    public boolean isAutoScaling() {
        return this.fAutoScaling;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        if (bl) {
            return (this.fSigned ? "S, " : "U, ") + this.fWordLength + ", " + this.fFractionLength;
        }
        return NumericType.toNumericTypeString(this.fSignedness, this.fWordLength, this.fFractionLength, this.fAutoScaling, this.fScaledDouble);
    }

    public Range getSupportedRange() {
        double d = 0.0;
        for (int i = this.getMinBit(); i < this.getMaxBit(); ++i) {
            d += Math.pow(2.0, i);
        }
        if (this.fSigned) {
            return new Range(-Math.floor(d) - 1.0, d);
        }
        return new Range(0.0, d);
    }

    private static String toNumericTypeString(Signedness signedness, int n, int n2, boolean bl, boolean bl2) {
        return "numerictype(" + signedness.getUserRepresentation() + ", " + n + (!bl ? ", " + n2 : "") + (bl2 ? ", 'DataType', 'ScaledDouble'" : "") + ")";
    }

    public static NumericType parse(String string) {
        try {
            return new NumericType(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toNumericTypeString(String string, int n, @Nullable Integer n2) {
        Signedness signedness = Signedness.valueOf(string.toUpperCase(Locale.ENGLISH));
        if (signedness == null) {
            return null;
        }
        boolean bl = n2 == null;
        return NumericType.toNumericTypeString(signedness, n, bl ? 0 : n2, bl, false);
    }

    public static Signedness signednessFromUserRepresentation(String string, Signedness signedness) {
        for (Signedness signedness2 : Signedness.values()) {
            if (!signedness2.getUserRepresentation().equals(string)) continue;
            return signedness2;
        }
        return signedness;
    }

    public static boolean isCanonicalNumericType(String string) {
        return INTERNAL_PATTERN.matcher(string).matches();
    }

    public static enum Signedness {
        SIGNED("1"),
        UNSIGNED("0"),
        AUTO("[]");

        private final String fText;

        private Signedness(String string2) {
            this.fText = string2;
        }

        public String getUserRepresentation() {
            return this.fText;
        }
    }
}

