/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.WritableFileSet;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestBenchUtils;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPUtils;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.TypePropertyTableUtils;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.BusyAffordance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoInferDialog
extends MJDialog {
    private final WritableConfiguration fConfig;
    private final BusyAffordance fRunningAffordance;
    private boolean fRunning;
    private boolean fCanceled;

    public AutoInferDialog(Frame frame, WritableConfiguration writableConfiguration) {
        super(frame, CoderResources.getString("title.autoPopulateTypes"), false);
        this.fConfig = writableConfiguration;
        this.fRunningAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        PreRunPanel preRunPanel = new PreRunPanel();
        this.add((Component)((Object)preRunPanel));
        this.pack();
        this.setSize(this.getWidth(), this.getHeight() + 34);
        this.setMinimumSize(this.getSize());
        this.getRootPane().setDefaultButton(preRunPanel.getDefaultButton());
        this.setLocationRelativeTo(frame);
        this.setName("entrypoint.infer.dialog");
    }

    private void showResult(TestBenchResult testBenchResult) {
        this.getContentPane().removeAll();
        MJPanel mJPanel = new MJPanel();
        this.getContentPane().add((Component)mJPanel);
        PostRunPanel postRunPanel = new PostRunPanel(testBenchResult);
        int n = Math.max((int)postRunPanel.getPreferredSize().getWidth(), PlatformInfo.isMacintosh() ? 450 : 400);
        int n2 = Math.max((int)postRunPanel.getPreferredSize().getHeight() + this.getInsets().top + this.getInsets().bottom + 8, 250);
        MJLabel mJLabel = new MJLabel();
        mJLabel.setText(CoderResources.getString("label.autoPopulateTypes.highlighted"));
        n = Math.max(n, (int)mJLabel.getPreferredSize().getWidth() + 20);
        mJLabel.setText(CoderResources.getString("label.autoPopulateTypes.noHighlight"));
        n = Math.max(n, (int)mJLabel.getPreferredSize().getWidth() + 20);
        this.doSizeTransition((JComponent)mJPanel, postRunPanel, n, n2);
    }

    private MJButton createCancelButton(String string) {
        MJButton mJButton = new MJButton(string);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoInferDialog.this.fRunning) {
                    AutoInferDialog.this.fCanceled = true;
                    TestBenchUtils.interruptTestBench();
                }
                AutoInferDialog.this.setVisible(false);
                AutoInferDialog.this.dispose();
            }
        });
        return mJButton;
    }

    private void doSizeTransition(JComponent jComponent, final ComponentWithDefaultButton componentWithDefaultButton, final int n, final int n2) {
        final Point point = this.getLocation();
        final Dimension dimension = this.getSize();
        final Holder holder = new Holder();
        holder.set((Object)new Timer(1, new ActionListener(){
            double increment = 2.0;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n5;
                int n22;
                if (AutoInferDialog.this.getWidth() >= n && AutoInferDialog.this.getHeight() >= n2) {
                    ((Timer)holder.get()).stop();
                    AutoInferDialog.this.getContentPane().removeAll();
                    AutoInferDialog.this.add((Component)((Object)componentWithDefaultButton));
                    AutoInferDialog.this.getRootPane().setDefaultButton(componentWithDefaultButton.getDefaultButton());
                    AutoInferDialog.this.setResizable(true);
                    n22 = (int)(point.getX() - ((double)AutoInferDialog.this.getWidth() - dimension.getWidth()) / 2.0);
                    n5 = (int)(point.getY() - ((double)AutoInferDialog.this.getHeight() - dimension.getHeight()) / 2.0);
                    AutoInferDialog.this.pack();
                    AutoInferDialog.this.setLocation(n22, n5);
                    AutoInferDialog.this.setMinimumSize(AutoInferDialog.this.getSize());
                    AutoInferDialog.this.validate();
                    AutoInferDialog.this.repaint();
                }
                n22 = (int)Math.min((double)n, (double)AutoInferDialog.this.getWidth() + this.increment);
                n5 = (int)Math.min((double)n2, (double)AutoInferDialog.this.getHeight() + this.increment);
                this.increment *= 1.2;
                int n3 = (int)(point.getX() - ((double)n22 - dimension.getWidth()) / 2.0);
                int n4 = (int)(point.getY() - ((double)n5 - dimension.getHeight()) / 2.0);
                AutoInferDialog.this.setSize(n22, n5);
                AutoInferDialog.this.setLocation(n3, n4);
                AutoInferDialog.this.validate();
                AutoInferDialog.this.repaint();
            }
        }));
        ((Timer)holder.get()).start();
    }

    private MJHelpButton createHelpButton() {
        MJHelpButton mJHelpButton = new MJHelpButton();
        mJHelpButton.setName("entrypoint.infer.dialog.helpButton");
        mJHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = ((Configuration)AutoInferDialog.this.fConfig).getTarget();
                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                MLHelpServices.cshDisplayTopic((Object)((Object)AutoInferDialog.this), (String)string, (String)"help_button_autodefine_types");
            }
        });
        return mJHelpButton;
    }

    private class PostRunPanel
    extends ComponentWithDefaultButton {
        private final PropertyTable<InputDataProperty> fTable;
        private final MJCheckBox fVariableSizeThresholdCheck;
        private final MJCheckBox fUnboundedSizeThresholdCheck;
        private final MJTextField fVariableSizeThresholdField;
        private final MJTextField fUnboundedSizeThresholdField;
        private final MJLabel fHighlightLabel;
        private PropertyTableHighlighter<InputDataProperty> fHighlighter;

        PostRunPanel(final TestBenchResult testBenchResult) {
            this.setLayout(new GridBagLayout());
            this.fVariableSizeThresholdCheck = new MJCheckBox(CoderResources.getString("option.autoPopulateTypes.varsize"));
            this.fUnboundedSizeThresholdCheck = new MJCheckBox(CoderResources.getString("option.autoPopulateTypes.unbounded"));
            this.updateHighlighterOnChange((JCheckBox)this.fVariableSizeThresholdCheck);
            this.updateHighlighterOnChange((JCheckBox)this.fUnboundedSizeThresholdCheck);
            this.fVariableSizeThresholdField = new MJTextField();
            this.fUnboundedSizeThresholdField = new MJTextField();
            this.fVariableSizeThresholdField.setText("1024");
            this.fUnboundedSizeThresholdField.setText("2048");
            this.fVariableSizeThresholdField.setColumns(6);
            this.fUnboundedSizeThresholdField.setColumns(6);
            this.fVariableSizeThresholdField.setEnabled(false);
            this.fUnboundedSizeThresholdField.setEnabled(false);
            Utilities.makeDependent((JComponent)this.fVariableSizeThresholdField, (JCheckBox)this.fVariableSizeThresholdCheck);
            Utilities.makeDependent((JComponent)this.fUnboundedSizeThresholdField, (JCheckBox)this.fUnboundedSizeThresholdCheck);
            this.fHighlightLabel = new MJLabel(" ");
            if (PlatformInfo.isMacintosh()) {
                this.fHighlightLabel.setFont(this.fHighlightLabel.getFont().deriveFont((float)(this.fHighlightLabel.getFont().getSize() - 2)));
            }
            MJHelpButton mJHelpButton = AutoInferDialog.this.createHelpButton();
            MJButton mJButton = new MJButton(CoderResources.getString("button.autoPopulateTypes.apply"));
            MJButton mJButton2 = AutoInferDialog.this.createCancelButton(BuiltInResources.getString((String)"button.cancel"));
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PostRunPanel.this.applyTestBenchResult(testBenchResult);
                    PostRunPanel.this.setVisible(false);
                    AutoInferDialog.this.dispose();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            Utilities.addMacCenteringPadding(this, gridBagConstraints);
            Utilities.addDialogBanner(this, gridBagConstraints, CoderResources.getString("desc.autoPopulateTypes.review"));
            ++gridBagConstraints.gridy;
            this.fTable = TypePropertyTableUtils.createInputDataPropertyTable((FileSetInstance)AutoInferDialog.this.fConfig.getFileSet("fileset.entrypoints"), testBenchResult);
            this.fTable.getSelectionModel().setAllowSelect(false);
            gridBagConstraints.gridx = PlatformInfo.isMacintosh() ? 1 : 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = Utilities.getDialogDefaultAnchor();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            this.add(this.fTable.getComponent(), gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            if (this.fTable.getModel().getRowCount() > 0) {
                gridBagConstraints.insets = Utilities.getDialogDefaultInsets();
                if (!PlatformInfo.isMacintosh()) {
                    gridBagConstraints.insets.top = 0;
                }
                gridBagConstraints.insets.top -= 3;
                this.add((Component)this.fHighlightLabel, gridBagConstraints);
                ++gridBagConstraints.gridy;
                if (PlatformInfo.isMacintosh()) {
                    gridBagConstraints.insets = Utilities.getDialogTopInsets();
                }
                MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.weightx = 0.7;
                mJPanel.add((Component)this.fVariableSizeThresholdCheck, (Object)gridBagConstraints2);
                ++gridBagConstraints2.gridx;
                gridBagConstraints2.weightx = 0.3;
                mJPanel.add((Component)this.fVariableSizeThresholdField, (Object)gridBagConstraints2);
                ++gridBagConstraints2.gridy;
                --gridBagConstraints2.gridx;
                gridBagConstraints2.weightx = 0.7;
                mJPanel.add((Component)this.fUnboundedSizeThresholdCheck, (Object)gridBagConstraints2);
                ++gridBagConstraints2.gridx;
                gridBagConstraints2.weightx = 0.3;
                mJPanel.add((Component)this.fUnboundedSizeThresholdField, (Object)gridBagConstraints2);
                gridBagConstraints.anchor = Utilities.getDialogComponentAnchor();
                gridBagConstraints.gridx = PlatformInfo.isMacintosh() ? 1 : 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                this.add((Component)mJPanel, gridBagConstraints);
            }
            Utilities.addBottomPadding(this, gridBagConstraints, false);
            Utilities.addDialogButtons(this, gridBagConstraints, (JButton)mJHelpButton, (JButton)mJButton, (JButton)mJButton2);
            this.setDefaultButton((JButton)mJButton);
            this.updateHighlighterOnChange((JTextField)this.fVariableSizeThresholdField);
            this.updateHighlighterOnChange((JTextField)this.fUnboundedSizeThresholdField);
            this.bindToParam((JTextField)this.fVariableSizeThresholdField, "param.AutoInferVariableSizeThreshold");
            this.bindToParam((JTextField)this.fUnboundedSizeThresholdField, "param.AutoInferUnboundedSizeThreshold");
            this.bindToParam((JCheckBox)this.fVariableSizeThresholdCheck, "param.AutoInferUseVariableSize");
            this.bindToParam((JCheckBox)this.fUnboundedSizeThresholdCheck, "param.AutoInferUseUnboundedSize");
        }

        private void bindToParam(final JTextField jTextField, final String string) {
            int n = AutoInferDialog.this.fConfig.getParamAsInt(string);
            jTextField.setText(Integer.toString(n));
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.saveValue();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.saveValue();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.saveValue();
                }

                private void saveValue() {
                    try {
                        AutoInferDialog.this.fConfig.setParamAsInt(string, Integer.parseInt(jTextField.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }

        private void bindToParam(final JCheckBox jCheckBox, final String string) {
            jCheckBox.setSelected(AutoInferDialog.this.fConfig.getParamAsBoolean(string));
            jCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AutoInferDialog.this.fConfig.setParamAsBoolean(string, jCheckBox.isSelected());
                }
            });
        }

        private void updateHighlighterOnChange(JCheckBox jCheckBox) {
            jCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PostRunPanel.this.updateHighlighter();
                }
            });
        }

        private void updateHighlighterOnChange(JTextField jTextField) {
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    PostRunPanel.this.updateHighlighter();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    PostRunPanel.this.updateHighlighter();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    PostRunPanel.this.updateHighlighter();
                }
            });
        }

        private int getThreshold(JCheckBox jCheckBox, JTextField jTextField) {
            if (jCheckBox.isSelected()) {
                try {
                    return Integer.parseInt(jTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Integer.MAX_VALUE;
        }

        private int getUnboundedSizeThreshold() {
            return this.getThreshold((JCheckBox)this.fUnboundedSizeThresholdCheck, (JTextField)this.fUnboundedSizeThresholdField);
        }

        private int getVariableSizeThreshold() {
            return this.getThreshold((JCheckBox)this.fVariableSizeThresholdCheck, (JTextField)this.fVariableSizeThresholdField);
        }

        private List<InputDataProperty> getVariableSizeProperties() {
            if (this.fVariableSizeThresholdCheck.isSelected()) {
                return this.getPropertiesOverThreshold(this.getVariableSizeThreshold());
            }
            return new ArrayList<InputDataProperty>(0);
        }

        private List<InputDataProperty> getUnboundedSizeProperties() {
            if (this.fUnboundedSizeThresholdCheck.isSelected()) {
                return this.getPropertiesOverThreshold(this.getUnboundedSizeThreshold());
            }
            return new ArrayList<InputDataProperty>(0);
        }

        private List<InputDataProperty> getPropertiesOverThreshold(int n) {
            ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>();
            for (InputDataProperty inputDataProperty : this.fTable.getModel().getAllData()) {
                StringTokenizer stringTokenizer = new StringTokenizer(inputDataProperty.getSizeString(), " :x,");
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n2 < n) continue;
                        arrayList.add(inputDataProperty);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            return arrayList;
        }

        private AttributedString markSizesOverThresholds(InputDataProperty inputDataProperty, Font font) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            String string = IDPUtils.applySizeChangesToSizeSpec(inputDataProperty.getDefinition(), false, this.getVariableSizeThreshold(), this.getUnboundedSizeThreshold(), arrayList);
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            for (int[] nArray : arrayList) {
                attributedString.addAttribute(TextAttribute.FONT, font.deriveFont(1), nArray[0], nArray[1]);
                attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(0, 0, 150), nArray[0], nArray[1]);
            }
            return attributedString;
        }

        private void updateHighlighter() {
            PropertyTableHighlighter<InputDataProperty> propertyTableHighlighter = this.fHighlighter;
            List<InputDataProperty> list = this.getVariableSizeProperties();
            List<InputDataProperty> list2 = this.getUnboundedSizeProperties();
            ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>();
            arrayList.addAll(list);
            arrayList.addAll(list2);
            if (!arrayList.isEmpty()) {
                this.fHighlighter = new PropertyTableHighlighter<InputDataProperty>(new Color(249, 251, 206), Color.BLACK, arrayList){

                    public AttributedString mark(int n, InputDataProperty inputDataProperty, AttributedString attributedString, Font font, double d) {
                        return n == 0 ? attributedString : PostRunPanel.this.markSizesOverThresholds(inputDataProperty, font);
                    }
                };
                this.fTable.swapHighlighter(propertyTableHighlighter, this.fHighlighter);
                this.fHighlightLabel.setText(CoderResources.getString("label.autoPopulateTypes.highlighted"));
            } else {
                if (propertyTableHighlighter != null) {
                    this.fTable.removeHighlighter(propertyTableHighlighter);
                    this.fHighlighter = null;
                }
                if (!(!this.fUnboundedSizeThresholdCheck.isSelected() && !this.fVariableSizeThresholdCheck.isSelected() || this.fUnboundedSizeThresholdField.getText().trim().length() <= 0 && this.fUnboundedSizeThresholdCheck.isSelected() || this.fVariableSizeThresholdField.getText().trim().length() <= 0 && this.fVariableSizeThresholdCheck.isSelected())) {
                    this.fHighlightLabel.setText(CoderResources.getString("label.autoPopulateTypes.noHighlight"));
                } else {
                    this.fHighlightLabel.setText(" ");
                }
            }
        }

        private String applySizeChangesToXml(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "<Size>";
            for (int i = 0; i < string.length(); ++i) {
                stringBuilder.append(string.charAt(i));
                if (stringBuilder.length() <= string2.length() || !stringBuilder.substring(stringBuilder.length() - string2.length()).equals(string2)) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                ++i;
                while (i < string.length() && string.charAt(i) != '<') {
                    stringBuilder2.append(string.charAt(i));
                    ++i;
                }
                --i;
                stringBuilder.append(IDPUtils.applySizeChangesToSizeSpec(stringBuilder2.toString(), false, this.getVariableSizeThreshold(), this.getUnboundedSizeThreshold(), new ArrayList<int[]>(0)));
            }
            return stringBuilder.toString();
        }

        private void applyTestBenchResult(TestBenchResult testBenchResult) {
            FileSetEditor fileSetEditor = ProjectGUI.getInstance().getCurrentClient().getFileSetEditor("fileset.entrypoints");
            Map<String, String> map = testBenchResult.getEntryPointTypes();
            WritableFileSet writableFileSet = AutoInferDialog.this.fConfig.getFileSet("fileset.entrypoints");
            Set set = writableFileSet.getFiles();
            EntryPointFileDataWidget entryPointFileDataWidget = Utilities.getEntryPointFileDataWidget();
            for (File file : set) {
                String string = new FileLocation(file).getNameBeforeDot();
                String string2 = map.get(string);
                if (string2 == null) continue;
                string2 = this.applySizeChangesToXml(string2);
                fileSetEditor.getFileSet().setCustomData(file, string2);
                if (entryPointFileDataWidget == null || !file.getAbsoluteFile().equals(entryPointFileDataWidget.getEntryPointFile().getAbsoluteFile())) continue;
                try {
                    XmlReader xmlReader = XmlApi.getInstance().read(string2);
                    entryPointFileDataWidget.setData(xmlReader);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }
        }
    }

    private class PreRunPanel
    extends ComponentWithDefaultButton {
        private final MJLabel fStatusLabel;
        private final MJPanel fStatusPanel;
        private final MJButton fCancelButton;
        private final MJButton fRunButton;
        private final TestFileSelectorPanel fTestFileSelector;
        private final MJCheckBox fSingleIterationCheckBox;
        private boolean fReloadedDefaultFile;

        PreRunPanel() {
            MJHelpButton mJHelpButton = AutoInferDialog.this.createHelpButton();
            this.fTestFileSelector = new TestFileSelectorPanel(AutoInferDialog.this.fConfig, false, new Runnable(){

                @Override
                public void run() {
                    AutoInferDialog.this.pack();
                }
            });
            this.fTestFileSelector.setQeNamePrefix("testbenchfile");
            this.fTestFileSelector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PreRunPanel.this.fRunButton.setEnabled(PreRunPanel.this.fTestFileSelector.getSelectedFile() != null);
                    if (PreRunPanel.this.fReloadedDefaultFile && PreRunPanel.this.fTestFileSelector.getSelectedFile() != null) {
                        AutoInferDialog.this.fConfig.setParamAsFile("param.AutoInferDefaultFile", PreRunPanel.this.fTestFileSelector.getSelectedFile());
                    }
                }
            });
            this.fRunButton = new MJButton(BuiltInResources.getString((String)"button.run"));
            this.fRunButton.setEnabled(this.fTestFileSelector.getSelectedFile() != null);
            this.fSingleIterationCheckBox = new MJCheckBox(CoderResources.getString("checkbox.autoinfer.single"));
            File file = AutoInferDialog.this.fConfig.getParamAsFile("param.AutoInferDefaultFile");
            if (file != null) {
                this.fTestFileSelector.setSelectedFile(file);
            }
            this.fReloadedDefaultFile = true;
            this.fCancelButton = AutoInferDialog.this.createCancelButton(BuiltInResources.getString((String)"button.close"));
            this.fStatusPanel = new MJPanel((LayoutManager)new FlowLayout());
            this.fStatusLabel = new MJLabel();
            this.fStatusPanel.add((Component)this.fStatusLabel);
            this.fStatusPanel.setVisible(false);
            this.fRunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PreRunPanel.this.fRunButton.setEnabled(false);
                    PreRunPanel.this.fTestFileSelector.setEnabled(false);
                    AutoInferDialog.this.fRunningAffordance.start();
                    PreRunPanel.this.fStatusPanel.setVisible(true);
                    PreRunPanel.this.fStatusPanel.add((Component)AutoInferDialog.this.fRunningAffordance.getComponent());
                    PreRunPanel.this.fStatusLabel.setText(CoderResources.getString("progress.running"));
                    PreRunPanel.this.revalidate();
                    PreRunPanel.this.repaint();
                    PreRunPanel.this.runTestFile(PreRunPanel.this.fTestFileSelector.getSelectedFile());
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            Utilities.addMacCenteringPadding(this, gridBagConstraints);
            Utilities.addDialogBanner(this, gridBagConstraints, CoderResources.getString("desc.autoPopulateTypes"));
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = Utilities.getDialogLabelInsets();
            gridBagConstraints.insets.top = Utilities.getDialogTopInsets().top;
            gridBagConstraints.anchor = Utilities.getDialogLabelAnchor();
            this.add((Component)new MJLabel(CoderResources.getString("label.testbenchfile")), gridBagConstraints);
            ++gridBagConstraints.gridx;
            if (!PlatformInfo.isMacintosh()) {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.anchor = Utilities.getDialogComponentAnchor();
            gridBagConstraints.insets = Utilities.getDialogLabeledComponentInsets();
            gridBagConstraints.insets.top = Utilities.getDialogTopInsets().top;
            this.add(this.fTestFileSelector.getComponent(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            --gridBagConstraints.gridx;
            gridBagConstraints.insets = Utilities.getDialogDefaultInsets();
            gridBagConstraints.anchor = Utilities.getDialogDefaultAnchor();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.fStatusPanel, gridBagConstraints);
            Utilities.addBottomPadding(this, gridBagConstraints, true);
            Utilities.addDialogButtons(this, gridBagConstraints, (JButton)mJHelpButton, (JButton)this.fRunButton, (JButton)this.fCancelButton);
            this.setDefaultButton((JButton)this.fRunButton);
        }

        private void runTestFile(File file) {
            TestBenchConfig testBenchConfig = new TestBenchConfig(TestBenchRunMode.RUN_FORTYPES);
            testBenchConfig.setTestBenchFile(file);
            WritableFileSet writableFileSet = AutoInferDialog.this.fConfig.getFileSet("fileset.entrypoints");
            testBenchConfig.setEntryPointFiles(writableFileSet.getFiles());
            AutoInferDialog.this.fRunning = true;
            TestBenchUtils.runTestBench(testBenchConfig, new ParameterRunnable<TestBenchResult>(){

                public void run(TestBenchResult testBenchResult) {
                    PreRunPanel.this.processResult(testBenchResult);
                }
            });
        }

        private void processResult(TestBenchResult testBenchResult) {
            AutoInferDialog.this.fRunning = false;
            if (AutoInferDialog.this.fCanceled) {
                return;
            }
            AutoInferDialog.this.fRunningAffordance.stop();
            if (testBenchResult.getMessage().isEmpty()) {
                if (this.foundAnyTypes(testBenchResult)) {
                    AutoInferDialog.this.showResult(testBenchResult);
                } else {
                    this.reset();
                    this.fStatusLabel.setText(CoderResources.getString("label.autoPopulateTypes.nothingFound"));
                }
            } else {
                this.reset();
                this.fStatusLabel.setText("");
                TestBenchUtils.showTestBenchError((Component)((Object)AutoInferDialog.this), CoderResources.getString("header.autoPopulateTypes"), testBenchResult);
            }
        }

        private void reset() {
            this.fCancelButton.setEnabled(true);
            this.fRunButton.setEnabled(true);
            this.fTestFileSelector.setEnabled(true);
            this.fStatusPanel.setVisible(true);
            this.fStatusPanel.remove((Component)AutoInferDialog.this.fRunningAffordance.getComponent());
        }

        private boolean foundAnyTypes(TestBenchResult testBenchResult) {
            for (String string : testBenchResult.getEntryPointTypes().values()) {
                if (!string.contains("</Input>")) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class ComponentWithDefaultButton
    extends MJPanel {
        private JButton fDefaultButton;

        private ComponentWithDefaultButton() {
        }

        JButton getDefaultButton() {
            return this.fDefaultButton;
        }

        protected void setDefaultButton(JButton jButton) {
            this.fDefaultButton = jButton;
        }
    }
}

