/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.filesetui.DescriptionLabel;
import com.mathworks.project.impl.filesetui.FileSetLinkUtils;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProfileManager;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plaf.ActionMenuItemUI;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.CoderTestUtils;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.plugin.ParsedFunctionParameterNames;
import com.mathworks.toolbox.coder.plugin.inputtypes.FiMathProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.fixedpoint.SyntaxEnum;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.MenuItemUI;
import org.jetbrains.annotations.Nullable;

public class Utilities {
    public static final String MATLAB_LINK_PREFIX = "matlab:";
    public static final String FILESET_ENTRYPOINTS = "fileset.entrypoints";
    public static final String SETTINGS_RESOURCE_PATH = "/com/mathworks/toolbox/coder/resources/settings";
    private static final String FILESET_TESTBENCH = "fileset.testbench";
    private static final String FILESET_SCRIPTFILE = "fileset.scriptfile";
    public static final String PARAM_ARTIFACT_TAG = "param.artifact";
    public static final String OPTION_ARTIFACT_MEX = "option.target.artifact.mex";
    public static final String OPTION_ARTIFACT_LIB = "option.target.artifact.lib";
    public static final String OPTION_ARTIFACT_DLL = "option.target.artifact.dll";
    public static final String OPTION_ARTIFACT_EXE = "option.target.artifact.exe";
    public static final String OPTION_ARTIFACT_INSTRUMENTED_MEX = "option.target.artifact.mex.instrumented";
    public static final String C_PROFILE_TAG = "profile.c";
    public static final String PARAM_FIXED_POINT_MODE_TAG = "param.FixedPointMode";
    public static final String OPTION_FIXED_POINT_MODE_NONE = "option.FixedPointMode.None";
    public static final String OPTION_FIXED_POINT_MODE_AUTOMATIC = "option.FixedPointMode.Automatic";
    public static final String OPTION_FIXED_POINT_MODE_MANUAL = "option.FixedPointMode.Manual";
    public static final String PARAM_DEFAULT_TEST_FILE_TAG = "param.DefaultTestFile";
    public static final String PARAM_AUTO_INFER_DEFAULT_FILE_TAG = "param.AutoInferDefaultFile";
    public static final String PARAM_CALL_GENERATED_CODE_FROM_TEST_TAG = "param.CallGeneratedCodeFromTest";
    public static final String PARAM_USE_PRECONDITIONS_TAG = "param.UsePreconditions";
    public static final String PARAM_USE_ECODER_TAG = "param.UseECoderFeatures";
    public static final String PARAM_VARIABLE_SIZE_TAG = "param.AutoInferUseVariableSize";
    public static final String PARAM_UNBOUNDED_SIZE_TAG = "param.AutoInferUseUnboundedSize";
    public static final String PARAM_VARIABLE_SIZE_THRESHOLD_TAG = "param.AutoInferVariableSizeThreshold";
    public static final String PARAM_UNBOUNDED_SIZE_THRESHOLD_TAG = "param.AutoInferUnboundedSizeThreshold";
    public static final String PARAM_MEX_GENCODEONLY_TAG = "param.mex.GenCodeOnly";
    public static final String PARAM_XRT_GENCODEONLY_TAG = "param.grt.GenCodeOnly";
    public static final String PARAM_MEX_MAINHTML_TAG = "param.mex.mainhtml";
    public static final String PARAM_MERGE_INSTRUMENTATION_RESULTS_TAG = "param.MergeInstrumentationResults";
    public static final String PARAM_BUILT_INSTRUMENTED_MEX_TAG = "param.BuiltInstrumentedMex";
    public static final String PARAM_RAN_INSTRUMENTED_MEX_TAG = "param.RanInstrumentedMex";
    public static final String PARAM_RAN_PIL_SIL_TAG = "param.RanPilSilVerification";
    public static final String PARAM_GRT_MAINHTML_TAG = "param.grt.mainhtml";
    public static final String PARAM_MEX_OUTPUT_TAG = "param.mex.files.output";
    public static final String PARAM_MEX_OUTPUT_SPECIFIED_TAG = "param.mex.outputfile";
    public static final String PARAM_GRT_OUTPUT_TAG = "param.grt.files.output";
    public static final String PARAM_GRT_OUTPUT_SPECIFIED_TAG = "param.grt.outputfile";
    public static final String PARAM_LAUNCH_INSTRUMENTATION_REPORT_TAG = "param.LaunchInstrumentationReport";
    public static final String PARAM_OPEN_INSTRUMENTATION_REPORT_IN_BROWSER_TAG = "param.OpenInstrumentationReportInBrowser";
    public static final String PARAM_CREATE_PRINTABLE_INSTRUMENTATION_REPORT_TAG = "param.CreatePrintableInstrumentationReport";
    public static final String OPTION_WORKING_PROJECT = "option.WorkingFolder.Project";
    public static final String OPTION_WORKING_CURRENT = "option.WorkingFolder.Current";
    public static final String OPTION_WORKING_SPECIFIED = "option.WorkingFolder.Specified";
    public static final String PARAM_PWD_TAG = "param.WorkingFolder";
    public static final String PARAM_MEX_PWD_SPECIFIED_TAG = "param.SpecifiedWorkingFolder";
    public static final String PARAM_BUILDTOOL_ENABLE_TAG = "param.BuildToolEnable";
    public static final String PARAM_GENERATE_MAIN_TAG = "param.buildtool.GenerateMain";
    public static final String PARAM_BUILDTOOL_CONFIGURE_TAG = "param.ConfigureBuildTool";
    public static final String PARAM_ANNOTATION_CHECKSUM = "param.AnnotationChecksum";
    public static final String PARAM_SAME_HARDWARE_TAG = "param.SameHardware";
    public static final String PARAM_HARDWARE_VENDOR_PRODUCTION_TAG = "param.HardwareVendor.Production";
    public static final String PARAM_HARDWARE_VENDOR_TARGET_TAG = "param.HardwareVendor.Target";
    public static final String PARAM_GLOBALS_TAG = "param.globals";
    public static final String GLOBALS_TAG = "Globals";
    public static final Color BACKGROUND = UIManager.getColor("TextArea.background");
    public static final Color DESCRIPTION_FOREGROUND = ColorUtils.convertToCurrentColorScheme((Color)new Color(150, 150, 150), (Color)UIManager.getColor("Label.foreground"));
    private static EntryPointFileDataWidget fEntryPointFileDataWidget = null;

    private Utilities() {
    }

    public static EntryPointFileDataWidget getEntryPointFileDataWidget() {
        return fEntryPointFileDataWidget;
    }

    public static void setEntryPointFileDataWidget(EntryPointFileDataWidget entryPointFileDataWidget) {
        fEntryPointFileDataWidget = entryPointFileDataWidget;
    }

    public static String quote(Object object) {
        return "'" + object.toString() + "'";
    }

    public static String quote(SyntaxEnum syntaxEnum) {
        return "'" + syntaxEnum.toSyntaxString() + "'";
    }

    public static String sanitizeName(String string) {
        return Utilities.sanitizeName(string, "");
    }

    public static String sanitizeName(String string, String string2) {
        String string3 = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            if (Character.isLetter(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder.length() <= 0 || !Character.isLetterOrDigit(c) && c != '_') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : string2;
    }

    public static String unquote(String string) {
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static <T> T getEnumeration(String string, T[] TArray) {
        String string2 = Utilities.unquote(string);
        for (T t : TArray) {
            if (t instanceof SyntaxEnum && ((SyntaxEnum)t).toSyntaxString().equals(string2)) {
                return t;
            }
            if (!t.toString().equals(string2)) continue;
            return t;
        }
        return null;
    }

    public static void setPropertyValues(XmlReader xmlReader, final Object object) {
        if (xmlReader != null) {
            xmlReader.loop(new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    String string = xmlReader.getCurrentElementName();
                    String string2 = xmlReader.readText();
                    if (string.equals("OverflowMode")) {
                        string = "OverflowAction";
                    } else if (string.equals("RoundMode")) {
                        string = "RoundingMethod";
                    } else if (string.equals("MaxProductWordLength") || string.equals("MaxSumWordLength")) {
                        return;
                    }
                    try {
                        Class[] classArray = new Class[]{String.class};
                        Method method = object.getClass().getDeclaredMethod("set" + string, classArray);
                        method.invoke(object, string2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("IllegalAccessException: " + illegalAccessException.getMessage());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println("InvocationTargetException: " + string + invocationTargetException.getMessage());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.out.println("NoSuchMethodException: " + noSuchMethodException.getMessage());
                    }
                }
            }, new String[0]);
        }
    }

    public static void getEntryPointInputNames(MTree mTree, List<String> list) {
        List list2 = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
        if (list2.isEmpty()) {
            return;
        }
        List list3 = ((MTree.Node)list2.get(0)).getInputArguments();
        for (MTree.Node node : list3) {
            String string = MTree.NodeType.NOT.equals((Object)node.getType()) ? "~" : node.getText();
            list.add(string);
        }
    }

    public static ParsedFunctionParameterNames getEntryPointInputNames(File file) {
        ParsedFunctionParameterNames parsedFunctionParameterNames = new ParsedFunctionParameterNames();
        try {
            MTree mTree = MTree.parse((String)CoderFileSupport.readMatlabSource(file));
            parsedFunctionParameterNames.setValid(mTree.isValid());
            if (parsedFunctionParameterNames.isValid()) {
                Utilities.getEntryPointInputNames(mTree, parsedFunctionParameterNames.getInputNames());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return parsedFunctionParameterNames;
    }

    public static boolean hasEntryPointInputNames(File file) {
        return !Utilities.getEntryPointInputNames(file).getInputNames().isEmpty();
    }

    public static TitledBorder getTitledBorder(String string) {
        return new TitledBorder(CoderResources.getString(string)){
            private static final int T_INSET = 20;
            private static final int L_INSET = 15;
            private static final int B_INSET = 10;
            private static final int R_INSET = 10;
            private Insets fCustomInsets = new Insets(20, 15, 10, 10);

            @Override
            public Insets getBorderInsets(Component component) {
                return this.fCustomInsets;
            }
        };
    }

    public static HyperlinkTextLabel createLink(String string, String string2, Runnable runnable) {
        return FileSetLinkUtils.createLink((String)string, (String)string2, (Runnable)runnable);
    }

    private static Color preferredColor(Color color) {
        return color.equals(DESCRIPTION_FOREGROUND) ? color : ColorUtils.convertToCurrentColorScheme((Color)new Color(150, 150, 150), (Color)color);
    }

    public static MJLabel createDescriptionComponent(String string) {
        return (MJLabel)new DescriptionLabel(string == null ? "" : CoderResources.getString(string)).getComponent();
    }

    public static JSeparator createSeparator() {
        return new JSeparator(0){

            @Override
            public void setForeground(Color color) {
                super.setForeground(Utilities.preferredColor(color));
            }
        };
    }

    public static JMenuItem addToActionMenu(JPopupMenu jPopupMenu, MJAbstractAction mJAbstractAction) {
        JMenuItem jMenuItem = jPopupMenu.add((Action)mJAbstractAction);
        jMenuItem.setUI((MenuItemUI)new ActionMenuItemUI());
        if (jMenuItem.getIcon() == null) {
            jMenuItem.setIcon(mJAbstractAction.getButtonOnlyIcon());
        }
        return jMenuItem;
    }

    public static void help(String string) {
        String string2 = MLHelpServices.getMapfileName((String)"coder", (String)"helptargets");
        MLHelpServices.cshDisplayTopic((String)string2, (String)string);
    }

    public static void addMenuSeparator(JPopupMenu jPopupMenu) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
    }

    public static boolean isPilBuild(ReadableConfiguration readableConfiguration) {
        boolean bl = readableConfiguration.getParamAsBoolean(PARAM_SAME_HARDWARE_TAG);
        String string = bl ? readableConfiguration.getParamAsString("param.HardwareType.Production") : readableConfiguration.getParamAsString("param.HardwareType.Target");
        return string != null && !string.equals("MATLAB Host Computer");
    }

    public static boolean isPilBuildStatusParam(String string) {
        return string.equals(PARAM_SAME_HARDWARE_TAG) || string.contains("param.HardwareType");
    }

    public static boolean isPilSilBuild(Configuration configuration) {
        if (!configuration.getParamAsBoolean(PARAM_USE_ECODER_TAG)) {
            return false;
        }
        String string = configuration.getParamAsString(PARAM_ARTIFACT_TAG);
        return string.equals(OPTION_ARTIFACT_DLL) || string.equals(OPTION_ARTIFACT_LIB);
    }

    public static boolean isTestMode() {
        return CoderTestUtils.isTestMode();
    }

    public static Insets getDialogTopInsets() {
        return PlatformInfo.isMacintosh() ? new Insets(12, 3, 3, 3) : new Insets(12, 9, 9, 9);
    }

    public static Insets getDialogDefaultInsets() {
        return PlatformInfo.isMacintosh() ? new Insets(3, 3, 3, 3) : new Insets(9, 9, 9, 9);
    }

    public static Insets getDialogBannerInsets() {
        Insets insets = Utilities.getDialogTopInsets();
        Insets insets2 = Utilities.getDialogDefaultInsets();
        return new Insets(insets.top, insets2.left, insets.top + (PlatformInfo.isMacintosh() ? 6 : 0), insets2.right);
    }

    public static Insets getDialogLabelInsets() {
        return PlatformInfo.isMacintosh() ? Utilities.getDialogDefaultInsets() : new Insets(9, 9, 9, 4);
    }

    public static Insets getDialogButtonBarInsets() {
        return PlatformInfo.isMacintosh() ? new Insets(6, 18, 14, 14) : new Insets(6, 6, 6, 6);
    }

    public static Insets getDialogLabeledComponentInsets() {
        return PlatformInfo.isMacintosh() ? Utilities.getDialogDefaultInsets() : new Insets(9, 4, 9, 9);
    }

    public static int getDialogComponentAnchor() {
        return 17;
    }

    public static int getDialogLabelAnchor() {
        return PlatformInfo.isMacintosh() ? 13 : 17;
    }

    public static int getDialogDefaultAnchor() {
        return PlatformInfo.isMacintosh() ? 10 : 17;
    }

    public static void addMacCenteringPadding(MJPanel mJPanel, GridBagConstraints gridBagConstraints) {
        if (PlatformInfo.isMacintosh()) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            MJPanel mJPanel2 = new MJPanel();
            MJPanel mJPanel3 = new MJPanel();
            mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 3;
            mJPanel.add((Component)mJPanel3, (Object)gridBagConstraints);
        }
    }

    public static void addBottomPadding(MJPanel mJPanel, GridBagConstraints gridBagConstraints, boolean bl) {
        MJPanel mJPanel2 = new MJPanel();
        gridBagConstraints.insets = bl ? new Insets(0, 0, 0, 0) : Utilities.getDialogDefaultInsets();
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = PlatformInfo.isMacintosh() ? 4 : 2;
        gridBagConstraints.fill = bl ? 1 : 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = bl ? 1.0 : 0.0;
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
    }

    public static void addDialogBanner(MJPanel mJPanel, GridBagConstraints gridBagConstraints, String string) {
        gridBagConstraints.gridx = PlatformInfo.isMacintosh() ? 1 : 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = Utilities.getDialogBannerInsets();
        gridBagConstraints.anchor = Utilities.getDialogDefaultAnchor();
        mJPanel.add((Component)new MJLabel(string), (Object)gridBagConstraints);
    }

    public static void makeDependent(final JComponent jComponent, final JCheckBox jCheckBox) {
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                jComponent.setEnabled(jCheckBox.isSelected());
            }
        });
    }

    public static void addDialogButtons(MJPanel mJPanel, GridBagConstraints gridBagConstraints, JButton jButton, JButton jButton2, JButton jButton3) {
        JPanel jPanel = ButtonBarFactory.buildHelpBar((JButton)jButton, (JButton)jButton2, (JButton)jButton3);
        gridBagConstraints.insets = Utilities.getDialogButtonBarInsets();
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        mJPanel.add((Component)jPanel, (Object)gridBagConstraints);
    }

    public static String getHDLFloatToFixedDisabledText() {
        return (String)PluginManager.getTarget((String)"target.matlab.hdlcoder").getParam("param.fixptconv.enum.needfixedpoint").getOptions().get("option.fixptconv.enum.needfixedpoint.no");
    }

    public static String getTestFileSetKey(ReadableConfiguration readableConfiguration) {
        if (readableConfiguration.getTargetKey().equals("target.matlab.hdlcoder")) {
            return FILESET_SCRIPTFILE;
        }
        return FILESET_TESTBENCH;
    }

    public static FileSetInstance getTestFileSet(ReadableConfiguration readableConfiguration) {
        return (FileSetInstance)readableConfiguration.getFileSet(Utilities.getTestFileSetKey(readableConfiguration));
    }

    public static MJButton createSmallButton(final Icon icon, String string) {
        MJButton mJButton = new MJButton(icon){

            public Dimension getPreferredSize() {
                return new Dimension(icon.getIconWidth() + (PlatformInfo.isMacintosh() ? 6 : 8), icon.getIconHeight() + (PlatformInfo.isMacintosh() ? 4 : 8));
            }
        };
        mJButton.setToolTipText(string);
        if (PlatformInfo.isMacintosh()) {
            mJButton.putClientProperty((Object)"JButton.buttonType", (Object)"gradient");
        }
        return mJButton;
    }

    public static boolean areValuesDifferent(Object object, Object object2) {
        return object == null && object2 != null || object != null && object2 == null || object != null && object2 != null && !object.equals(object2);
    }

    public static <T, V extends Comparable<V>> V maxValue(Collection<T> collection, Converter<T, V> converter) {
        Comparable comparable = null;
        for (T t : collection) {
            Comparable comparable2 = (Comparable)converter.convert(t);
            if (comparable2 == null || comparable != null && comparable2.compareTo(comparable) <= 0) continue;
            comparable = comparable2;
        }
        return (V)comparable;
    }

    public static File getCurrentDirectory() {
        if (Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread()) {
            try {
                Object object = Matlab.mtFeval((String)"pwd", (Object[])new Object[0], (int)1);
                return new File((String)object);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return MatlabPathModel.getInstance().getCurrentFolder().toFile();
    }

    public static void which(String string, final ParameterRunnable<File> parameterRunnable) {
        new Matlab().feval("which", new Object[]{string}, 1, new CompletionObserver(){

            public void completed(int n, Object object) {
                File file = Matlab.getExecutionStatus((int)n) == 0 && object instanceof String && !((String)object).isEmpty() ? new File((String)object) : null;
                parameterRunnable.run(file);
            }
        });
    }

    public static String fimathToString(Collection<FiMathProperty> collection, IDPAttributes iDPAttributes) {
        StringBuilder stringBuilder = new StringBuilder("fimath(");
        for (FiMathProperty fiMathProperty : collection) {
            stringBuilder.append("'");
            stringBuilder.append(StringUtils.upperCaseToCamelCase((String)fiMathProperty.toString(), (boolean)true));
            stringBuilder.append("', ");
            Class<?> clazz = fiMathProperty.getBinder().getType();
            Object object = fiMathProperty.getBinder().getData(iDPAttributes);
            if (clazz.equals(Boolean.class) || clazz.equals(Integer.class)) {
                stringBuilder.append(object);
            } else if (object instanceof SyntaxEnum) {
                stringBuilder.append("'");
                stringBuilder.append(((SyntaxEnum)object).toSyntaxString());
                stringBuilder.append("'");
            }
            stringBuilder.append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void stringToFimath(String string, IDPAttributes iDPAttributes) {
        block6: {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ()\t'\"");
                stringTokenizer.nextToken();
                block2: while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    FiMathProperty fiMathProperty = FiMathProperty.getByName(string2);
                    if (fiMathProperty == null) continue;
                    if (fiMathProperty.getBinder().getType().equals(Boolean.class)) {
                        fiMathProperty.getBinder().setData(iDPAttributes, Boolean.parseBoolean(string3));
                        continue;
                    }
                    if (fiMathProperty.getBinder().getType().equals(Integer.class)) {
                        fiMathProperty.getBinder().setData(iDPAttributes, Integer.parseInt(string3));
                        continue;
                    }
                    if (!fiMathProperty.getBinder().getType().isEnum()) continue;
                    for (Object obj : fiMathProperty.getBinder().getType().getEnumConstants()) {
                        if (!((SyntaxEnum)obj).toSyntaxString().equals(string3)) continue;
                        fiMathProperty.getBinder().setData(iDPAttributes, obj);
                        continue block2;
                    }
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof NullPointerException)) break block6;
                throw exception;
            }
        }
    }

    public static void forEachParam(ParameterRunnable<Param> parameterRunnable, Target target, @Nullable Predicate<ParamSet> predicate, @Nullable Predicate<Param> predicate2) {
        for (ParamSet paramSet : target.getParamSets()) {
            if (predicate != null && !predicate.accept((Object)paramSet)) continue;
            for (Param param : paramSet.getParams()) {
                if (predicate2 != null && !predicate2.accept((Object)param)) continue;
                parameterRunnable.run((Object)param);
            }
        }
    }

    public static void mirrorParamsFromProfile(Configuration configuration, String string) {
        final ProfileManager profileManager = configuration.getProfileManager();
        final Profile profile = configuration.getTarget().getProfile(string);
        final LinkedList linkedList = new LinkedList(configuration.getTarget().getProfiles());
        linkedList.remove(profile);
        Utilities.forEachParam(new ParameterRunnable<Param>(){

            public void run(Param param) {
                if (profileManager.hasAnyProfileSupport(param) && profileManager.hasProfileSupport(profile, param) && profileManager.hasProfileValue(profile, param)) {
                    for (Profile profile2 : linkedList) {
                        if (!profileManager.hasProfileSupport(profile2, param)) continue;
                        profileManager.setProfileValue(profile2, param, profileManager.getProfileValue(profile, param));
                    }
                }
            }
        }, configuration.getTarget(), null, null);
    }
}

