/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.toolbox.coder.model.NumericType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public final class TargetInterfacePort {
    private final String fName;
    private final String fPortType;
    private final NumericType fDataType;
    private final List<String> fInterfaceChoices;
    private String fSelectedInterface;
    private String fBitRange;
    public static final String SELECTED_INTERFACE_PROPERTY = "SelectedInterface";
    public static final String BIT_RANGE_PROPERTY = "BitRange";
    private final PropertyChangeSupport fPropertySupport;

    public TargetInterfacePort(String string, String string2, NumericType numericType, List<String> list, String string3) {
        this.fName = string;
        this.fPortType = string2;
        this.fDataType = numericType;
        this.fInterfaceChoices = new ArrayList<String>(list);
        this.fSelectedInterface = string3;
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.fName;
    }

    public String getPortType() {
        return this.fPortType;
    }

    public String getKey() {
        return TargetInterfacePort.getKey(this.fName, this.fPortType);
    }

    public static String getKey(String string, String string2) {
        return "{" + string + "}-{" + string2 + "}";
    }

    public NumericType getDataType() {
        return this.fDataType;
    }

    public List<String> getInterfaceChoices() {
        return new ArrayList<String>(this.fInterfaceChoices);
    }

    public String getSelectedInterface() {
        return this.fSelectedInterface;
    }

    public void setSelectedInterface(String string) {
        if (!this.fInterfaceChoices.contains(string)) {
            return;
        }
        String string2 = this.fSelectedInterface;
        this.fSelectedInterface = string;
        this.fPropertySupport.firePropertyChange(SELECTED_INTERFACE_PROPERTY, string2, string);
    }

    public String getBitRange() {
        return this.fBitRange;
    }

    public void setBitRange(String string) {
        String string2 = this.getBitRange();
        this.fBitRange = string;
        this.fPropertySupport.firePropertyChange(BIT_RANGE_PROPERTY, string2, this.getBitRange());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }
}

