/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.ScreenerError;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class FileImpactModel {
    private final File fFile;
    private final int fNodeCount;
    private final int fLineCount;
    private Set<MTree.Node> fBadNodes;
    private Set<Integer> fBadLines;
    private Map<ScreenerProblemType, Set<Integer>> fOffenseLines;
    private Map<String, Set<Integer>> fFunctionOffenseLines;
    private Map<ScreenerProblemType, Integer> fProblemImpact;
    private Map<String, Integer> fMathworksFunctionImpact;
    private List<BuildError> fErrors;
    private CoderFileSupport.OffsetConverter fOffsetConverter;

    public FileImpactModel(File file, MTree mTree) {
        this.fFile = file;
        this.fNodeCount = mTree.size();
        this.fLineCount = FileImpactModel.computeLineCount(mTree);
        this.fBadNodes = new HashSet<MTree.Node>();
        this.fBadLines = new HashSet<Integer>();
        this.fProblemImpact = new EnumMap<ScreenerProblemType, Integer>(ScreenerProblemType.class);
        this.fMathworksFunctionImpact = new HashMap<String, Integer>();
        this.fOffenseLines = new EnumMap<ScreenerProblemType, Set<Integer>>(ScreenerProblemType.class);
        this.fFunctionOffenseLines = new HashMap<String, Set<Integer>>();
        this.fErrors = new LinkedList<BuildError>();
    }

    public synchronized List<BuildError> getErrors() {
        return new ArrayList<BuildError>(this.fErrors);
    }

    @SafeVarargs
    public final void add(ScreenerProblemType screenerProblemType, List<MTree.Node> ... listArray) {
        this.add(screenerProblemType, (String)null, listArray);
    }

    @SafeVarargs
    public final synchronized void add(ScreenerProblemType screenerProblemType, @Nullable String string, List<MTree.Node> ... listArray) {
        for (List<MTree.Node> list : listArray) {
            int n = this.addBadNodes(screenerProblemType, null, list);
            FileImpactModel.add(this.fProblemImpact, screenerProblemType, n);
            for (MTree.Node node : list) {
                int n2 = 0;
                int n3 = 1;
                int n4 = 1;
                if (node != null) {
                    n2 = node.getPosition();
                    n3 = node.getStartLine();
                    n4 = Math.max(1, node.getSize());
                }
                this.fErrors.add(new ScreenerError(new Function(this.fFile, this.fFile.getName()), this.mapPosition(n2), n3, n4, BuildErrorSeverity.WARNING, string != null ? string : CoderResources.getString("screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false) + ".report")));
            }
        }
    }

    public synchronized void add(String string, List<MTree.Node> list) {
        int n = this.addBadNodes(ScreenerProblemType.UNSUPPORTED_FUNCTION, string, list);
        FileImpactModel.add(this.fMathworksFunctionImpact, string, n);
        FileImpactModel.add(this.fProblemImpact, ScreenerProblemType.UNSUPPORTED_FUNCTION, n);
        for (MTree.Node node : list) {
            node = node.getLeft();
            this.fErrors.add(new ScreenerError(new Function(this.fFile, this.fFile.getName()), this.mapPosition(node.getPosition()), node.getStartLine(), node.getSize(), BuildErrorSeverity.WARNING, MessageFormat.format(CoderResources.getString("screener.problem.unsupportedFunction.report"), string)));
        }
    }

    public synchronized int getNodeCount() {
        return this.fNodeCount;
    }

    public synchronized int getBadNodeCount() {
        return this.fBadNodes.size();
    }

    public synchronized int getLineCount() {
        return this.fLineCount;
    }

    public synchronized int getBadLineCount() {
        return this.fBadLines.size();
    }

    public synchronized Set<Integer> getLines(ScreenerProblemType screenerProblemType) {
        Set<Integer> set = this.fOffenseLines.get((Object)screenerProblemType);
        if (set == null) {
            return new TreeSet<Integer>();
        }
        return new TreeSet<Integer>(set);
    }

    public synchronized Set<Integer> getInvocationLines(String string) {
        Set<Integer> set = this.fFunctionOffenseLines.get(string);
        if (set == null) {
            return new TreeSet<Integer>();
        }
        return new TreeSet<Integer>(set);
    }

    public synchronized int getNodeCount(ScreenerProblemType screenerProblemType) {
        Integer n = this.fProblemImpact.get((Object)screenerProblemType);
        return n == null ? 0 : n;
    }

    public synchronized Set<String> getInvalidMathworksFunctions() {
        return new HashSet<String>(this.fMathworksFunctionImpact.keySet());
    }

    public synchronized int getInvocationNodeCount(String string) {
        Integer n = this.fMathworksFunctionImpact.get(string);
        return n == null ? 0 : n;
    }

    private synchronized int addBadNodes(ScreenerProblemType screenerProblemType, @Nullable String string, List<MTree.Node> list) {
        if (list.size() == 1 && list.get(0) == null) {
            return 0;
        }
        int n = this.fBadNodes.size();
        Set<Integer> set = this.fOffenseLines.get((Object)screenerProblemType);
        Set<Integer> set2 = null;
        if (string != null && (set2 = this.fFunctionOffenseLines.get(string)) == null) {
            set2 = new TreeSet<Integer>();
            this.fFunctionOffenseLines.put(string, set2);
        }
        if (set == null) {
            set = new TreeSet<Integer>();
            this.fOffenseLines.put(screenerProblemType, set);
        }
        this.fBadNodes.addAll(list);
        for (MTree.Node node : list) {
            set.add(node.getStartLine());
            if (set2 != null) {
                set2.add(node.getStartLine());
            }
            for (int i = node.getStartLine(); i <= node.getEndLine(); ++i) {
                this.fBadLines.add(i);
            }
        }
        return this.fBadNodes.size() - n;
    }

    private static <T> void add(Map<T, Integer> map, T t, int n) {
        if (n != 0) {
            Integer n2 = map.get(t);
            map.put(t, n2 == null ? n : n2 + n);
        }
    }

    private static int computeLineCount(MTree mTree) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        LinkedList<MTree.Node> linkedList = new LinkedList<MTree.Node>();
        linkedList.offer(mTree.getRoot());
        HashSet<MTree.Node> hashSet2 = new HashSet<MTree.Node>();
        while (!linkedList.isEmpty()) {
            MTree.Node node = (MTree.Node)linkedList.poll();
            if (node.getType() != MTree.NodeType.COMMENT && node.getType() != MTree.NodeType.FUNCTION && node.getStartLine() > 0) {
                for (int i = node.getStartLine(); i <= node.getEndLine(); ++i) {
                    hashSet.add(i);
                }
            }
            if (node.getNext() != null && hashSet2.add(node.getNext())) {
                linkedList.offer(node.getNext());
            }
            if (node.getLeft() != null && hashSet2.add(node.getLeft())) {
                linkedList.offer(node.getLeft());
            }
            if (node.getRight() != null && hashSet2.add(node.getRight())) {
                linkedList.offer(node.getRight());
            }
            if (node.getBody() == null || !hashSet2.add(node.getBody())) continue;
            linkedList.offer(node.getBody());
        }
        return hashSet.size();
    }

    private int mapPosition(int n) {
        if (this.fOffsetConverter == null) {
            try {
                this.fOffsetConverter = CoderFileSupport.getOffsetConverter(this.fFile);
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return this.fOffsetConverter.byteToCharPosition(n);
    }
}

