/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Target;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.UnifiedTargetFactory;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class ProjectScreenerModel {
    private static final String CODER_WHICH_COMMAND = "coder.internal.projectWhich";
    private final Configuration fConfiguration;
    private final FileSetInstance fEntryPoints;
    private final PropertyChangeListener fFileSetListener;
    private final PropertyChangeListener fPathListener;
    private final PropertyChangeListener fConfigurationListener;
    private final Map<FileLocation, UiFileList> fLists;
    private final MulticastChangeListener fChangeListeners;
    private final RequestQueue fRequestQueue;
    private volatile List<File> fRootLevelFiles;
    private volatile List<File> fFiles;
    private volatile boolean fInvisibleEntryPoint;
    private ScreenerReportModel fReportModel;
    private ScreenerTarget fTarget;

    public ProjectScreenerModel(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fEntryPoints = this.fConfiguration.getFileSet("fileset.entrypoints");
        this.fRequestQueue = new RequestQueue("Request queue for code generation screener");
        this.fChangeListeners = new MulticastChangeListener();
        this.fFiles = new ArrayList<File>(0);
        this.fRootLevelFiles = new ArrayList<File>(0);
        this.fFileSetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectScreenerModel.this.updateLists();
                ProjectScreenerModel.this.updateReport();
            }
        };
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.artifact")) {
                    ProjectScreenerModel.this.updateLists();
                    ProjectScreenerModel.this.updateReport();
                }
            }
        };
        this.fLists = new HashMap<FileLocation, UiFileList>();
        this.fEntryPoints.addPropertyChangeListener(this.fFileSetListener);
        if (!this.fEntryPoints.getFiles().isEmpty()) {
            this.updateLists();
            this.updateReport();
        }
        this.fPathListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectScreenerModel.this.updateReport();
            }
        };
        MatlabPathModel.getInstance().addPropertyChangeListener(this.fPathListener);
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
    }

    public ProjectScreenerModel(Configuration configuration, ScreenerTarget screenerTarget) {
        this(configuration);
        this.fTarget = screenerTarget;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public ScreenerReportModel getReportModel() {
        return this.fReportModel;
    }

    public boolean hasInvisibleEntryPoint() {
        return this.fInvisibleEntryPoint;
    }

    private void updateLists() {
        this.findAllFiles(new ParameterRunnable<List<File>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(List<File> list) {
                Map map = ProjectScreenerModel.this.fLists;
                synchronized (map) {
                    ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>();
                    for (File object : list) {
                        FileLocation fileLocation = new FileLocation(object.getParentFile());
                        if (DependencyFileSystem.isInToolbox(fileLocation.toString())) continue;
                        arrayList.add(fileLocation);
                        if (ProjectScreenerModel.this.fLists.containsKey(fileLocation)) continue;
                        try {
                            UiFileList uiFileList = new UiFileList(ProjectScreenerModel.this.fRequestQueue, RealFileSystem.getInstance().getList(fileLocation), true);
                            uiFileList.addListener((ExpansionChangeListener)new ExpansionChangeListener<FileSystemEntry>(){

                                public void childrenChanged(GroupingTableTransaction<FileSystemEntry> groupingTableTransaction) {
                                    ProjectScreenerModel.this.updateLists();
                                    ProjectScreenerModel.this.updateReport();
                                }

                                public void hasChildrenChanged() {
                                    ProjectScreenerModel.this.updateLists();
                                    ProjectScreenerModel.this.updateReport();
                                }
                            });
                            ProjectScreenerModel.this.fLists.put(fileLocation, uiFileList);
                        }
                        catch (IOException iOException) {}
                    }
                    Iterator<Object> iterator = ProjectScreenerModel.this.fLists.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (arrayList.contains(entry.getKey())) continue;
                        ((UiFileList)entry.getValue()).close();
                        iterator.remove();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<FileLocation, UiFileList> map = this.fLists;
        synchronized (map) {
            for (UiFileList uiFileList : this.fLists.values()) {
                uiFileList.close();
            }
            this.fLists.clear();
            this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
            MatlabPathModel.getInstance().removePropertyChangeListener(this.fPathListener);
            this.fEntryPoints.removePropertyChangeListener(this.fFileSetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllFiles(ParameterRunnable<List<File>> parameterRunnable) {
        final ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        if (this.fEntryPoints.getCurrentCount() == 0) {
            this.fFiles = new ArrayList<File>(0);
            parameterRunnable.run(this.fFiles);
            return;
        }
        for (File file : this.fEntryPoints.getFiles()) {
            Object object = arrayList;
            synchronized (object) {
                arrayList.add(file);
                arrayList2.add(file);
            }
            try {
                object = new DependencyFileSystem(RealFileSystem.getInstance().getEntry(new FileLocation(file)), this.fTarget);
                FileList fileList = ((DependencyFileSystem)object).search(FileLocation.ROOT, new SearchCriteria("*"), new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        return true;
                    }
                });
                fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>((DependencyFileSystem)object, arrayList2, parameterRunnable){
                    final /* synthetic */ DependencyFileSystem val$dependencies;
                    final /* synthetic */ List val$rootLevelFiles;
                    final /* synthetic */ ParameterRunnable val$output;
                    {
                        this.val$dependencies = dependencyFileSystem;
                        this.val$rootLevelFiles = list2;
                        this.val$output = parameterRunnable;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        if (!DependencyFileSystem.isInToolbox(fileSystemEntry.getLocation().toString())) {
                            List list = arrayList;
                            synchronized (list) {
                                arrayList.add(this.val$dependencies.getLocation(fileSystemEntry.getLocation()).toFile());
                            }
                        }
                        return true;
                    }

                    public void finished() {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                List list = arrayList;
                                synchronized (list) {
                                    ProjectScreenerModel.this.fFiles = new ArrayList(arrayList);
                                    ProjectScreenerModel.this.fRootLevelFiles = new ArrayList(val$rootLevelFiles);
                                    val$output.run((Object)ProjectScreenerModel.this.fFiles);
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException iOException) {}
        }
    }

    public void updateReportAndRun(Runnable runnable) {
        this.updateReport(runnable);
    }

    public void updateReport() {
        this.updateReport(null);
    }

    private void updateReport(final @Nullable Runnable runnable) {
        Matlab.whenAtPrompt((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectScreenerModel.this.fInvisibleEntryPoint = false;
                for (File file : ProjectScreenerModel.this.fEntryPoints.getFiles()) {
                    try {
                        String string;
                        File file2 = file.getAbsoluteFile().getParentFile();
                        String string2 = file2.getAbsolutePath();
                        Object[] objectArray = new Object[]{string2, string = file.getAbsolutePath()};
                        Object object = Matlab.mtFeval((String)ProjectScreenerModel.CODER_WHICH_COMMAND, (Object[])objectArray, (int)1);
                        if (object != null && !object.toString().isEmpty()) continue;
                        ProjectScreenerModel.this.fInvisibleEntryPoint = true;
                        break;
                    }
                    catch (MatlabException matlabException) {
                        throw new IllegalStateException("Error invoking coder.internal.projectWhich", matlabException);
                    }
                    catch (Exception exception) {
                        ProjectScreenerModel.this.fInvisibleEntryPoint = true;
                        break;
                    }
                }
                ProjectScreenerModel.this.fRequestQueue.request(new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectScreenerModel.this.fInvisibleEntryPoint || ProjectScreenerModel.this.fEntryPoints.getFiles().isEmpty()) {
                            ProjectScreenerModel.this.fReportModel = null;
                        } else {
                            ProjectScreenerModel.this.fReportModel = new ScreenerReportModel(new ArrayList<File>(ProjectScreenerModel.this.getRootLevelFiles()), ProjectScreenerModel.this.getCurrentScreenerTarget());
                        }
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ProjectScreenerModel.this.fChangeListeners.stateChanged(new ChangeEvent(ProjectScreenerModel.this));
                            }
                        });
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getRootLevelFiles() {
        List<File> list = this.fFiles;
        synchronized (list) {
            return new ArrayList<File>(this.fRootLevelFiles);
        }
    }

    private ScreenerTarget getCurrentScreenerTarget() {
        String string;
        if (this.fTarget != null) {
            return this.fTarget;
        }
        Target target = this.fConfiguration.getTarget();
        if (target.getKey().equals("target.matlab.hdlcoder")) {
            return ScreenerTarget.HDL;
        }
        if (UnifiedTargetFactory.isUnifiedTarget(target) && GenericArtifact.FIXED_POINT.getObjectiveString().equals(this.fConfiguration.getParamAsString("param.objective"))) {
            return ScreenerTarget.FIXED_POINT;
        }
        switch (string = this.fConfiguration.getParamAsString("param.artifact")) {
            case "option.target.artifact.mex.instrumented": {
                return ScreenerTarget.MEX;
            }
            case "option.target.artifact.mex": {
                return ScreenerTarget.MEX;
            }
        }
        return ScreenerTarget.C;
    }
}

