/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Holder;
import com.mathworks.util.Predicate;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoderExceptionLogger {
    private static final int DEFAULT_EXCEPTION_LOG_LENGTH = 25;
    private static final String DEFAULT_LOG_FILENAME = "coder_exception_log.txt";
    private static final String SUN_EXCEPTION_HANDLER_KEY = "sun.awt.exception.handler";
    private static final boolean JAVA_NOT_DOLPHIN_OR_LATER = !CoderExceptionLogger.isJavaDolphinOrLater();
    private static final Predicate<Thread> LOGGABLE_THREAD_PREDICATE = CoderExceptionLogger.createNonMatlabThreadPredicate();
    private final LogWriter fLogWriter;
    private final ScreenshotPolicy fScreenshotPolicy;
    private final File fLogDir;
    private final File fLogFile;
    private final Map<StackTraceKey, ExceptionContext> fExceptions;
    private final Object fDataMutex;
    private ExecutorService fThread;

    public CoderExceptionLogger(@Nullable File file, boolean bl, boolean bl2) {
        if (file != null && file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("logDir must be a directory");
        }
        this.fLogDir = file;
        this.fLogFile = file != null ? new File(file, DEFAULT_LOG_FILENAME) : null;
        this.fDataMutex = new Object();
        this.fExceptions = CoderExceptionLogger.createCappedSizeMap(25);
        this.fScreenshotPolicy = bl ? ScreenshotPolicy.CREATE : ScreenshotPolicy.IGNORE;
        LogWriter logWriter = file != null ? new FileLogWriter(this.fLogFile) : new LogWriter();
        this.fLogWriter = new DefaultLogWriter(logWriter, !bl2);
    }

    public CoderExceptionLogger(@Nullable File file) {
        this(file, false, true);
    }

    public CoderExceptionLogger() {
        this(null, false, false);
    }

    public static void monitorEval(@NotNull String string) {
        final CoderExceptionLogger coderExceptionLogger = new CoderExceptionLogger();
        coderExceptionLogger.startLogging();
        new Matlab().evalConsoleOutput(string, new CompletionObserver(){

            public void completed(int n, Object object) {
                coderExceptionLogger.stopLogging();
                if (coderExceptionLogger.getLoggedTotal() > 0) {
                    coderExceptionLogger.dumpToConsole();
                }
            }
        });
    }

    public static void monitorTest(@NotNull String string, @Nullable String string2) {
        CoderExceptionLogger.monitorEval("runsuite " + string + (string2 != null ? " -testspec:" + string2 : ""));
    }

    public static void monitorTest(@NotNull String string) {
        CoderExceptionLogger.monitorTest(string, null);
    }

    public synchronized void startLogging() {
        this.clear();
        ExceptionHandler.registerClient(this);
        this.fLogWriter.startLogging();
        if (this.fThread == null || this.fThread.isShutdown()) {
            this.fThread = Executors.newSingleThreadExecutor();
        }
    }

    public synchronized void stopLogging() {
        ExceptionHandler.unregisterClient(this);
        this.fLogWriter.endLogging();
        if (this.fThread != null) {
            this.fThread.shutdown();
        }
    }

    public void dumpToConsole() {
        if (this.getLoggedTotal() == 0) {
            return;
        }
        StringLogWriter stringLogWriter = new StringLogWriter();
        DefaultLogWriter defaultLogWriter = new DefaultLogWriter(stringLogWriter, true);
        defaultLogWriter.startLogging();
        defaultLogWriter.endLogging();
        System.err.println("RuntimeExceptions detected off of the MATLAB Thread");
        System.err.println(stringLogWriter.getString().replaceAll("[\r]", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.fDataMutex;
        synchronized (object) {
            this.fExceptions.clear();
        }
        object = this;
        synchronized (object) {
            this.fLogWriter.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoggedTotal() {
        int n = 0;
        Object object = this.fDataMutex;
        synchronized (object) {
            for (ExceptionContext exceptionContext : this.fExceptions.values()) {
                n += exceptionContext.getLoggedCount();
            }
        }
        return n;
    }

    public File getLogFile() {
        return this.fLogFile;
    }

    private synchronized void onExceptionLogged(final Throwable throwable, final BufferedImage bufferedImage, final Thread thread, final long l) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StackTraceKey stackTraceKey = new StackTraceKey(throwable);
                Object object = CoderExceptionLogger.this.fDataMutex;
                synchronized (object) {
                    ExceptionContext exceptionContext = (ExceptionContext)CoderExceptionLogger.this.fExceptions.get(stackTraceKey);
                    if (exceptionContext == null) {
                        File file = null;
                        if (bufferedImage != null && CoderExceptionLogger.this.fScreenshotPolicy == ScreenshotPolicy.CREATE) {
                            for (int i = 0; i < 100 && (file = new File(CoderExceptionLogger.this.fLogDir, l + "_" + i + ".png")).exists(); ++i) {
                            }
                            if (file.exists()) {
                                file = null;
                            } else {
                                CoderExceptionLogger.this.getScreenshotPolicy().writeScreenshot(bufferedImage, file);
                            }
                        }
                        exceptionContext = new ExceptionContext(throwable, file, thread, l);
                        CoderExceptionLogger.this.fExceptions.put(stackTraceKey, exceptionContext);
                    } else {
                        exceptionContext.incrementCount();
                        exceptionContext.setTimestamp(l);
                    }
                    CoderExceptionLogger.this.fLogWriter.writeLogEntry(exceptionContext);
                }
            }
        };
        if (this.fThread != null && !this.fThread.isShutdown()) {
            this.fThread.execute(runnable);
        }
    }

    private ScreenshotPolicy getScreenshotPolicy() {
        return this.fScreenshotPolicy;
    }

    private static <K, V> Map<K, V> createCappedSizeMap(final int n) {
        return new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > n;
            }
        };
    }

    private static void printLoggedException(PrintWriter printWriter, ExceptionContext exceptionContext, String string) {
        printWriter.println("-----------------------------------------------------------------------------");
        String string2 = exceptionContext.getScreenshotFile() != null ? exceptionContext.getScreenshotFile().getAbsolutePath() : "N/A";
        String string3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(exceptionContext.getTimestamp());
        printWriter.format("%s[Last Occurrence = %s][Frequency = %d][Screenshot = %s]%n", string != null ? string + "\t" : "", string3, exceptionContext.getLoggedCount(), string2);
        exceptionContext.getException().printStackTrace(printWriter);
        printWriter.println("-----------------------------------------------------------------------------");
        printWriter.println();
        printWriter.println();
        printWriter.flush();
    }

    private static Predicate<Thread> createNonMatlabThreadPredicate() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Holder holder = new Holder();
        try {
            new MatlabWorker<Boolean>(){

                public Boolean runOnMatlabThread() throws Exception {
                    holder.set((Object)Thread.currentThread());
                    countDownLatch.countDown();
                    return true;
                }

                public void runOnAWTEventDispatchThread(Boolean bl) {
                }
            }.runOnMatlabThread();
        }
        catch (Exception exception) {
            countDownLatch.countDown();
        }
        try {
            countDownLatch.await();
            return new Predicate<Thread>(){

                public boolean accept(Thread thread) {
                    return !((Thread)holder.get()).equals(thread);
                }
            };
        }
        catch (InterruptedException interruptedException) {
            return new Predicate<Thread>(){

                public boolean accept(Thread thread) {
                    return true;
                }
            };
        }
    }

    public static void generateRuntimeException(int n) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                double d = Math.random();
                if (d < 0.33) {
                    throw new NullPointerException("Null Pointer!");
                }
                if (d < 0.67) {
                    throw new IndexOutOfBoundsException("Index out of bounds!");
                }
                throw new ClassCastException("Casting problem!");
            }
        };
        if (n > 0) {
            Timer timer = new Timer(n, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    runnable.run();
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            runnable.run();
        }
    }

    public static void generateRuntimeException() {
        CoderExceptionLogger.generateRuntimeException(0);
    }

    private static boolean isJavaDolphinOrLater() {
        String string = System.getProperty("java.version");
        return string == null || !string.startsWith("1.7");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Must specify a valid log directory");
        }
        final CoderExceptionLogger coderExceptionLogger = new CoderExceptionLogger(new File(stringArray[0]));
        coderExceptionLogger.startLogging();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                jFrame.add(new JButton(new AbstractAction("Runtime Exception!"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CoderExceptionLogger.generateRuntimeException(100);
                    }
                }));
                jFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        coderExceptionLogger.stopLogging();
                        coderExceptionLogger.dumpToConsole();
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        });
    }

    private static class ExceptionHandler {
        private static final Collection<CoderExceptionLogger> CLIENTS = new LinkedList<CoderExceptionLogger>();
        private static Thread.UncaughtExceptionHandler sPreviousHandler;
        private static String sPreviousHandlerClassName;
        private static Robot sRobot;
        private static boolean sActive;
        private static boolean sShouldCapture;
        private static ExecutorService sThreadPool;

        private ExceptionHandler() {
        }

        static synchronized void registerClient(CoderExceptionLogger coderExceptionLogger) {
            CLIENTS.add(coderExceptionLogger);
            sShouldCapture = sShouldCapture || coderExceptionLogger.getScreenshotPolicy() == ScreenshotPolicy.CREATE;
            ExceptionHandler.install();
        }

        static synchronized void unregisterClient(CoderExceptionLogger coderExceptionLogger) {
            CLIENTS.remove(coderExceptionLogger);
            if (CLIENTS.isEmpty()) {
                ExceptionHandler.uninstall();
            } else if (sShouldCapture) {
                sShouldCapture = false;
                for (CoderExceptionLogger coderExceptionLogger2 : CLIENTS) {
                    if (coderExceptionLogger2.getScreenshotPolicy() != ScreenshotPolicy.CREATE) continue;
                    sShouldCapture = true;
                    break;
                }
            }
        }

        private static synchronized void install() {
            if (sActive) {
                return;
            }
            if (sThreadPool == null) {
                sThreadPool = Executors.newSingleThreadExecutor();
            }
            if (sShouldCapture && sRobot == null) {
                try {
                    sRobot = new Robot();
                }
                catch (AWTException aWTException) {
                    sThreadPool.shutdown();
                    sThreadPool = null;
                }
            }
            if (JAVA_NOT_DOLPHIN_OR_LATER) {
                sPreviousHandlerClassName = System.getProperty(CoderExceptionLogger.SUN_EXCEPTION_HANDLER_KEY);
                System.setProperty(CoderExceptionLogger.SUN_EXCEPTION_HANDLER_KEY, CoderExceptionHandler.class.getName());
            }
            sPreviousHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new CoderExceptionHandler(sPreviousHandler));
            sActive = true;
        }

        private static synchronized void uninstall() {
            if (!sActive) {
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(sPreviousHandler);
            if (JAVA_NOT_DOLPHIN_OR_LATER) {
                System.setProperty(CoderExceptionLogger.SUN_EXCEPTION_HANDLER_KEY, sPreviousHandlerClassName);
            }
            sRobot = null;
            if (sThreadPool != null) {
                sThreadPool.shutdown();
                sThreadPool = null;
            }
            sActive = false;
        }

        private static boolean isThreadEventDispatchThread(Thread thread) {
            return thread.getClass().getName().equals("java.awt.EventDispatchThread");
        }

        private static synchronized void processRuntimeException(final Throwable throwable, final Thread thread) {
            sThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ExceptionHandler> clazz = ExceptionHandler.class;
                    synchronized (ExceptionHandler.class) {
                        BufferedImage bufferedImage = null;
                        if (sShouldCapture && sRobot != null) {
                            bufferedImage = sRobot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
                        }
                        ExceptionHandler.notifyClientsOfException(throwable, thread, bufferedImage);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }

        private static synchronized void notifyClientsOfException(Throwable throwable, Thread thread, BufferedImage bufferedImage) {
            long l = System.currentTimeMillis();
            for (CoderExceptionLogger coderExceptionLogger : new LinkedList<CoderExceptionLogger>(CLIENTS)) {
                coderExceptionLogger.onExceptionLogged(throwable, bufferedImage, thread, l);
            }
        }

        public static class CoderExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private final Thread.UncaughtExceptionHandler fDefaultHandler;

            public CoderExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
                this.fDefaultHandler = uncaughtExceptionHandler;
            }

            public CoderExceptionHandler() {
                this(Thread.getDefaultUncaughtExceptionHandler());
            }

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (LOGGABLE_THREAD_PREDICATE.accept((Object)thread)) {
                    ExceptionHandler.processRuntimeException(throwable, thread);
                }
            }
        }
    }

    private static final class ExceptionContext
    implements Comparable<ExceptionContext> {
        private final Throwable fException;
        private final File fScreenshotFile;
        private final Thread fThread;
        private long fTimestamp;
        private int fCount;

        ExceptionContext(Throwable throwable, File file, Thread thread, long l) {
            this.fException = throwable;
            this.fScreenshotFile = file;
            this.fThread = thread;
            this.fTimestamp = l;
            this.fCount = 1;
        }

        Throwable getException() {
            return this.fException;
        }

        File getScreenshotFile() {
            return this.fScreenshotFile;
        }

        long getTimestamp() {
            return this.fTimestamp;
        }

        int getLoggedCount() {
            return this.fCount;
        }

        void incrementCount() {
            ++this.fCount;
        }

        void setTimestamp(long l) {
            this.fTimestamp = l;
        }

        @Override
        public int compareTo(@NotNull ExceptionContext exceptionContext) {
            return Long.valueOf(this.getTimestamp()).compareTo(exceptionContext.getTimestamp());
        }
    }

    private static final class StackTraceKey {
        private final StackTraceElement[] fStackTraceElements;

        StackTraceKey(Throwable throwable) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            this.fStackTraceElements = Arrays.copyOf(stackTraceElementArray, stackTraceElementArray.length);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StackTraceKey)) {
                return false;
            }
            return Arrays.equals(this.getStackTraceElements(), ((StackTraceKey)object).getStackTraceElements());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getStackTraceElements());
        }

        private StackTraceElement[] getStackTraceElements() {
            return this.fStackTraceElements;
        }
    }

    private static class StringLogWriter
    extends LogWriter {
        private final PrintWriter fPrintWriter;
        private final StringWriter fStringWriter = new StringWriter();

        StringLogWriter() {
            this.fPrintWriter = new PrintWriter((Writer)this.fStringWriter, true);
        }

        @Override
        void writeLogEntry(ExceptionContext exceptionContext) {
            CoderExceptionLogger.printLoggedException(this.fPrintWriter, exceptionContext, "");
        }

        @Override
        void reset() {
            this.fStringWriter.getBuffer().delete(0, this.fStringWriter.getBuffer().length());
        }

        String getString() {
            return this.fStringWriter.toString();
        }
    }

    private static class FileLogWriter
    extends LogWriter {
        private final File fFile;
        private PrintWriter fPrintWriter;
        private boolean fStarted;

        FileLogWriter(File file) {
            this.fFile = file;
        }

        @Override
        void startLogging() {
            if (this.fFile == null) {
                this.fPrintWriter = null;
                return;
            }
            try {
                if (!this.fFile.getParentFile().exists()) {
                    this.fFile.getParentFile().mkdirs();
                }
                this.fPrintWriter = new PrintWriter(this.fFile);
                this.fStarted = true;
            }
            catch (FileNotFoundException | SecurityException exception) {
                System.err.format("CoderExceptionLogger log path not writable: %s", this.fFile.getAbsolutePath());
            }
        }

        @Override
        void writeLogEntry(ExceptionContext exceptionContext) {
            if (this.fPrintWriter != null) {
                CoderExceptionLogger.printLoggedException(this.fPrintWriter, exceptionContext, "");
            }
        }

        @Override
        void endLogging() {
            if (this.fPrintWriter != null) {
                this.fPrintWriter.flush();
                this.fPrintWriter.close();
            }
            this.fStarted = false;
        }

        @Override
        void reset() {
            if (this.fStarted) {
                this.startLogging();
            }
        }
    }

    private class DefaultLogWriter
    extends LogWriter {
        private final LogWriter fOutputWriter;
        private final boolean fDeferred;

        DefaultLogWriter(LogWriter logWriter, boolean bl) {
            this.fOutputWriter = logWriter;
            this.fDeferred = bl;
        }

        @Override
        void writeLogEntry(ExceptionContext exceptionContext) {
            if (!this.fDeferred) {
                this.dump();
                this.fOutputWriter.endLogging();
            }
        }

        @Override
        void endLogging() {
            if (this.fDeferred) {
                this.dump();
                this.fOutputWriter.endLogging();
            }
        }

        @Override
        void reset() {
            if (!this.fDeferred) {
                this.fOutputWriter.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dump() {
            this.fOutputWriter.startLogging();
            ArrayList arrayList = new ArrayList();
            Iterator iterator = CoderExceptionLogger.this.fDataMutex;
            synchronized (iterator) {
                arrayList.addAll(CoderExceptionLogger.this.fExceptions.values());
            }
            Collections.sort(arrayList, Collections.reverseOrder());
            for (ExceptionContext exceptionContext : arrayList) {
                this.fOutputWriter.writeLogEntry(exceptionContext);
            }
        }
    }

    private static class LogWriter {
        private LogWriter() {
        }

        void startLogging() {
        }

        void writeLogEntry(ExceptionContext exceptionContext) {
        }

        void endLogging() {
        }

        void reset() {
        }
    }

    private static enum ScreenshotPolicy {
        CREATE{

            @Override
            void writeScreenshot(BufferedImage bufferedImage, File file) {
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        ,
        IGNORE{

            @Override
            void writeScreenshot(BufferedImage bufferedImage, File file) {
            }
        };


        abstract void writeScreenshot(BufferedImage var1, File var2);
    }
}

