/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.CoderStepViewFactory;
import com.mathworks.toolbox.coder.wfa.WorkflowAdvisor;
import com.mathworks.util.PlatformInfo;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public final class CoderWorkflowFrame {
    private final CoderApp fApp;
    private final MJFrame fFrame;
    private static final List<Image> C_ICONS = CoderWorkflowFrame.loadIcons(false, "matlab_coder");
    private static final List<Image> HDL_ICONS = CoderWorkflowFrame.loadIcons(false, "matlab_coder_hdl");
    private static final List<Image> FIXED_POINT_ICONS = CoderWorkflowFrame.loadIcons(true, "fixedpoint");

    public CoderWorkflowFrame(CoderApp coderApp) {
        this.fApp = coderApp;
        this.fFrame = new MJFrame();
        GlassPaneManager glassPaneManager = new GlassPaneManager(this.fFrame.getRootPane());
        coderApp.setFrame(this.fFrame, glassPaneManager);
        CoderStepViewFactory coderStepViewFactory = new CoderStepViewFactory(coderApp);
        WorkflowAdvisor workflowAdvisor = new WorkflowAdvisor(coderApp, new CoderStepModel(coderApp, coderStepViewFactory), coderStepViewFactory);
        this.fFrame.add(workflowAdvisor.getComponent());
        this.fFrame.setSize(!PlatformInfo.isWindows() ? 1045 : 980, 740);
        this.fFrame.setMinimumSize(this.fFrame.getSize());
        this.fFrame.setName("frame.coder");
        WindowUtils.centerWindowOnScreen((Window)this.fFrame);
        this.fFrame.setVisible(true);
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "@file" || propertyChangeEvent.getPropertyName() == "generic-artifact") {
                    CoderWorkflowFrame.this.updateTitle();
                }
            }
        });
        this.updateTitle();
        this.fFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CoderWorkflowFrame.this.fApp.close();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                CoderWorkflowFrame.this.fApp.close();
            }
        });
    }

    private void updateTitle() {
        String string = "c";
        List<Image> list = C_ICONS;
        GenericArtifact genericArtifact = this.fApp.getModel().getGenericArtifact();
        if (genericArtifact == GenericArtifact.HDL) {
            string = "hdl";
            list = HDL_ICONS;
        } else if (genericArtifact == GenericArtifact.FIXED_POINT) {
            string = "fixedpoint";
            list = FIXED_POINT_ICONS;
        }
        String string2 = CoderResources.getString("wfa.title." + string);
        this.fFrame.setIconImages(list);
        if (this.fApp.getModel().isTemporaryProjectFile()) {
            this.fFrame.setTitle(string2);
        } else {
            this.fFrame.setTitle(string2 + " - " + this.fApp.getModel().getConfiguration().getFile().getName());
        }
    }

    private static List<Image> loadIcons(boolean bl, String string) {
        ArrayList<Image> arrayList = new ArrayList<Image>(2);
        if (bl) {
            arrayList.add(((ImageIcon)CoderResources.getIcon(string + "_16.png")).getImage());
            arrayList.add(((ImageIcon)CoderResources.getIcon(string + "_24.png")).getImage());
        } else {
            arrayList.add(CoderResources.getCommonIcon(string + "_16.png").getImage());
            arrayList.add(CoderResources.getCommonIcon(string + "_24.png").getImage());
        }
        return arrayList;
    }
}

