/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.impl.desktop.PackageAction;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Project;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.mi.InferenceMI;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.PackageWrapper;
import com.mathworks.toolbox.coder.wfa.build.BuildCommand;
import com.mathworks.toolbox.coder.wfa.build.BuildOutputHandler;
import com.mathworks.toolbox.coder.wfa.files.FileSetViewGroup;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public final class BuildManager {
    private final CoderApp fApp;
    private final IDEContext fIDEContext;
    private final List<ParameterRunnable<Boolean>> fBuildFinishListeners;
    private final List<ParameterRunnable<Boolean>> fPackageFinishListeners;
    private final RelativeFileFilter fOutputFileFilter;
    public static final String PACKAGE_TASK_KEY = "package";
    public static final String BUILD_LOG_LABEL = CoderResources.getString("wfa.log.build");
    public static final String PACKAGE_LOG_LABEL = CoderResources.getString("wfa.log.package");

    public BuildManager(CoderApp coderApp, IDEContext iDEContext, RelativeFileFilter relativeFileFilter) {
        this.fApp = coderApp;
        this.fIDEContext = iDEContext;
        this.fOutputFileFilter = relativeFileFilter;
        this.fBuildFinishListeners = new LinkedList<ParameterRunnable<Boolean>>();
        this.fPackageFinishListeners = new LinkedList<ParameterRunnable<Boolean>>();
    }

    public BuildManager(CoderApp coderApp, IDEContext iDEContext, RelativeFilenameFilter relativeFilenameFilter) {
        this(coderApp, iDEContext, new FilterBridge(relativeFilenameFilter));
    }

    public BuildManager(CoderApp coderApp, IDEContext iDEContext) {
        this(coderApp, iDEContext, BuildManager.createDefaultOutputFileFilter());
    }

    public void addBuildFinishListener(ParameterRunnable<Boolean> parameterRunnable) {
        this.fBuildFinishListeners.add(parameterRunnable);
    }

    public void removeBuildFinishListener(ParameterRunnable<Boolean> parameterRunnable) {
        this.fBuildFinishListeners.remove(parameterRunnable);
    }

    public void addPackageFinishListener(ParameterRunnable<Boolean> parameterRunnable) {
        this.fPackageFinishListeners.add(parameterRunnable);
    }

    public void removePackageFinishListener(ParameterRunnable<Boolean> parameterRunnable) {
        this.fPackageFinishListeners.remove(parameterRunnable);
    }

    public void startBuild() {
        this.fApp.getEditManager().saveAll();
        EditorView editorView = this.fApp.getIDEView().getCodeInfoView().getEditorView();
        final FileSetViewGroup fileSetViewGroup = this.fApp.getIDEView().getFileSets();
        editorView.setBuildErrors(new ArrayList<BuildError>(0), true);
        final SourceSet sourceSet = this.fApp.getModel().getActiveInputSourceSet();
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fApp.getModel().getConfiguration(), (Command[])new Command[]{new BuildCommand(this.fApp, new BuildOutputHandler(){

            @Override
            public void buildFinished(File file, final Set<File> set, final List<BuildError> list, final InferenceMI.Inference inference) {
                final Set set2 = BuildManager.crawlDirectory(file, BuildManager.this.fOutputFileFilter, new TreeSet());
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!set.isEmpty()) {
                            sourceSet.setFiles(set);
                        }
                        BuildManager.this.fApp.getModel().setOutputFiles(set2);
                        BuildManager.this.fApp.getModel().setErrors(list);
                        if (inference != null) {
                            BuildManager.this.fApp.getModel().getInferenceModel().setData(inference);
                        }
                        BuildManager.this.fApp.getModel().setSuppressScreenerUpdate(true);
                        if (list.isEmpty()) {
                            fileSetViewGroup.select(BuildManager.this.getDefaultOutputFile());
                        }
                        boolean bl = !BuildManager.this.isTrueErrorsOnly(list);
                        for (ParameterRunnable parameterRunnable : new ArrayList(BuildManager.this.fBuildFinishListeners)) {
                            parameterRunnable.run((Object)bl);
                        }
                        if (!BuildManager.this.fApp.getModel().getErrors().isEmpty()) {
                            BuildManager.this.fIDEContext.showErrors("build", "build-errors", BUILD_LOG_LABEL, true, true, null, BuildManager.this.fApp.getModel().getErrors());
                        }
                    }
                });
            }
        })});
        this.fIDEContext.runWithLog("build", BUILD_LOG_LABEL, deploymentProcess);
    }

    public void startPackage() {
        final Configuration configuration = this.fApp.getModel().getConfiguration();
        PackageAction.promptForFileAndPackage((Component)this.fApp.getWindow(), (Project)configuration.getProject(), (ParameterRunnable)new ParameterRunnable<File>(){

            public void run(File file) {
                final PackageWrapper packageWrapper = new PackageWrapper(configuration, file, false);
                DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)configuration, (Command[])new Command[]{packageWrapper});
                deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){

                    public void failed() {
                        this.notifyListeners(false);
                    }

                    public void canceled() {
                        this.notifyListeners(false);
                    }

                    public void finished() {
                        this.notifyListeners(true);
                    }

                    private void notifyListeners(boolean bl) {
                        for (ParameterRunnable parameterRunnable : new ArrayList(BuildManager.this.fPackageFinishListeners)) {
                            parameterRunnable.run((Object)bl);
                        }
                    }
                });
                BuildManager.this.fIDEContext.runWithLog(BuildManager.PACKAGE_TASK_KEY, PACKAGE_LOG_LABEL, deploymentProcess, null, null, new Predicate<BufferedLogSource>(){

                    public boolean accept(BufferedLogSource bufferedLogSource) {
                        return bufferedLogSource.getPlainText().trim().equals(packageWrapper.toString());
                    }
                });
            }
        });
    }

    private File getDefaultOutputFile() {
        File file = this.fApp.getModel().getEntryPoint();
        if (file != null) {
            String string = new FileLocation(file).getNameBeforeDot();
            for (File file2 : this.fApp.getModel().getOutputFiles()) {
                if (!new FileLocation(file2).getNameBeforeDot().equals(string)) continue;
                return file2;
            }
        }
        if (!this.fApp.getModel().getOutputFiles().isEmpty()) {
            return this.fApp.getModel().getOutputFiles().iterator().next();
        }
        return null;
    }

    private boolean isTrueErrorsOnly(Collection<BuildError> collection) {
        for (BuildError buildError : collection) {
            if (buildError.getSeverity() != BuildErrorSeverity.WARNING) continue;
            return false;
        }
        return true;
    }

    private static Set<File> crawlDirectory(File file, RelativeFileFilter relativeFileFilter, Set<File> set) {
        if (set == null) {
            set = new LinkedHashSet<File>();
        } else {
            set.clear();
        }
        Stack<File> stack = new Stack<File>();
        stack.push(file);
        while (!stack.isEmpty()) {
            File file2 = (File)stack.pop();
            if (!file2.isDirectory()) continue;
            for (File file3 : file2.listFiles()) {
                if (!relativeFileFilter.accept(file, file3)) continue;
                if (file3.isDirectory()) {
                    stack.push(file3);
                    continue;
                }
                set.add(file3);
            }
        }
        return set;
    }

    private static RelativeFileFilter createDefaultOutputFileFilter() {
        return new RelativeFileFilter(){

            @Override
            public boolean accept(File file, File file2) {
                if (file2.isDirectory()) {
                    return file2.getName().equals("html");
                }
                if (new FileLocation(file2).checkExtension(new String[]{"c", "h", "cpp", "hpp", "vhd", "v"})) {
                    return true;
                }
                return file2.getParentFile().getName().equals("html") && file2.getName().equals("index.html");
            }
        };
    }

    private static class FilterBridge
    implements RelativeFileFilter {
        private final RelativeFilenameFilter fFilenameFilter;

        FilterBridge(RelativeFilenameFilter relativeFilenameFilter) {
            this.fFilenameFilter = relativeFilenameFilter;
        }

        @Override
        public boolean accept(File file, File file2) {
            return this.fFilenameFilter.accept(FilterBridge.convertToRelativePathStrings(file, file2), file2.isDirectory());
        }

        private static List<String> convertToRelativePathStrings(File file, File file2) {
            LinkedList<String> linkedList = new LinkedList<String>();
            while (file2 != null && !file2.equals(file)) {
                linkedList.add(file2.getName());
                file2 = file2.getParentFile();
            }
            Collections.reverse(linkedList);
            return linkedList;
        }
    }

    public static interface RelativeFilenameFilter {
        public boolean accept(List<String> var1, boolean var2);
    }

    public static interface RelativeFileFilter {
        public boolean accept(File var1, File var2);
    }
}

