/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.wfa.core.ActionButton;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepModelAdapter;
import com.mathworks.toolbox.coder.wfa.core.StepSummaryView;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DefaultStepSummaryView
implements StepSummaryView {
    private final MJPanel fComponent;
    private final MJLabel fNameLabel;
    private final MJMultilineLabel fDescriptionLabel;
    private final MJButton fButton;
    private final StepModel fStepModel;

    public DefaultStepSummaryView(CoderApp coderApp, final StepModel stepModel, StepViewFactory stepViewFactory, final Step step) {
        this.fStepModel = stepModel;
        this.fComponent = new MJPanel(new BorderLayout(0, 12)){

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        this.fComponent.putClientProperty((Object)"Step", (Object)step);
        this.fComponent.setOpaque(false);
        ReturnRunnable<Boolean> returnRunnable = new ReturnRunnable<Boolean>(){

            public Boolean run() {
                return DefaultStepSummaryView.this.fStepModel.getNextSuggestedStep() == step;
            }
        };
        this.fButton = new ActionButton(DefaultStepSummaryView.centerAndWrap(step.getName(coderApp.getModel())), step.getIcon(), (ReturnRunnable)returnRunnable){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (PlatformInfo.isMacintosh()) {
                    return new Dimension(dimension.width + 16, dimension.height + 16);
                }
                return dimension;
            }
        };
        this.fNameLabel = new MJLabel(DefaultStepSummaryView.centerAndWrap(step.getName(coderApp.getModel()))){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (PlatformInfo.isMacintosh()) {
                    return new Dimension(dimension.width + 24, dimension.height + 24);
                }
                return dimension;
            }
        };
        this.fNameLabel.setIcon(step.getIcon());
        this.fNameLabel.setBorder((Border)new EmptyBorder(4, 0, 0, 0));
        this.fNameLabel.setFont(CoderApp.getFont().deriveFont(16.0f));
        this.fNameLabel.setVerticalTextPosition(3);
        this.fNameLabel.setHorizontalTextPosition(0);
        this.fNameLabel.setHorizontalAlignment(0);
        this.fNameLabel.setName(step.getKey() + ".label");
        this.fButton.setVerticalTextPosition(3);
        this.fButton.setHorizontalTextPosition(0);
        this.fButton.setFont(this.fNameLabel.getFont());
        this.fButton.setHorizontalAlignment(0);
        this.fButton.setName(step.getKey() + ".button");
        this.fDescriptionLabel = new MJMultilineLabel(this.fStepModel.getDescription(step), true);
        this.fDescriptionLabel.setFont(CoderApp.getFont());
        if (PlatformInfo.isMacintosh()) {
            this.fDescriptionLabel.setFont(CoderApp.getFont().deriveFont(12.0f));
            this.fDescriptionLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
        }
        this.fDescriptionLabel.setForeground(new Color(90, 90, 90));
        this.fDescriptionLabel.setMaximumSize(new Dimension(250, 450));
        this.fDescriptionLabel.setOpaque(false);
        this.fDescriptionLabel.setName(step.getKey() + ".desc");
        this.fComponent.add((Component)this.fDescriptionLabel);
        this.fComponent.add((Component)this.fNameLabel, (Object)"North");
        stepModel.addStepModelListener(new StepModelAdapter(){

            @Override
            public void stepsChanged() {
                DefaultStepSummaryView.this.fComponent.revalidate();
                DefaultStepSummaryView.this.fComponent.repaint();
            }
        });
        this.fButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stepModel.setCurrentStep(step, true);
            }
        });
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultStepSummaryView.this.fDescriptionLabel.setText(DefaultStepSummaryView.this.fStepModel.getDescription(step));
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.fNameLabel.setEnabled(bl);
        this.fComponent.setEnabled(bl);
        this.fComponent.remove((Component)this.fNameLabel);
        this.fComponent.remove((Component)this.fButton);
        if (bl) {
            this.fComponent.add((Component)this.fButton, (Object)"North");
        } else {
            this.fComponent.add((Component)this.fNameLabel, (Object)"North");
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private static String centerAndWrap(String string) {
        return "<html><center>" + string + "</center></html>";
    }
}

