/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.jmi.tabcompletion.TabCompletionImpl;
import com.mathworks.jmi.tabcompletion.TabCompletionResults;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.project.impl.textfield.AutoCompleter;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestQueue;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;

public final class FunctionNamePrompt
extends FormattedTextField {
    private static final int DEFAULT_TOKEN = 0;
    private static final int COMPLETION_TOKEN = 500;
    private final ParameterRunnable<String> fEnterHandler;
    private final RequestQueue fCompletionQueue;
    private HintPopupFrame fMessagePopUp;

    public FunctionNamePrompt(ParameterRunnable<String> parameterRunnable) {
        this.setPrompt(CoderResources.getString("wfa.entrypoint.prompt"));
        this.getTextComponent().setFocusTraversalKeysEnabled(false);
        this.getTextComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FunctionNamePrompt.this.hideMessage();
            }
        });
        this.getTextComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                FunctionNamePrompt.this.hideMessage();
            }
        });
        this.fCompletionQueue = new RequestQueue("MATLAB Coder function name autocompletion");
        this.fEnterHandler = parameterRunnable;
        this.setTokenizer(new FormatTokenizer(){

            public List<Token> tokenize(String string) {
                return Arrays.asList(new Token(0, string));
            }
        });
        this.setCompleter(new AutoCompleter(){

            public void getSuggestedCompletion(List<Token> list, final ParameterRunnable<List<Token>> parameterRunnable) {
                final String string = FunctionNamePrompt.this.getText();
                if (!list.isEmpty()) {
                    FunctionNamePrompt.this.fCompletionQueue.request(new Runnable(){

                        @Override
                        public void run() {
                            FunctionNamePrompt.this.doTabCompletion(string, (ParameterRunnable<List<Token>>)parameterRunnable);
                        }
                    });
                }
            }
        });
    }

    private void doTabCompletion(String string, ParameterRunnable<List<Token>> parameterRunnable) {
        if (this.getText().isEmpty()) {
            parameterRunnable.run(Collections.emptyList());
            return;
        }
        Set<String> set = FunctionNamePrompt.getNamesInCurrentFolder();
        TabCompletionImpl tabCompletionImpl = new TabCompletionImpl();
        Future future = tabCompletionImpl.getCompletions(this.getText());
        ArrayList<Token> arrayList = new ArrayList<Token>();
        try {
            TabCompletionResults tabCompletionResults = (TabCompletionResults)future.get();
            if (!tabCompletionResults.getStrings().isEmpty()) {
                for (String string2 : tabCompletionResults.getStrings()) {
                    if (!set.contains(string2)) continue;
                    if (string2.length() <= string.length()) break;
                    arrayList.add(new Token(500, string2.substring(string.length())));
                    break;
                }
                if (!arrayList.isEmpty()) {
                    parameterRunnable.run(arrayList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Set<String> getNamesInCurrentFolder() {
        HashSet<String> hashSet = new HashSet<String>();
        File[] fileArray = MatlabPathModel.getInstance().getCurrentFolder().toFile().listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                FileLocation fileLocation = new FileLocation(file);
                if (!CoderFileSupport.isMatlabSourceFile(fileLocation)) continue;
                hashSet.add(fileLocation.getNameBeforeDot());
            }
        }
        return hashSet;
    }

    public void doEnter() {
        this.fEnterHandler.run((Object)this.getText().trim());
    }

    public void type(char c) {
        if (c != '\t') {
            super.type(c);
        }
    }

    public void hideMessage() {
        if (this.fMessagePopUp != null) {
            this.fMessagePopUp.close();
            this.fMessagePopUp = null;
        }
    }

    public void showMessage(String string) {
        if (PlatformInfo.isLinux()) {
            MJOptionPane.showMessageDialog((Component)this.getTextComponent(), (Object)string, (String)CoderResources.getString("wfa.entryPoints.title"), (int)0);
        } else {
            this.fMessagePopUp = new HintPopupFrame(SwingUtilities.windowForComponent(this.getComponent()), this.getComponent(), StringUtils.stripLinks((String)string), BuildErrorSeverity.ERROR.getIcon(), false, false, new ReturnRunnable<Point>(){

                public Point run() {
                    Point point = new Point(FunctionNamePrompt.this.getComponent().getWidth() / 2, FunctionNamePrompt.this.getComponent().getHeight());
                    SwingUtilities.convertPointToScreen(point, FunctionNamePrompt.this.getComponent());
                    return point;
                }
            });
        }
    }
}

