/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.util.MulticastChangeListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FileScopedNode {
    private final FileScopedNode fParent;
    private final File fFile;
    private final Object fValue;
    private final NodeType fNodeType;
    private final Map<String, Object> fProperties;
    private final List<FileScopedNode> fChildren;
    private final PropertyChangeSupport fSupport;
    private final MulticastChangeListener fListeners;

    public FileScopedNode(FileScopedNode fileScopedNode, Object object) {
        this(NodeType.VALUE_NODE, fileScopedNode, null, object);
    }

    public FileScopedNode(FileScopedNode fileScopedNode, Object object, File file) {
        this(NodeType.VALUE_NODE, fileScopedNode, file, object);
    }

    public FileScopedNode(FileScopedNode fileScopedNode, File file) {
        this(NodeType.FILE_NODE, fileScopedNode, file, null);
    }

    public FileScopedNode(FileSetIntegrationContext fileSetIntegrationContext) {
        this(NodeType.INTERNAL_ROOT, null, null, fileSetIntegrationContext);
    }

    private FileScopedNode(NodeType nodeType, FileScopedNode fileScopedNode, File file, Object object) {
        this.fParent = fileScopedNode;
        this.fFile = file;
        this.fValue = object;
        this.fNodeType = nodeType;
        this.fProperties = new HashMap<String, Object>();
        this.fChildren = new LinkedList<FileScopedNode>();
        this.fSupport = new PropertyChangeSupport(this);
        this.fListeners = new MulticastChangeListener();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
    }

    void addChild(FileScopedNode fileScopedNode) {
        if (!fileScopedNode.getParent().equals(this)) {
            throw new IllegalArgumentException(String.format("Node '%s' is not a child node of '%s'", fileScopedNode, this));
        }
        this.fChildren.add(fileScopedNode);
        this.fireStateChange();
    }

    protected void fireStateChange() {
        this.fListeners.stateChanged(new ChangeEvent(this));
        if (this.fParent != null) {
            this.fParent.fireStateChange();
        }
    }

    public void setProperty(String string, Object object) {
        Object object2 = this.fProperties.get(string);
        this.fProperties.put(string, object);
        this.fSupport.firePropertyChange(string, object2, object);
    }

    public Object getProperty(String string) {
        return this.fProperties.get(string);
    }

    public File getAssociatedFile() {
        if (this.fFile != null) {
            return this.fFile;
        }
        if (this.fParent != null) {
            return this.fParent.getAssociatedFile();
        }
        return null;
    }

    public FileScopedNode getParent() {
        return this.fParent;
    }

    public FileScopedNode getExternalRoot() {
        if (this.getNodeType().equals((Object)NodeType.INTERNAL_ROOT)) {
            return null;
        }
        FileScopedNode fileScopedNode = this;
        while (fileScopedNode.getParent() != null && !fileScopedNode.getParent().getNodeType().equals((Object)NodeType.INTERNAL_ROOT)) {
            fileScopedNode = fileScopedNode.getParent();
        }
        return fileScopedNode;
    }

    public FileSetIntegrationContext getInternalRootContext() {
        if (this.getNodeType().equals((Object)NodeType.INTERNAL_ROOT)) {
            return (FileSetIntegrationContext)this.getValue();
        }
        return this.getParent().getInternalRootContext();
    }

    public boolean hasParent() {
        return this.fParent != null;
    }

    public List<FileScopedNode> getChildren() {
        return new ArrayList<FileScopedNode>(this.fChildren);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.addChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Object getValue() {
        return this.fValue;
    }

    public Class<?> getValueType() {
        return this.fValue != null ? this.fValue.getClass() : null;
    }

    public NodeType getNodeType() {
        return this.fNodeType;
    }

    public boolean valueTypeEquals(Class<?> clazz) {
        return this.fValue != null && clazz != null && this.fValue.getClass().equals(clazz) || this.fValue == null && clazz == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileScopedNode)) {
            return false;
        }
        FileScopedNode fileScopedNode = (FileScopedNode)object;
        File file = this.getAssociatedFile();
        File file2 = fileScopedNode.getAssociatedFile();
        if (file != null ? !file.equals(file2) : file2 != null) {
            return false;
        }
        if (this.fNodeType != fileScopedNode.fNodeType) {
            return false;
        }
        if (this.fParent != null ? !this.fParent.equals(fileScopedNode.fParent) : fileScopedNode.fParent != null) {
            return false;
        }
        if (this.fValue != null ? !this.fValue.equals(fileScopedNode.fValue) : fileScopedNode.fValue != null) {
            return false;
        }
        FileSetIntegrationContext fileSetIntegrationContext = this.getInternalRootContext();
        return !(fileSetIntegrationContext != null ? !fileSetIntegrationContext.equals(fileScopedNode.getInternalRootContext()) : fileScopedNode.getInternalRootContext() != null);
    }

    public int hashCode() {
        File file = this.getAssociatedFile();
        int n = 0;
        n = 31 * n + (file != null ? file.hashCode() : 0);
        n = 31 * n + (this.fValue != null ? this.fValue.hashCode() : 0);
        n = 31 * n + this.fNodeType.hashCode();
        n = 31 * n + this.getInternalRootContext().hashCode();
        n = 31 * n + (this.fParent != null ? this.fParent.hashCode() : 0);
        return n;
    }

    public static enum NodeType {
        INTERNAL_ROOT,
        FILE_NODE,
        VALUE_NODE;

    }
}

