/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.toolbar;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.WorkflowAdvisor;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepModelListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;
import javax.swing.JComponent;

public final class ProgressDisplay {
    private final MJPanel fComponent;
    private final WorkflowAdvisor fAdvisor;
    private final StepModel fModel;
    private int fStepCount;
    private static final int SPACING = 3;
    private static final int DIAMETER = 6;

    public ProgressDisplay(WorkflowAdvisor workflowAdvisor) {
        this.fModel = workflowAdvisor.getModel();
        this.fAdvisor = workflowAdvisor;
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(ProgressDisplay.this.fStepCount * 6 + 15 + 8, 10);
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.WHITE);
                int n = 1;
                for (Step step : ProgressDisplay.this.fModel.getSteps()) {
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, 2.0, 6.0, 6.0, 6.0, 6.0);
                    if (ProgressDisplay.this.fModel.getCurrentStep() == step) {
                        graphics2D.fill(double_);
                    }
                    graphics2D.draw(double_);
                    n += 9;
                }
                graphics2D.dispose();
            }
        };
        this.fComponent.setOpaque(false);
        this.fModel.addStepModelListener(new StepModelListener(){

            @Override
            public void stepSelected(Step step, boolean bl) {
                ProgressDisplay.this.fComponent.repaint();
                ProgressDisplay.this.updateTooltip();
            }

            @Override
            public void stepCompletionChanged(Step step, boolean bl) {
                ProgressDisplay.this.fComponent.repaint();
                ProgressDisplay.this.updateTooltip();
            }

            @Override
            public void stepsChanged() {
                ProgressDisplay.this.updateSteps();
            }
        });
        this.updateSteps();
    }

    private void updateSteps() {
        this.fStepCount = this.fAdvisor.getModel().getSteps().size();
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.updateTooltip();
    }

    private void updateTooltip() {
        int n = 0;
        boolean bl = false;
        for (Step step : this.fModel.getSteps()) {
            ++n;
            if (step != this.fModel.getCurrentStep()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.fComponent.setToolTipText(MessageFormat.format(CoderResources.getString("wfa.progress.tooltip"), n, this.fStepCount));
        } else {
            this.fComponent.setToolTipText(null);
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }
}

