/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.toolbar;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class SaveButton
extends MJButton
implements ToolbarButton {
    private final CoderApp fApp;

    public SaveButton(CoderApp coderApp) {
        this.fApp = coderApp;
        this.setName("wfa.button.save");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveButton.this.doSave();
            }
        });
        coderApp.getEditManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SaveButton.this.updateEnabledState();
            }
        });
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SaveButton.this.setEnabled(SaveButton.this.fApp.getEditManager().hasDirtyFiles());
                if (SaveButton.this.isEnabled()) {
                    SaveButton.this.setToolTipText(CoderResources.getString("wfa.save.tooltip.enabled"));
                } else {
                    SaveButton.this.setToolTipText(CoderResources.getString("wfa.save.tooltip.disabled"));
                }
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        ToolbarUtils.paint(this, graphics);
    }

    @Override
    public void paintContent(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.5f));
        double d = 4.0;
        double d2 = this.getWidth();
        graphics2D.draw(new Line2D.Double(d, d, d2 - d - 1.0, d));
        double d3 = this.getHeight();
        double d4 = d3 - d - 1.0;
        graphics2D.draw(new Line2D.Double(d2 - d - 1.0, d, d2 - d - 1.0, d4));
        graphics2D.draw(new Line2D.Double(d2 - d - 1.0, d4, d * 1.75, d4));
        graphics2D.draw(new Line2D.Double(d * 1.75 - 1.0, d4, d, d3 - d * 1.75));
        graphics2D.draw(new Line2D.Double(d, d3 - d * 1.75 - 1.0, d, d));
        graphics2D.setStroke(new BasicStroke(1.2f));
        graphics2D.draw(new Line2D.Double(d * 1.75, d, d * 1.75, d3 / 2.0 - 2.0));
        double d5 = d3 / 2.0 - 1.0;
        graphics2D.draw(new Line2D.Double(d * 1.75, d5, d2 - d * 1.75 - 1.0, d5));
        graphics2D.draw(new Line2D.Double(d2 - d * 1.75 - 1.0, d5, d2 - d * 1.75 - 1.0, d));
        double d6 = d3 / 2.0 + 2.0;
        graphics2D.draw(new Line2D.Double(d * 2.0, d4, d * 2.0, d6));
        double d7 = d2 - d * 2.0;
        graphics2D.draw(new Line2D.Double(d * 2.0, d6, d7 - 1.0, d6));
        graphics2D.draw(new Line2D.Double(d7 - 1.0, d6, d7 - 1.0, d4));
        graphics2D.draw(new Line2D.Double(d7 - 2.0, d6, d7 - 2.0, d4));
        graphics2D.draw(new Line2D.Double(d7 - 3.0, d6, d7 - 3.0, d4));
    }

    public Dimension getPreferredSize() {
        return new Dimension(28, 28);
    }

    private void doSave() {
        this.fApp.getEditManager().saveAll();
    }
}

