/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.toolbar;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.wfa.WorkflowAdvisor;
import com.mathworks.toolbox.coder.wfa.core.DropDownButton;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.toolbar.HelpButton;
import com.mathworks.toolbox.coder.wfa.toolbar.OverviewButton;
import com.mathworks.toolbox.coder.wfa.toolbar.Separator;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class WorkflowToolbar {
    private final MJPanel fComponent;
    private final CoderApp fApp;
    private final OverviewButton fOverviewButton;
    private final ItemListener fToggleButtonListener;
    private final MJButton fHelpButton;
    private final Set<JToggleButton> fViewButtons;
    private final WorkflowAdvisor fAdvisor;
    private final BufferedImage fBuffer;
    private int fStepComponentCount;
    public static final Color BACKGROUND_DARK = new Color(0, 35, 61);
    public static final Color BACKGROUND = new Color(61, 103, 141);
    public static final Color HOVER_BACKGROUND = new Color(0, 24, 141);
    private static final int SPACING = 6;
    private static final int STEP_COMPONENT_INDEX = 1;

    public WorkflowToolbar(CoderApp coderApp, WorkflowAdvisor workflowAdvisor) {
        this.fAdvisor = workflowAdvisor;
        this.fApp = coderApp;
        this.fBuffer = new BufferedImage(1, 1, 2);
        this.fViewButtons = new HashSet<JToggleButton>();
        this.fComponent = new MJPanel(){

            protected void addImpl(Component component, Object object, int n) {
                if (component instanceof ToolbarButton) {
                    ToolbarUtils.configure((ToolbarButton)((Object)component));
                }
                super.addImpl(component, object, n);
            }

            public void requestFocus() {
                WorkflowToolbar.this.fOverviewButton.requestFocus();
            }

            public void doLayout() {
                super.doLayout();
                int n = this.getWidth() - 6;
                List<Component> list = Arrays.asList(this.getComponents());
                Collections.reverse(list);
                for (Component component : list) {
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(n - dimension.width, this.getHeight() / 2 - dimension.height / 2, dimension.width, dimension.height);
                    n -= dimension.width + 6;
                }
                Dimension dimension = WorkflowToolbar.this.fOverviewButton.getPreferredSize();
                WorkflowToolbar.this.fOverviewButton.setBounds(3, this.getHeight() / 2 - dimension.height / 2, dimension.width, dimension.height);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension();
                dimension.width = 12;
                dimension.width += WorkflowToolbar.this.getWidestStepNameWidth(WorkflowToolbar.this.fAdvisor.getModel().getAllPossibleSteps());
                for (Component component : this.getComponents()) {
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.height = Math.max(dimension2.height, dimension.height);
                    dimension.width += dimension2.width + 6;
                }
                dimension.width += 6;
                dimension.height = Math.max(dimension.height + 8, 38);
                return dimension;
            }

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0, 35, 61), this.getWidth(), 0.0f, new Color(31, 90, 150)));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (Component component : this.getComponents()) {
                    if (component == WorkflowToolbar.this.fOverviewButton || !(component instanceof JToggleButton) || !((JToggleButton)component).isSelected()) continue;
                    int n = WorkflowToolbar.this.getArrowAnchorX(component);
                    graphics2D.setColor(UIManager.getColor("control"));
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.append(new Line2D.Double(n - 6, this.getHeight(), n, component.getY() + component.getHeight() + 2), true);
                    generalPath.append(new Line2D.Double(n, component.getY() + component.getHeight() + 2, n + 6, this.getHeight()), true);
                    generalPath.append(new Line2D.Double(n + 6, this.getHeight(), n - 6, this.getHeight()), true);
                    graphics2D.fill(generalPath);
                }
                graphics2D.dispose();
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.setBackground(BACKGROUND);
        this.fOverviewButton = new OverviewButton(workflowAdvisor);
        this.fHelpButton = new HelpButton();
        this.fHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowToolbar.this.fAdvisor.getSelectedView().showHelp();
            }
        });
        this.fComponent.add((Component)((Object)this.fOverviewButton));
        this.fComponent.add((Component)((Object)new Separator()));
        this.fComponent.add((Component)this.fHelpButton);
        this.fComponent.setBorder(new Border(){

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(new Color(150, 150, 150));
                graphics.drawLine(0, component.getHeight() - 1, component.getWidth(), component.getHeight() - 1);
                for (Component component2 : WorkflowToolbar.this.fComponent.getComponents()) {
                    if (component2 == WorkflowToolbar.this.fOverviewButton || !(component2 instanceof JToggleButton) || !((JToggleButton)component2).isSelected()) continue;
                    int n5 = WorkflowToolbar.this.getArrowAnchorX(component2);
                    graphics.setColor(UIManager.getColor("control"));
                    graphics.drawLine(n5 - 6, component.getHeight() - 1, n5 + 6, component.getHeight() - 1);
                }
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 1, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
        this.fToggleButtonListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                WorkflowToolbar.this.fComponent.revalidate();
                WorkflowToolbar.this.fComponent.repaint();
            }
        };
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "generic-artifact") {
                    WorkflowToolbar.this.fComponent.revalidate();
                    WorkflowToolbar.this.fComponent.repaint();
                }
            }
        });
    }

    public OverviewButton getOverviewButton() {
        return this.fOverviewButton;
    }

    public void setStepComponents(List<? extends Component> list) {
        while (this.fStepComponentCount > 0) {
            if (this.fComponent.getComponent(1) instanceof JToggleButton) {
                ((JToggleButton)this.fComponent.getComponent(1)).removeItemListener(this.fToggleButtonListener);
            }
            this.fComponent.remove(1);
            --this.fStepComponentCount;
        }
        this.fStepComponentCount = list.size();
        for (int i = 0; i < list.size(); ++i) {
            this.fComponent.add(list.get(i), 1 + i);
            if (!(list.get(i) instanceof JToggleButton)) continue;
            ((JToggleButton)list.get(i)).addItemListener(this.fToggleButtonListener);
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void setHeadlineText(String string) {
        this.fOverviewButton.setText(string);
    }

    private int getArrowAnchorX(Component component) {
        if (component instanceof DropDownButton) {
            return component.getX() + component.getWidth() - 9;
        }
        return component.getX() + component.getWidth() / 2;
    }

    private int getWidestStepNameWidth(List<Step> list) {
        Graphics2D graphics2D = this.fBuffer.createGraphics();
        graphics2D.setFont(this.fOverviewButton.getFont());
        double d = 0.0;
        for (Step step : list) {
            d = Math.max(d, graphics2D.getFontMetrics().getStringBounds(step.getName(this.fApp.getModel()), graphics2D).getWidth());
        }
        return (int)Math.ceil(d);
    }

    public void showOverview() {
        this.fOverviewButton.setSelected(true);
    }

    public void hideOverview() {
        this.fOverviewButton.setSelected(false);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public ToolbarContext getContext(final Step step) {
        return new ToolbarContext(){

            @Override
            public void setStepComponents(List<? extends Component> list) {
                if (WorkflowToolbar.this.fAdvisor.getSelectedStep() == step) {
                    WorkflowToolbar.this.setStepComponents(list);
                }
            }
        };
    }

    private void registerViewButton(final JToggleButton jToggleButton) {
        if (this.fViewButtons.add(jToggleButton)) {
            jToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (jToggleButton.isSelected()) {
                        for (JToggleButton jToggleButton2 : WorkflowToolbar.this.fViewButtons) {
                            if (jToggleButton2 == jToggleButton) continue;
                            jToggleButton2.setSelected(false);
                        }
                    }
                }
            });
        }
    }
}

