/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.verification;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.wfa.verification.HDLCosimulationSettingsPanel;
import com.mathworks.toolbox.coder.wfa.verification.HDLFilSettingsPanel;
import com.mathworks.toolbox.coder.wfa.verification.HDLTestBenchSettingsPanel;
import com.mathworks.toolbox.coder.wfa.verification.TestOptionPanel;
import com.mathworks.toolbox.coder.wfa.verification.TestOutputArea;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class HDLTestOptionPanel
extends TestOptionPanel {
    private final MJRadioButton fTestBenchOption = new MJRadioButton(CoderResources.getString("wfa.test.hdlTestBench"));
    private final MJRadioButton fCosimulationOption = new MJRadioButton(CoderResources.getString("wfa.test.cosimulation"));
    private final MJRadioButton fFilOption = new MJRadioButton(CoderResources.getString("wfa.test.fil"));
    private final HyperlinkTextLabel fMoreSettingsLink;
    private final MJPanel fMoreSettings;
    private final HDLTestBenchSettingsPanel fTestBenchSettingsPanel;
    private final HDLCosimulationSettingsPanel fCosimulationSettingsPanel;
    private final HDLFilSettingsPanel fFilSettingsPanel;
    private MJPanel fBasicSettings;
    private boolean fShowMoreSettings;

    public HDLTestOptionPanel(final CoderApp coderApp, MJToggleButton mJToggleButton, TestOutputArea testOutputArea) {
        super(coderApp, mJToggleButton, testOutputArea);
        this.fTestBenchOption.setOpaque(false);
        this.fCosimulationOption.setOpaque(false);
        this.fFilOption.setOpaque(false);
        this.fMoreSettings = new MJPanel();
        this.fMoreSettings.setOpaque(false);
        this.fMoreSettings.setBorder(new Border(){

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(new Color(215, 215, 215));
                graphics.drawLine(0, 3, n3, 3);
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(6, 0, 0, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
        this.fTestBenchSettingsPanel = new HDLTestBenchSettingsPanel(coderApp);
        this.fCosimulationSettingsPanel = new HDLCosimulationSettingsPanel(coderApp);
        this.fFilSettingsPanel = new HDLFilSettingsPanel(coderApp);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fTestBenchOption);
        buttonGroup.add((AbstractButton)this.fCosimulationOption);
        buttonGroup.add((AbstractButton)this.fFilOption);
        this.fTestBenchOption.setSelected(true);
        this.fMoreSettingsLink = Utilities.createLink("", "wfa.test.hdl.moreSettings", new Runnable(){

            @Override
            public void run() {
                HDLTestOptionPanel.this.fShowMoreSettings = !HDLTestOptionPanel.this.fShowMoreSettings;
                HDLTestOptionPanel.this.fMoreSettingsLink.setEnabled(false);
                coderApp.getIDEView().getCodeInfoView().setPopupBarStretched(HDLTestOptionPanel.this.fShowMoreSettings, new Runnable(){

                    @Override
                    public void run() {
                        HDLTestOptionPanel.this.fMoreSettingsLink.setEnabled(true);
                        if (HDLTestOptionPanel.this.fShowMoreSettings) {
                            HDLTestOptionPanel.this.addMoreSettingsPanel();
                        } else {
                            HDLTestOptionPanel.this.removeMoreSettingsPanel();
                        }
                    }
                });
                HDLTestOptionPanel.this.updateMoreSettingsText();
            }
        });
        this.updateMoreSettingsText();
        this.bindSettingsPanel((JToggleButton)this.fTestBenchOption, this.fTestBenchSettingsPanel.getComponent());
        this.bindSettingsPanel((JToggleButton)this.fCosimulationOption, this.fCosimulationSettingsPanel.getComponent());
        this.bindSettingsPanel((JToggleButton)this.fFilOption, this.fFilSettingsPanel.getComponent());
    }

    @Override
    public void close() {
        super.close();
        this.fShowMoreSettings = false;
        this.updateMoreSettingsText();
        this.removeMoreSettingsPanel();
    }

    private void addMoreSettingsPanel() {
        this.getContentPane().add((Component)this.fMoreSettings, (Object)"Center");
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    private void removeMoreSettingsPanel() {
        this.getContentPane().remove((Component)this.fMoreSettings);
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    private void updateMoreSettingsText() {
        this.fMoreSettingsLink.setText(CoderResources.getString("wfa.test.hdl." + (this.fShowMoreSettings ? "less" : "more") + "Settings"));
    }

    @Override
    protected void layoutComponent(JComponent jComponent, JComponent jComponent2) {
        this.fBasicSettings = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu, fill:d, 3dlu", "3dlu, center:d, 3dlu, fill:d, 3dlu, fill:d, 3dlu, fill:d, 3dlu, fill:d, 3dlu, 0:grow"));
        this.fBasicSettings.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        this.fBasicSettings.add((Component)this.getCommandWindow().getComponent(), (Object)cellConstraints.xy(2, 2));
        this.fBasicSettings.add((Component)this.fTestBenchOption, (Object)cellConstraints.xy(2, 4));
        this.fBasicSettings.add((Component)this.fCosimulationOption, (Object)cellConstraints.xy(2, 6));
        this.fBasicSettings.add((Component)this.fFilOption, (Object)cellConstraints.xy(2, 8));
        this.fBasicSettings.add((Component)this.fMoreSettingsLink.getComponent(), (Object)cellConstraints.xy(2, 10));
        this.fBasicSettings.add((Component)jComponent2, (Object)cellConstraints.xy(4, 2));
        this.getContentPane().setLayout((LayoutManager)new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.fBasicSettings, (Object)"North");
        jComponent.setLayout(new BorderLayout(0, 0));
        jComponent.add((Component)this.getContentPane());
    }

    @Override
    protected void updateOptions() {
    }

    @Override
    protected TestOutputArea.Mode getMode() {
        return TestOutputArea.Mode.GENERATED_OUTPUT;
    }

    private void bindSettingsPanel(final JToggleButton jToggleButton, final Component component) {
        jToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jToggleButton.isSelected()) {
                    HDLTestOptionPanel.this.switchSettingsPanel(component);
                }
            }
        });
        if (jToggleButton.isSelected()) {
            this.switchSettingsPanel(component);
        }
    }

    private void switchSettingsPanel(Component component) {
        this.fMoreSettings.removeAll();
        this.fMoreSettings.add(component);
        this.fMoreSettings.revalidate();
        this.fMoreSettings.repaint();
    }
}

