/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.DefaultPropertyTablePainter;
import com.mathworks.project.impl.table.MacPropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.project.impl.table.VirtualComponent;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.coder.widgets.FauxColumnDataAdapter;
import com.mathworks.toolbox.coder.widgets.FauxColumnFieldRenderer;
import com.mathworks.toolbox.coder.widgets.FauxColumnLayout;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class FauxColumnGroupDecorator<T>
implements PropertyTableDecorator<T> {
    private static final String FILLER_STRING = "...";
    private static final Color HEADER_GRID_LINE_COLOR = PlatformInfo.isMacintosh() ? new Color(237, 243, 254) : ColorPrefs.getBackgroundColor();
    private static final Color GRID_LINE_COLOR = PlatformInfo.isMacintosh() ? null : new Color(240, 240, 240);
    private final FauxColumnDataAdapter<T> fDataAdapter;
    private final FauxColumnFieldRenderer<T> fRenderer;
    private final FauxColumnLayout fFauxColumnLayout;
    private final Collection<Predicate<CellPaintContext<T>>> fDecorationPredicates;
    private final Collection<Predicate<T>> fValuePredicates;
    private FauxCoordinates fLastHovered;

    public FauxColumnGroupDecorator(FauxColumnDataAdapter<T> fauxColumnDataAdapter, FauxColumnLayout fauxColumnLayout) {
        this.fDataAdapter = fauxColumnDataAdapter;
        this.fRenderer = new DefaultFauxColumnFieldRenderer();
        this.fFauxColumnLayout = fauxColumnLayout;
        this.fDecorationPredicates = new LinkedList<Predicate<CellPaintContext<T>>>();
        this.fValuePredicates = new LinkedList<Predicate<T>>();
    }

    public FauxColumnGroupDecorator(FauxColumnDataAdapter<T> fauxColumnDataAdapter) {
        this(fauxColumnDataAdapter, new FauxColumnLayout.EvenLayout());
    }

    public FauxColumnLayout getFauxColumnLayout() {
        return this.fFauxColumnLayout;
    }

    public void addDecorationEnabledPredicate(Predicate<CellPaintContext<T>> predicate) {
        this.fDecorationPredicates.add(predicate);
    }

    public void addDecorationTextPredicate(Predicate<T> predicate) {
        this.fValuePredicates.add(predicate);
    }

    private boolean shouldDecorateCell(CellPaintContext<T> cellPaintContext) {
        for (Predicate<CellPaintContext<T>> predicate : this.fDecorationPredicates) {
            if (predicate.accept(cellPaintContext)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldDeferTextRendering(T t) {
        for (Predicate<T> predicate : this.fValuePredicates) {
            if (predicate.accept(t)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldPaintText(T t) {
        return this.shouldDeferTextRendering(t);
    }

    public void paintDecoration(CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
        if (!this.shouldDecorateCell(cellPaintContext) || this.shouldDeferTextRendering(cellPaintContext.getValue())) {
            return;
        }
        if (cellPaintContext.isDisabled()) {
            color2 = new Color(195, 195, 195);
        } else if (cellPaintContext.isSelected()) {
            color2 = ColorUtils.getSelectionForegroundColor();
        }
        if (cellPaintContext.isLeaf()) {
            this.paintLeafDecorations(cellPaintContext, graphics2D, virtualComponentManager, color, color2);
        } else {
            this.paintHeaderDecorations(cellPaintContext, graphics2D, virtualComponentManager, color, color2);
        }
    }

    FauxCoordinates getLastHovered() {
        return this.fLastHovered;
    }

    private void paintHeaderDecorations(CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, final Color color, Color color2) {
        final Color color3 = ColorUtils.getContrastingForegroundVariant((Color)ColorPrefs.getBackgroundColor(), (Color)new Color(143, 158, 177));
        FauxColumnFieldRenderer.PaintSettings paintSettings = new FauxColumnFieldRenderer.PaintSettings(){

            @Override
            public boolean paintGridlines() {
                return true;
            }

            @Override
            public Color getGridlineColor() {
                return HEADER_GRID_LINE_COLOR;
            }

            @Override
            public Color getTextColor() {
                return color3;
            }

            @Override
            public int getFontStyle() {
                return 2;
            }

            @Override
            public Color getBackgroundColor() {
                return color;
            }
        };
        List<Object> list = Arrays.asList(this.fDataAdapter.getFauxFieldsForRow(cellPaintContext.getRowIndex()).toArray());
        this.paintFauxCell(list, true, paintSettings, cellPaintContext, graphics2D, virtualComponentManager);
    }

    private void paintLeafDecorations(CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, final Color color, final Color color2) {
        FauxColumnFieldRenderer.PaintSettings paintSettings = new FauxColumnFieldRenderer.PaintSettings(){

            @Override
            public boolean paintGridlines() {
                return GRID_LINE_COLOR != null;
            }

            @Override
            public Color getGridlineColor() {
                return GRID_LINE_COLOR;
            }

            @Override
            public Color getTextColor() {
                return color2;
            }

            @Override
            public int getFontStyle() {
                return 0;
            }

            @Override
            public Color getBackgroundColor() {
                return color;
            }
        };
        this.paintFauxCell(this.fDataAdapter.getDisplayObjects(cellPaintContext.getRowIndex(), cellPaintContext.getValue()), false, paintSettings, cellPaintContext, graphics2D, virtualComponentManager);
    }

    private void paintFauxCell(List<Object> list, boolean bl, FauxColumnFieldRenderer.PaintSettings paintSettings, CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager) {
        List<Rectangle2D> list2 = this.fFauxColumnLayout.layoutFauxCells(list.size(), cellPaintContext.getCellRect());
        List<VirtualComponent> list3 = this.getFauxVirtualComponents(virtualComponentManager, cellPaintContext, list2);
        this.fRenderer.renderFauxCell(list, list2, bl, graphics2D, cellPaintContext, paintSettings);
    }

    private List<? extends VirtualComponent> getFauxVirtualComponents(VirtualComponentManager virtualComponentManager, CellPaintContext<?> cellPaintContext, List<Rectangle2D> list) {
        ArrayList<FauxVirtualComponent> arrayList = new ArrayList<FauxVirtualComponent>();
        for (VirtualComponent virtualComponent : virtualComponentManager.getComponents(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex())) {
            if (!(virtualComponent instanceof FauxVirtualComponent)) continue;
            arrayList.add((FauxVirtualComponent)virtualComponent);
        }
        if (arrayList.size() != list.size()) {
            if (!arrayList.isEmpty()) {
                this.fLastHovered = null;
            }
            arrayList.clear();
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                FauxVirtualComponent fauxVirtualComponent = new FauxVirtualComponent(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), i, list.get(i));
                arrayList.add(fauxVirtualComponent);
                arrayList2.add(fauxVirtualComponent);
            }
            virtualComponentManager.defineCellComponents(cellPaintContext.getRowIndex(), cellPaintContext.getColumnIndex(), (List)arrayList2);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((FauxVirtualComponent)((Object)arrayList.get(i))).setShape(list.get(i));
            }
        }
        return arrayList;
    }

    private static void drawString(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, int n, boolean bl) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
        int n2 = n - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n3 = (int)(rectangle2D.getY() + (double)fontMetrics.getAscent() + (double)n2 / 2.0);
        graphics2D.drawString(string, bl ? (int)(rectangle2D.getX() + (rectangle2D.getWidth() - rectangle2D2.getWidth()) / 2.0) : (int)rectangle2D.getX() + 4, n3);
    }

    private static String trimToLength(String string, int n, FontMetrics fontMetrics) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n + 1;
        String string2 = string;
        while (n2 < n3) {
            int n5 = (n3 + n2) / 2;
            string2 = string.substring(0, n5 + 1) + (n5 + 1 < string.length() ? FILLER_STRING : "");
            n4 = fontMetrics.stringWidth(string2);
            if (n4 < n) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > n) {
                n3 = n5;
                continue;
            }
            return string2;
        }
        return n4 < n ? string2 : "";
    }

    static <T> PropertyTablePainter<T> createPlatformPropertyTablePainter() {
        return PlatformInfo.isMacintosh() ? new MacPropertyTablePainter() : new DefaultPropertyTablePainter();
    }

    static final class FauxCoordinates {
        private final int fRowIndex;
        private final int fColIndex;
        private final int fFauxIndex;

        FauxCoordinates(int n, int n2, int n3) {
            this.fRowIndex = n;
            this.fColIndex = n2;
            this.fFauxIndex = n3;
        }

        int getRowIndex() {
            return this.fRowIndex;
        }

        int getColIndex() {
            return this.fColIndex;
        }

        int getFauxIndex() {
            return this.fFauxIndex;
        }
    }

    private static class DefaultFauxColumnFieldRenderer<T>
    implements FauxColumnFieldRenderer<T> {
        private static final PropertyTablePainter<?> PAINTER = FauxColumnGroupDecorator.createPlatformPropertyTablePainter();

        private DefaultFauxColumnFieldRenderer() {
        }

        @Override
        public void renderFauxCell(List<Object> list, List<Rectangle2D> list2, boolean bl, Graphics2D graphics2D, CellPaintContext<T> cellPaintContext, FauxColumnFieldRenderer.PaintSettings paintSettings) {
            if (list == null || list.isEmpty()) {
                return;
            }
            Color color = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(cellPaintContext, (Color)paintSettings.getTextColor());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(graphics2D.getFont().deriveFont(paintSettings.getFontStyle()));
            for (int i = 0; i < list2.size(); ++i) {
                Rectangle2D rectangle2D = list2.get(i);
                if (paintSettings.paintGridlines() && i > 0) {
                    graphics2D.setColor(paintSettings.getGridlineColor());
                    graphics2D.fill(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), PAINTER.getGridLineWidth(), rectangle2D.getHeight()));
                }
                graphics2D.setColor(color);
                String string = i < list.size() && list.get(i) != null ? list.get(i) : "";
                String string2 = FauxColumnGroupDecorator.trimToLength(string.toString(), (int)rectangle2D.getWidth(), graphics2D.getFontMetrics());
                FauxColumnGroupDecorator.drawString(graphics2D, string2, rectangle2D, cellPaintContext.getLineHeight(), !bl);
            }
        }
    }

    private class FauxVirtualComponent
    extends VirtualComponent {
        private final FauxCoordinates fFauxCoordinates;
        private Rectangle2D fFauxRect;

        private FauxVirtualComponent(int n, int n2, int n3, Rectangle2D rectangle2D) {
            super(n, n2, (Shape)rectangle2D);
            this.setShape(rectangle2D);
            this.fFauxCoordinates = new FauxCoordinates(n, n2, n3);
        }

        void setShape(Rectangle2D rectangle2D) {
            this.fFauxRect = rectangle2D;
        }

        public Shape getShape() {
            return this.fFauxRect;
        }

        public void setHovered(boolean bl) {
            super.setHovered(bl);
            if (bl) {
                FauxColumnGroupDecorator.this.fLastHovered = this.fFauxCoordinates;
            }
        }
    }
}

