/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.AFPStreamer;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.AbstractPageObject;
import org.apache.fop.afp.modca.IncludeObject;
import org.apache.fop.afp.modca.IncludedResourceObject;
import org.apache.fop.afp.modca.PageSegment;
import org.apache.fop.afp.modca.Registry;
import org.apache.fop.afp.modca.ResourceGroup;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.fop.afp.util.AFPResourceUtil;
import org.apache.fop.afp.util.ResourceAccessor;

public class AFPResourceManager {
    private static Log log = LogFactory.getLog(AFPResourceManager.class);
    private DataStream dataStream;
    private final Factory factory;
    private final AFPStreamer streamer;
    private final AFPDataObjectFactory dataObjectFactory;
    private int instreamObjectCount = 0;
    private final Map<AFPResourceInfo, String> includeNameMap = new HashMap<AFPResourceInfo, String>();
    private Map<AFPResourceInfo, String> pageSegmentMap = new HashMap<AFPResourceInfo, String>();
    private AFPResourceLevelDefaults resourceLevelDefaults = new AFPResourceLevelDefaults();

    public AFPResourceManager() {
        this.factory = new Factory();
        this.streamer = new AFPStreamer(this.factory);
        this.dataObjectFactory = new AFPDataObjectFactory(this.factory);
    }

    public DataStream createDataStream(AFPPaintingState aFPPaintingState, OutputStream outputStream) throws IOException {
        this.dataStream = this.streamer.createDataStream(aFPPaintingState);
        this.streamer.setOutputStream(outputStream);
        return this.dataStream;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void writeToStream() throws IOException {
        this.streamer.close();
    }

    public void setDefaultResourceGroupFilePath(String string) {
        this.streamer.setDefaultResourceGroupFilePath(string);
    }

    public boolean tryIncludeObject(AFPDataObjectInfo aFPDataObjectInfo) throws IOException {
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        this.updateResourceInfoUri(aFPResourceInfo);
        String string = this.includeNameMap.get(aFPResourceInfo);
        if (string != null) {
            this.includeObject(aFPDataObjectInfo, string);
            return true;
        }
        string = this.pageSegmentMap.get(aFPResourceInfo);
        if (string != null) {
            this.includePageSegment(aFPDataObjectInfo, string);
            return true;
        }
        return false;
    }

    public void createObject(AFPDataObjectInfo aFPDataObjectInfo) throws IOException {
        Object object;
        if (this.tryIncludeObject(aFPDataObjectInfo)) {
            return;
        }
        AbstractNamedAFPObject abstractNamedAFPObject = null;
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        boolean bl = true;
        Registry.ObjectType objectType = null;
        if (aFPDataObjectInfo instanceof AFPImageObjectInfo) {
            object = (AFPImageObjectInfo)aFPDataObjectInfo;
            abstractNamedAFPObject = this.dataObjectFactory.createImage((AFPImageObjectInfo)object);
        } else if (aFPDataObjectInfo instanceof AFPGraphicsObjectInfo) {
            object = (AFPGraphicsObjectInfo)aFPDataObjectInfo;
            abstractNamedAFPObject = this.dataObjectFactory.createGraphic((AFPGraphicsObjectInfo)object);
        } else {
            abstractNamedAFPObject = this.dataObjectFactory.createObjectContainer(aFPDataObjectInfo);
            objectType = aFPDataObjectInfo.getObjectType();
            bl = objectType != null && objectType.isIncludable();
        }
        object = aFPResourceInfo.getLevel();
        ResourceGroup resourceGroup = this.streamer.getResourceGroup((AFPResourceLevel)object);
        if (bl &= resourceGroup != null) {
            String string;
            boolean bl2 = aFPDataObjectInfo.isCreatePageSegment();
            if (((AFPResourceLevel)object).isPrintFile() || ((AFPResourceLevel)object).isExternal()) {
                if (bl2) {
                    string = "S10" + abstractNamedAFPObject.getName().substring(3);
                    abstractNamedAFPObject.setName(string);
                    PageSegment pageSegment = new PageSegment(string);
                    pageSegment.addObject(abstractNamedAFPObject);
                    abstractNamedAFPObject = pageSegment;
                }
                abstractNamedAFPObject = this.dataObjectFactory.createResource(abstractNamedAFPObject, aFPResourceInfo, objectType);
            }
            resourceGroup.addObject(abstractNamedAFPObject);
            string = abstractNamedAFPObject.getName();
            if (bl2) {
                this.includePageSegment(aFPDataObjectInfo, string);
                this.pageSegmentMap.put(aFPResourceInfo, string);
            } else {
                this.includeObject(aFPDataObjectInfo, string);
                this.includeNameMap.put(aFPResourceInfo, string);
            }
        } else {
            this.dataStream.getCurrentPage().addObject(abstractNamedAFPObject);
        }
    }

    private void updateResourceInfoUri(AFPResourceInfo aFPResourceInfo) {
        String string = aFPResourceInfo.getUri();
        if (string == null) {
            string = "/";
        }
        if (string.endsWith("/")) {
            string = string + "#" + ++this.instreamObjectCount;
            aFPResourceInfo.setUri(string);
        }
    }

    private void includeObject(AFPDataObjectInfo aFPDataObjectInfo, String string) {
        IncludeObject includeObject = this.dataObjectFactory.createInclude(string, aFPDataObjectInfo);
        this.dataStream.getCurrentPage().addObject(includeObject);
    }

    public void embedFont(AFPFont aFPFont, CharacterSet characterSet) throws IOException {
        if (aFPFont.isEmbeddable() && characterSet.getResourceAccessor() != null) {
            ResourceAccessor resourceAccessor = characterSet.getResourceAccessor();
            this.createIncludedResource(characterSet.getName(), resourceAccessor, (byte)64);
            this.createIncludedResource(characterSet.getCodePage(), resourceAccessor, (byte)65);
        }
    }

    private void includePageSegment(AFPDataObjectInfo aFPDataObjectInfo, String string) {
        int n = aFPDataObjectInfo.getObjectAreaInfo().getX();
        int n2 = aFPDataObjectInfo.getObjectAreaInfo().getY();
        AbstractPageObject abstractPageObject = this.dataStream.getCurrentPage();
        boolean bl = true;
        abstractPageObject.createIncludePageSegment(string, n, n2, bl);
    }

    public void createIncludedResource(String string, ResourceAccessor resourceAccessor, byte by) throws IOException {
        URI uRI;
        try {
            uRI = new URI(string.trim());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Could not create URI from resource name: " + string + " (" + uRISyntaxException.getMessage() + ")");
        }
        this.createIncludedResource(string, uRI, resourceAccessor, by);
    }

    public void createIncludedResource(String string, URI uRI, ResourceAccessor resourceAccessor, byte by) throws IOException {
        AFPResourceLevel aFPResourceLevel = new AFPResourceLevel(4);
        AFPResourceInfo aFPResourceInfo = new AFPResourceInfo();
        aFPResourceInfo.setLevel(aFPResourceLevel);
        aFPResourceInfo.setName(string);
        aFPResourceInfo.setUri(uRI.toASCIIString());
        String string2 = this.includeNameMap.get(aFPResourceInfo);
        if (string2 == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding included resource: " + string));
            }
            IncludedResourceObject includedResourceObject = new IncludedResourceObject(string, resourceAccessor, uRI);
            ResourceObject resourceObject = this.factory.createResource(string);
            resourceObject.setDataObject(includedResourceObject);
            resourceObject.setType(by);
            ResourceGroup resourceGroup = this.streamer.getResourceGroup(aFPResourceLevel);
            resourceGroup.addObject(resourceObject);
            this.includeNameMap.put(aFPResourceInfo, string);
        }
    }

    public void createIncludedResourceFromExternal(final String string, final URI uRI, final ResourceAccessor resourceAccessor) throws IOException {
        AFPResourceLevel aFPResourceLevel = new AFPResourceLevel(4);
        AFPResourceInfo aFPResourceInfo = new AFPResourceInfo();
        aFPResourceInfo.setLevel(aFPResourceLevel);
        aFPResourceInfo.setName(string);
        aFPResourceInfo.setUri(uRI.toASCIIString());
        String string2 = this.includeNameMap.get(aFPResourceInfo);
        if (string2 == null) {
            ResourceGroup resourceGroup = this.streamer.getResourceGroup(aFPResourceLevel);
            AbstractNamedAFPObject abstractNamedAFPObject = new AbstractNamedAFPObject(null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void writeContent(OutputStream outputStream) throws IOException {
                    InputStream inputStream = null;
                    try {
                        inputStream = resourceAccessor.createInputStream(uRI);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        AFPResourceUtil.copyNamedResource(string, bufferedInputStream, outputStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }

                protected void writeStart(OutputStream outputStream) throws IOException {
                }

                protected void writeEnd(OutputStream outputStream) throws IOException {
                }
            };
            resourceGroup.addObject(abstractNamedAFPObject);
            this.includeNameMap.put(aFPResourceInfo, string);
        }
    }

    public void setResourceLevelDefaults(AFPResourceLevelDefaults aFPResourceLevelDefaults) {
        this.resourceLevelDefaults.mergeFrom(aFPResourceLevelDefaults);
    }

    public AFPResourceLevelDefaults getResourceLevelDefaults() {
        return this.resourceLevelDefaults;
    }
}

