/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.io.OutputStream;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.goca.GraphicsData;
import org.apache.fop.afp.ioca.ImageContent;
import org.apache.fop.afp.ioca.ImageRasterData;
import org.apache.fop.afp.ioca.ImageSegment;
import org.apache.fop.afp.ioca.ImageSizeParameter;
import org.apache.fop.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.afp.modca.ContainerDataDescriptor;
import org.apache.fop.afp.modca.Document;
import org.apache.fop.afp.modca.GraphicsDataDescriptor;
import org.apache.fop.afp.modca.GraphicsObject;
import org.apache.fop.afp.modca.IMImageObject;
import org.apache.fop.afp.modca.ImageDataDescriptor;
import org.apache.fop.afp.modca.ImageObject;
import org.apache.fop.afp.modca.IncludeObject;
import org.apache.fop.afp.modca.IncludePageSegment;
import org.apache.fop.afp.modca.InvokeMediumMap;
import org.apache.fop.afp.modca.MapCodedFont;
import org.apache.fop.afp.modca.MapContainerData;
import org.apache.fop.afp.modca.MapDataResource;
import org.apache.fop.afp.modca.ObjectAreaDescriptor;
import org.apache.fop.afp.modca.ObjectAreaPosition;
import org.apache.fop.afp.modca.ObjectContainer;
import org.apache.fop.afp.modca.ObjectEnvironmentGroup;
import org.apache.fop.afp.modca.Overlay;
import org.apache.fop.afp.modca.PageDescriptor;
import org.apache.fop.afp.modca.PageGroup;
import org.apache.fop.afp.modca.PageObject;
import org.apache.fop.afp.modca.PresentationEnvironmentControl;
import org.apache.fop.afp.modca.PresentationTextDescriptor;
import org.apache.fop.afp.modca.PresentationTextObject;
import org.apache.fop.afp.modca.ResourceEnvironmentGroup;
import org.apache.fop.afp.modca.ResourceGroup;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.fop.afp.modca.StreamedResourceGroup;
import org.apache.fop.afp.modca.TagLogicalElement;
import org.apache.fop.afp.util.StringUtils;

public class Factory {
    private static final String OBJECT_ENVIRONMENT_GROUP_NAME_PREFIX = "OEG";
    private static final String ACTIVE_ENVIRONMENT_GROUP_NAME_PREFIX = "AEG";
    private static final String IMAGE_NAME_PREFIX = "IMG";
    private static final String GRAPHIC_NAME_PREFIX = "GRA";
    private static final String BARCODE_NAME_PREFIX = "BAR";
    private static final String OBJECT_CONTAINER_NAME_PREFIX = "OC";
    private static final String RESOURCE_NAME_PREFIX = "RES";
    private static final String RESOURCE_GROUP_NAME_PREFIX = "RG";
    private static final String PAGE_GROUP_NAME_PREFIX = "PGP";
    private static final String PAGE_NAME_PREFIX = "PGN";
    private static final String OVERLAY_NAME_PREFIX = "OVL";
    private static final String PRESENTATION_TEXT_NAME_PREFIX = "PT";
    private static final String DOCUMENT_NAME_PREFIX = "DOC";
    private static final String IM_IMAGE_NAME_PREFIX = "IMIMG";
    private static final String IMAGE_SEGMENT_NAME_PREFIX = "IS";
    private int pageGroupCount = 0;
    private int pageCount = 0;
    private int imageCount = 0;
    private int imImageCount = 0;
    private int imageSegmentCount = 0;
    private int graphicCount = 0;
    private int objectContainerCount = 0;
    private int resourceCount = 0;
    private int resourceGroupCount = 0;
    private int overlayCount = 0;
    private int textObjectCount = 0;
    private int activeEnvironmentGroupCount = 0;
    private int documentCount = 0;
    private int objectEnvironmentGroupCount = 0;

    public ImageObject createImageObject() {
        String string = IMAGE_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.imageCount), '0', 5);
        ImageObject imageObject = new ImageObject(this, string);
        return imageObject;
    }

    public IMImageObject createIMImageObject() {
        String string = IM_IMAGE_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.imImageCount), '0', 3);
        IMImageObject iMImageObject = new IMImageObject(string);
        return iMImageObject;
    }

    public GraphicsObject createGraphicsObject() {
        String string = GRAPHIC_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.graphicCount), '0', 5);
        GraphicsObject graphicsObject = new GraphicsObject(this, string);
        return graphicsObject;
    }

    public ObjectContainer createObjectContainer() {
        String string = OBJECT_CONTAINER_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.objectContainerCount), '0', 6);
        return new ObjectContainer(this, string);
    }

    public ResourceObject createResource(String string) {
        return new ResourceObject(string);
    }

    public ResourceObject createResource() {
        String string = RESOURCE_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.resourceCount), '0', 5);
        return this.createResource(string);
    }

    public PageGroup createPageGroup(int n) {
        String string = PAGE_GROUP_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.pageGroupCount), '0', 5);
        return new PageGroup(this, string, n);
    }

    public ActiveEnvironmentGroup createActiveEnvironmentGroup(int n, int n2, int n3, int n4) {
        String string = ACTIVE_ENVIRONMENT_GROUP_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.activeEnvironmentGroupCount), '0', 5);
        return new ActiveEnvironmentGroup(this, string, n, n2, n3, n4);
    }

    public ResourceGroup createResourceGroup() {
        String string = RESOURCE_GROUP_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.resourceGroupCount), '0', 6);
        return new ResourceGroup(string);
    }

    public StreamedResourceGroup createStreamedResourceGroup(OutputStream outputStream) {
        String string = RESOURCE_GROUP_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.resourceGroupCount), '0', 6);
        return new StreamedResourceGroup(string, outputStream);
    }

    public PageObject createPage(int n, int n2, int n3, int n4, int n5) {
        String string = PAGE_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.pageCount), '0', 5);
        return new PageObject(this, string, n, n2, n3, n4, n5);
    }

    public PresentationTextObject createPresentationTextObject() {
        String string = PRESENTATION_TEXT_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.textObjectCount), '0', 6);
        return new PresentationTextObject(string);
    }

    public Overlay createOverlay(int n, int n2, int n3, int n4, int n5) {
        String string = OVERLAY_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.overlayCount), '0', 5);
        Overlay overlay = new Overlay(this, string, n, n2, n5, n3, n4);
        return overlay;
    }

    public Document createDocument() {
        String string = DOCUMENT_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.documentCount), '0', 5);
        Document document = new Document(this, string);
        return document;
    }

    public MapCodedFont createMapCodedFont() {
        MapCodedFont mapCodedFont = new MapCodedFont();
        return mapCodedFont;
    }

    public IncludePageSegment createIncludePageSegment(String string, int n, int n2) {
        IncludePageSegment includePageSegment = new IncludePageSegment(string, n, n2);
        return includePageSegment;
    }

    public IncludeObject createInclude(String string) {
        IncludeObject includeObject = new IncludeObject(string);
        return includeObject;
    }

    public TagLogicalElement createTagLogicalElement(String string, String string2, int n) {
        TagLogicalElement tagLogicalElement = new TagLogicalElement(string, string2, n);
        return tagLogicalElement;
    }

    public DataStream createDataStream(AFPPaintingState aFPPaintingState, OutputStream outputStream) {
        DataStream dataStream = new DataStream(this, aFPPaintingState, outputStream);
        return dataStream;
    }

    public PageDescriptor createPageDescriptor(int n, int n2, int n3, int n4) {
        PageDescriptor pageDescriptor = new PageDescriptor(n, n2, n3, n4);
        return pageDescriptor;
    }

    public ObjectEnvironmentGroup createObjectEnvironmentGroup() {
        String string = OBJECT_ENVIRONMENT_GROUP_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.objectEnvironmentGroupCount), '0', 5);
        ObjectEnvironmentGroup objectEnvironmentGroup = new ObjectEnvironmentGroup(string);
        return objectEnvironmentGroup;
    }

    public GraphicsData createGraphicsData() {
        GraphicsData graphicsData = new GraphicsData();
        return graphicsData;
    }

    public ObjectAreaDescriptor createObjectAreaDescriptor(int n, int n2, int n3, int n4) {
        ObjectAreaDescriptor objectAreaDescriptor = new ObjectAreaDescriptor(n, n2, n3, n4);
        return objectAreaDescriptor;
    }

    public ObjectAreaPosition createObjectAreaPosition(int n, int n2, int n3) {
        ObjectAreaPosition objectAreaPosition = new ObjectAreaPosition(n, n2, n3);
        return objectAreaPosition;
    }

    public ImageDataDescriptor createImageDataDescriptor(int n, int n2, int n3, int n4) {
        ImageDataDescriptor imageDataDescriptor = new ImageDataDescriptor(n, n2, n3, n4);
        return imageDataDescriptor;
    }

    public GraphicsDataDescriptor createGraphicsDataDescriptor(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsDataDescriptor graphicsDataDescriptor = new GraphicsDataDescriptor(n, n2, n3, n4, n5, n6);
        return graphicsDataDescriptor;
    }

    public ContainerDataDescriptor createContainerDataDescriptor(int n, int n2, int n3, int n4) {
        ContainerDataDescriptor containerDataDescriptor = new ContainerDataDescriptor(n, n2, n3, n4);
        return containerDataDescriptor;
    }

    public MapContainerData createMapContainerData(byte by) {
        MapContainerData mapContainerData = new MapContainerData(by);
        return mapContainerData;
    }

    public MapDataResource createMapDataResource() {
        MapDataResource mapDataResource = new MapDataResource();
        return mapDataResource;
    }

    public PresentationTextDescriptor createPresentationTextDataDescriptor(int n, int n2, int n3, int n4) {
        PresentationTextDescriptor presentationTextDescriptor = new PresentationTextDescriptor(n, n2, n3, n4);
        return presentationTextDescriptor;
    }

    public PresentationEnvironmentControl createPresentationEnvironmentControl() {
        PresentationEnvironmentControl presentationEnvironmentControl = new PresentationEnvironmentControl();
        return presentationEnvironmentControl;
    }

    public InvokeMediumMap createInvokeMediumMap(String string) {
        InvokeMediumMap invokeMediumMap = new InvokeMediumMap(string);
        return invokeMediumMap;
    }

    public ResourceEnvironmentGroup createResourceEnvironmentGroup() {
        ResourceEnvironmentGroup resourceEnvironmentGroup = new ResourceEnvironmentGroup();
        return resourceEnvironmentGroup;
    }

    public ImageSegment createImageSegment() {
        String string = IMAGE_SEGMENT_NAME_PREFIX + StringUtils.lpad(String.valueOf(++this.imageSegmentCount), '0', 2);
        ImageSegment imageSegment = new ImageSegment(this, string);
        return imageSegment;
    }

    public ImageContent createImageContent() {
        ImageContent imageContent = new ImageContent();
        return imageContent;
    }

    public ImageRasterData createImageRasterData(byte[] byArray) {
        ImageRasterData imageRasterData = new ImageRasterData(byArray);
        return imageRasterData;
    }

    public ImageSizeParameter createImageSizeParameter(int n, int n2, int n3, int n4) {
        ImageSizeParameter imageSizeParameter = new ImageSizeParameter(n, n2, n3, n4);
        return imageSizeParameter;
    }
}

