/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.fonts.CharacterSetType;
import org.apache.fop.afp.fonts.CharactersetEncoder;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.afp.util.StringUtils;

public class CharacterSet {
    protected static final Log LOG = LogFactory.getLog((String)CharacterSet.class.getName());
    public static final String DEFAULT_CODEPAGE = "T1V10500";
    public static final String DEFAULT_ENCODING = "Cp500";
    private static final int MAX_NAME_LEN = 8;
    protected final String codePage;
    protected final String encoding;
    private final CharactersetEncoder encoder;
    protected final String name;
    private final ResourceAccessor accessor;
    private final String currentOrientation = "0";
    private final Map<String, CharacterSetOrientation> characterSetOrientations;
    private int nominalVerticalSize;

    CharacterSet(String string, String string2, CharacterSetType characterSetType, String string3, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) {
        if (string3.length() > 8) {
            String string4 = "Character set name '" + string3 + "' must be a maximum of " + 8 + " characters";
            aFPEventProducer.characterSetNameInvalid(this, string4);
            throw new IllegalArgumentException(string4);
        }
        this.name = string3.length() < 8 ? StringUtils.rpad(string3, ' ', 8) : string3;
        this.codePage = string;
        this.encoding = string2;
        this.encoder = CharactersetEncoder.newInstance(string2, characterSetType);
        this.accessor = resourceAccessor;
        this.characterSetOrientations = new HashMap<String, CharacterSetOrientation>(4);
    }

    public void addCharacterSetOrientation(CharacterSetOrientation characterSetOrientation) {
        this.characterSetOrientations.put(String.valueOf(characterSetOrientation.getOrientation()), characterSetOrientation);
    }

    public void setNominalVerticalSize(int n) {
        this.nominalVerticalSize = n;
    }

    public int getNominalVerticalSize() {
        return this.nominalVerticalSize;
    }

    public int getAscender() {
        return this.getCharacterSetOrientation().getAscender();
    }

    public int getCapHeight() {
        return this.getCharacterSetOrientation().getCapHeight();
    }

    public int getDescender() {
        return this.getCharacterSetOrientation().getDescender();
    }

    public char getFirstChar() {
        return this.getCharacterSetOrientation().getFirstChar();
    }

    public char getLastChar() {
        return this.getCharacterSetOrientation().getLastChar();
    }

    public ResourceAccessor getResourceAccessor() {
        return this.accessor;
    }

    public int[] getWidths() {
        return this.getCharacterSetOrientation().getWidths();
    }

    public int getXHeight() {
        return this.getCharacterSetOrientation().getXHeight();
    }

    public int getWidth(char c) {
        return this.getCharacterSetOrientation().getWidth(c);
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameBytes() {
        byte[] byArray = null;
        try {
            byArray = this.name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = this.name.getBytes();
            LOG.warn((Object)("UnsupportedEncodingException translating the name " + this.name));
        }
        return byArray;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private CharacterSetOrientation getCharacterSetOrientation() {
        CharacterSetOrientation characterSetOrientation = this.characterSetOrientations.get("0");
        return characterSetOrientation;
    }

    public boolean hasChar(char c) {
        if (this.encoder != null) {
            return this.encoder.canEncode(c);
        }
        return true;
    }

    public CharactersetEncoder.EncodedChars encodeChars(CharSequence charSequence) throws CharacterCodingException {
        return this.encoder.encode(charSequence);
    }

    public char mapChar(char c) {
        return c;
    }

    public int getSpaceIncrement() {
        return this.getCharacterSetOrientation().getSpaceIncrement();
    }

    public int getEmSpaceIncrement() {
        return this.getCharacterSetOrientation().getEmSpaceIncrement();
    }
}

