/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashSet;
import java.util.Set;
import org.apache.fop.afp.fonts.AbstractOutlineFont;
import org.apache.fop.afp.fonts.CharacterSet;

public class DoubleByteFont
extends AbstractOutlineFont {
    private static final Set IDEOGRAPHIC = new HashSet();

    public DoubleByteFont(String string, CharacterSet characterSet) {
        super(string, characterSet);
    }

    public int getWidth(int n, int n2) {
        int n3;
        try {
            n3 = this.charSet.getWidth(DoubleByteFont.toUnicodeCodepoint(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n3 = -1;
        }
        if (n3 == -1) {
            n3 = this.inferCharWidth(n);
        }
        return n3 * n2;
    }

    private int inferCharWidth(int n) {
        boolean bl = false;
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of((char)n);
        bl = unicodeBlock == null ? false : IDEOGRAPHIC.contains(unicodeBlock);
        if (bl) {
            return this.charSet.getEmSpaceIncrement();
        }
        return this.charSet.getSpaceIncrement();
    }

    static {
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
    }
}

