/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FontRuntimeException;

public class RasterFont
extends AFPFont {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.fop.afp.fonts");
    private final SortedMap<Integer, CharacterSet> charSets = new TreeMap<Integer, CharacterSet>();
    private Map<Integer, CharacterSet> substitutionCharSets;
    private CharacterSet charSet = null;

    public RasterFont(String string) {
        super(string);
    }

    public void addCharacterSet(int n, CharacterSet characterSet) {
        this.charSets.put(new Integer(n), characterSet);
        this.charSet = characterSet;
    }

    public CharacterSet getCharacterSet(int n) {
        Object object;
        Integer n2 = n;
        CharacterSet characterSet = (CharacterSet)this.charSets.get(n2);
        double d = (double)n / 1000.0;
        if (characterSet != null) {
            return characterSet;
        }
        if (this.substitutionCharSets != null) {
            characterSet = this.substitutionCharSets.get(n2);
        }
        if (characterSet == null && !this.charSets.isEmpty()) {
            object = this.charSets.headMap(n2);
            SortedMap<Integer, CharacterSet> sortedMap = this.charSets.tailMap(n2);
            int n3 = object.isEmpty() ? 0 : (Integer)object.lastKey();
            int n4 = sortedMap.isEmpty() ? Integer.MAX_VALUE : sortedMap.firstKey();
            Integer n5 = !object.isEmpty() && n - n3 <= n4 - n ? Integer.valueOf(n3) : Integer.valueOf(n4);
            characterSet = (CharacterSet)this.charSets.get(n5);
            if (characterSet != null) {
                if (this.substitutionCharSets == null) {
                    this.substitutionCharSets = new HashMap<Integer, CharacterSet>();
                }
                this.substitutionCharSets.put(n2, characterSet);
                if (!(Math.abs((double)n5.intValue() / 1000.0 - d) < 0.1)) {
                    String string = "No " + d + "pt font " + this.getFontName() + " found, substituted with " + (float)n5.intValue() / 1000.0f + "pt font";
                    LOG.warn((Object)string);
                }
            }
        }
        if (characterSet == null) {
            object = "No font found for font " + this.getFontName() + " with point size " + d;
            LOG.error(object);
            throw new FontRuntimeException((String)object);
        }
        return characterSet;
    }

    public int getFirstChar() {
        Iterator<CharacterSet> iterator = this.charSets.values().iterator();
        if (iterator.hasNext()) {
            CharacterSet characterSet = iterator.next();
            return characterSet.getFirstChar();
        }
        String string = "getFirstChar() - No character set found for font:" + this.getFontName();
        LOG.error((Object)string);
        throw new FontRuntimeException(string);
    }

    public int getLastChar() {
        Iterator<CharacterSet> iterator = this.charSets.values().iterator();
        if (iterator.hasNext()) {
            CharacterSet characterSet = iterator.next();
            return characterSet.getLastChar();
        }
        String string = "getLastChar() - No character set found for font:" + this.getFontName();
        LOG.error((Object)string);
        throw new FontRuntimeException(string);
    }

    private int metricsToAbsoluteSize(CharacterSet characterSet, int n, int n2) {
        int n3 = characterSet.getNominalVerticalSize();
        if (n3 != 0) {
            return n * n3;
        }
        return n * n2;
    }

    public int getAscender(int n) {
        CharacterSet characterSet = this.getCharacterSet(n);
        return this.metricsToAbsoluteSize(characterSet, characterSet.getAscender(), n);
    }

    public int getCapHeight(int n) {
        CharacterSet characterSet = this.getCharacterSet(n);
        return this.metricsToAbsoluteSize(characterSet, characterSet.getCapHeight(), n);
    }

    public int getDescender(int n) {
        CharacterSet characterSet = this.getCharacterSet(n);
        return this.metricsToAbsoluteSize(characterSet, characterSet.getDescender(), n);
    }

    public int getXHeight(int n) {
        CharacterSet characterSet = this.getCharacterSet(n);
        return this.metricsToAbsoluteSize(characterSet, characterSet.getXHeight(), n);
    }

    public int getWidth(int n, int n2) {
        CharacterSet characterSet = this.getCharacterSet(n2);
        return this.metricsToAbsoluteSize(characterSet, characterSet.getWidth(RasterFont.toUnicodeCodepoint(n)), n2);
    }

    public int[] getWidths(int n) {
        CharacterSet characterSet = this.getCharacterSet(n);
        int[] nArray = characterSet.getWidths();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.metricsToAbsoluteSize(characterSet, nArray[i], n);
        }
        return nArray;
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

