/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.modca.AbstractDataObject;
import org.apache.fop.afp.modca.ContainerDataDescriptor;
import org.apache.fop.afp.modca.MapContainerData;
import org.apache.fop.afp.util.BinaryUtils;

public class ObjectContainer
extends AbstractDataObject {
    private static final int MAX_DATA_LEN = 32759;
    private byte[] data;

    public ObjectContainer(Factory factory, String string) {
        super(factory, string);
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-110);
        int n = byArray.length + this.getTripletDataLength() - 1;
        byte[] byArray2 = BinaryUtils.convert(n, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        outputStream.write(byArray);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        super.writeContent(outputStream);
        byte[] byArray = new byte[9];
        ObjectContainer.copySF(byArray, (byte)-45, (byte)-18, (byte)-110);
        if (this.data != null) {
            ObjectContainer.writeChunksToStream(this.data, byArray, 1, 32759, outputStream);
        }
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-110);
        outputStream.write(byArray);
    }

    public void setViewport(AFPDataObjectInfo aFPDataObjectInfo) {
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        AFPResourceLevel aFPResourceLevel = aFPResourceInfo.getLevel();
        if (aFPResourceLevel.isInline()) {
            super.setViewport(aFPDataObjectInfo);
            MapContainerData mapContainerData = this.factory.createMapContainerData((byte)32);
            this.getObjectEnvironmentGroup().setMapContainerData(mapContainerData);
            int n = aFPDataObjectInfo.getDataWidth();
            int n2 = aFPDataObjectInfo.getDataHeight();
            AFPObjectAreaInfo aFPObjectAreaInfo = aFPDataObjectInfo.getObjectAreaInfo();
            int n3 = aFPObjectAreaInfo.getWidthRes();
            int n4 = aFPObjectAreaInfo.getHeightRes();
            ContainerDataDescriptor containerDataDescriptor = this.factory.createContainerDataDescriptor(n, n2, n3, n4);
            this.getObjectEnvironmentGroup().setDataDescriptor(containerDataDescriptor);
        }
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }
}

