/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.triplets.ResourceObjectTypeTriplet;
import org.apache.fop.afp.util.BinaryUtils;

public class ResourceObject
extends AbstractNamedAFPObject {
    public static final byte TYPE_GRAPHIC = 3;
    public static final byte TYPE_BARCODE = 5;
    public static final byte TYPE_IMAGE = 6;
    public static final byte TYPE_FONT_CHARACTER_SET = 64;
    public static final byte TYPE_CODE_PAGE = 65;
    public static final byte TYPE_CODED_FONT = 66;
    public static final byte TYPE_OBJECT_CONTAINER = -110;
    public static final byte TYPE_DOCUMENT = -88;
    public static final byte TYPE_PAGE_SEGMENT = -5;
    public static final byte TYPE_OVERLAY_OBJECT = -4;
    public static final byte TYPE_PAGEDEF = -3;
    public static final byte TYPE_FORMDEF = -2;
    private AbstractNamedAFPObject namedObject;

    public ResourceObject(String string) {
        super(string);
    }

    public void setDataObject(AbstractNamedAFPObject abstractNamedAFPObject) {
        this.namedObject = abstractNamedAFPObject;
    }

    public AbstractNamedAFPObject getDataObject() {
        return this.namedObject;
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        super.writeStart(outputStream);
        byte[] byArray = new byte[19];
        this.copySF(byArray, (byte)-88, (byte)-50);
        int n = this.getTripletDataLength();
        byte[] byArray2 = BinaryUtils.convert(18 + n, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[17] = 0;
        byArray[18] = 0;
        outputStream.write(byArray);
        this.writeTriplets(outputStream);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        if (this.namedObject != null) {
            this.namedObject.writeToStream(outputStream);
        }
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-50);
        outputStream.write(byArray);
    }

    public String toString() {
        return this.getName();
    }

    public void setType(byte by) {
        this.getTriplets().add(new ResourceObjectTypeTriplet(by));
    }
}

