/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.parser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public class MODCAParser {
    private static final Log LOG = LogFactory.getLog(MODCAParser.class);
    private static final int INTRODUCER_LENGTH = 8;
    public static final byte CARRIAGE_CONTROL_CHAR = 90;
    private DataInputStream din;

    public MODCAParser(InputStream inputStream) {
        this.din = new DataInputStream(inputStream);
    }

    public UnparsedStructuredField readNextStructuredField() throws IOException {
        do {
            if (this.din.available() != 0) continue;
            return null;
        } while (this.din.readByte() != 90);
        byte[] byArray = new byte[8];
        this.din.readFully(byArray);
        UnparsedStructuredField.Introducer introducer = new UnparsedStructuredField.Introducer(byArray);
        int n = introducer.getLength() - 8;
        byte[] byArray2 = null;
        if (introducer.isExtensionPresent()) {
            short s = 0;
            s = (short)(this.din.readByte() & 0xFF);
            if (s > 0) {
                byArray2 = new byte[s - 1];
                this.din.readFully(byArray2);
                n -= s;
            }
        }
        byte[] byArray3 = new byte[n];
        this.din.readFully(byArray3);
        UnparsedStructuredField unparsedStructuredField = new UnparsedStructuredField(introducer, byArray3, byArray2);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)unparsedStructuredField);
        }
        return unparsedStructuredField;
    }
}

