/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;

public final class UnparsedStructuredField {
    private final Introducer introducer;
    private final byte[] extData;
    private final byte[] data;

    UnparsedStructuredField(Introducer introducer, byte[] byArray, byte[] byArray2) {
        this.introducer = introducer;
        this.data = byArray;
        this.extData = (byte[])(byArray2 != null ? byArray2 : null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Structured Field: ");
        stringBuffer.append(Integer.toHexString(this.getSfTypeID()).toUpperCase());
        stringBuffer.append(", len=");
        stringBuffer.append(new DecimalFormat("00000").format(this.getSfLength()));
        stringBuffer.append(" ").append(this.getTypeCodeAsString());
        stringBuffer.append(" ").append(this.getCategoryCodeAsString());
        if (this.isSfiExtensionPresent()) {
            stringBuffer.append(", SFI extension present");
        }
        if (this.isSfiSegmentedData()) {
            stringBuffer.append(", segmented data");
        }
        if (this.isSfiPaddingPresent()) {
            stringBuffer.append(", with padding");
        }
        return stringBuffer.toString();
    }

    private String getTypeCodeAsString() {
        switch (this.getSfTypeCode() & 0xFF) {
            case 160: {
                return "Attribute";
            }
            case 162: {
                return "CopyCount";
            }
            case 166: {
                return "Descriptor";
            }
            case 167: {
                return "Control";
            }
            case 168: {
                return "Begin";
            }
            case 169: {
                return "End";
            }
            case 171: {
                return "Map";
            }
            case 172: {
                return "Position";
            }
            case 173: {
                return "Process";
            }
            case 175: {
                return "Include";
            }
            case 176: {
                return "Table";
            }
            case 177: {
                return "Migration";
            }
            case 178: {
                return "Variable";
            }
            case 180: {
                return "Link";
            }
            case 238: {
                return "Data";
            }
        }
        return "Unknown:" + Integer.toHexString(this.getSfTypeCode()).toUpperCase();
    }

    private String getCategoryCodeAsString() {
        switch (this.getSfCategoryCode() & 0xFF) {
            case 95: {
                return "Page Segment";
            }
            case 107: {
                return "Object Area";
            }
            case 119: {
                return "Color Attribute Table";
            }
            case 123: {
                return "IM Image";
            }
            case 136: {
                return "Medium";
            }
            case 137: {
                return "Font";
            }
            case 138: {
                return "Coded Font";
            }
            case 144: {
                return "Process Element";
            }
            case 146: {
                return "Object Container";
            }
            case 155: {
                return "Presentation Text";
            }
            case 167: {
                return "Index";
            }
            case 168: {
                return "Document";
            }
            case 173: {
                return "Page Group";
            }
            case 175: {
                return "Page";
            }
            case 187: {
                return "Graphics";
            }
            case 195: {
                return "Data Resource";
            }
            case 196: {
                return "Document Environment Group (DEG)";
            }
            case 198: {
                return "Resource Group";
            }
            case 199: {
                return "Object Environment Group (OEG)";
            }
            case 201: {
                return "Active Environment Group (AEG)";
            }
            case 204: {
                return "Medium Map";
            }
            case 205: {
                return "Form Map";
            }
            case 206: {
                return "Name Resource";
            }
            case 216: {
                return "Page Overlay";
            }
            case 217: {
                return "Resource Environment Group (REG)";
            }
            case 223: {
                return "Overlay";
            }
            case 234: {
                return "Data Supression";
            }
            case 235: {
                return "Bar Code";
            }
            case 238: {
                return "No Operation";
            }
            case 251: {
                return "Image";
            }
        }
        return "Unknown:" + Integer.toHexString(this.getSfTypeCode()).toUpperCase();
    }

    public short getSfLength() {
        return this.introducer.length;
    }

    public int getSfTypeID() {
        return (this.getSfClassCode() & 0xFF) << 16 | (this.getSfTypeCode() & 0xFF) << 8 | this.getSfCategoryCode() & 0xFF;
    }

    public byte getSfClassCode() {
        return this.introducer.classCode;
    }

    public byte getSfTypeCode() {
        return this.introducer.typeCode;
    }

    public byte getSfCategoryCode() {
        return this.introducer.categoryCode;
    }

    public boolean isSfiExtensionPresent() {
        return this.introducer.extensionPresent && this.extData != null;
    }

    public boolean isSfiSegmentedData() {
        return this.introducer.segmentedData;
    }

    public boolean isSfiPaddingPresent() {
        return this.introducer.paddingPresent;
    }

    public short getExtLength() {
        return this.extData != null ? (short)(this.extData.length + 1) : (short)0;
    }

    byte[] getExtData() {
        if (this.extData == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.extData.length];
        System.arraycopy(this.extData, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getData() {
        if (this.data == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        return byArray;
    }

    byte[] getIntroducerData() {
        return this.introducer.getIntroducerData();
    }

    public byte[] getCompleteFieldAsBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.getSfLength());
        try {
            this.writeTo(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.introducer.introducerData);
        if (this.isSfiExtensionPresent()) {
            outputStream.write(this.extData.length + 1);
            outputStream.write(this.extData);
        }
        outputStream.write(this.data);
    }

    static final class Introducer {
        private final short length;
        private final byte classCode;
        private final byte typeCode;
        private final byte categoryCode;
        private final boolean extensionPresent;
        private final boolean segmentedData;
        private final boolean paddingPresent;
        private final byte[] introducerData;

        Introducer(byte[] byArray) throws IOException {
            this.introducerData = byArray;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.length = dataInputStream.readShort();
            this.classCode = dataInputStream.readByte();
            this.typeCode = dataInputStream.readByte();
            this.categoryCode = dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            this.extensionPresent = (by & 1) != 0;
            this.segmentedData = (by & 4) != 0;
            this.paddingPresent = (by & 0x10) != 0;
        }

        public short getLength() {
            return this.length;
        }

        public byte getClassCode() {
            return this.classCode;
        }

        public byte getTypeCode() {
            return this.typeCode;
        }

        public byte getCategoryCode() {
            return this.categoryCode;
        }

        public boolean isExtensionPresent() {
            return this.extensionPresent;
        }

        public boolean isSegmentedData() {
            return this.segmentedData;
        }

        public boolean isPaddingPresent() {
            return this.paddingPresent;
        }

        public byte[] getIntroducerData() {
            byte[] byArray = new byte[this.introducerData.length];
            System.arraycopy(this.introducerData, 0, byArray, 0, byArray.length);
            return byArray;
        }
    }
}

