/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.fop.afp.parser.MODCAParser;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public final class AFPResourceUtil {
    private static final byte TYPE_CODE_BEGIN = -88;
    private static final byte TYPE_CODE_END = -87;
    private static final Log LOG = LogFactory.getLog(AFPResourceUtil.class);

    private AFPResourceUtil() {
    }

    public static byte[] getNext(byte[] byArray, InputStream inputStream) throws IOException {
        UnparsedStructuredField unparsedStructuredField;
        MODCAParser mODCAParser = new MODCAParser(inputStream);
        do {
            if ((unparsedStructuredField = mODCAParser.readNextStructuredField()) != null) continue;
            return null;
        } while (unparsedStructuredField.getSfClassCode() != byArray[0] || unparsedStructuredField.getSfTypeCode() != byArray[1] || unparsedStructuredField.getSfCategoryCode() != byArray[2]);
        return unparsedStructuredField.getCompleteFieldAsBytes();
    }

    private static String getResourceName(UnparsedStructuredField unparsedStructuredField) throws UnsupportedEncodingException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = unparsedStructuredField.getData();
        if (byArray2.length < 8) {
            throw new IllegalArgumentException("Field data does not contain a resource name");
        }
        System.arraycopy(byArray2, 0, byArray, 0, 8);
        return new String(byArray, "Cp1146");
    }

    public static void copyResourceFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        UnparsedStructuredField unparsedStructuredField;
        MODCAParser mODCAParser = new MODCAParser(inputStream);
        while ((unparsedStructuredField = mODCAParser.readNextStructuredField()) != null) {
            outputStream.write(90);
            unparsedStructuredField.writeTo(outputStream);
        }
    }

    public static void copyNamedResource(String string, InputStream inputStream, final OutputStream outputStream) throws IOException {
        boolean bl;
        Object object;
        UnparsedStructuredField unparsedStructuredField;
        final MODCAParser mODCAParser = new MODCAParser(inputStream);
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            if ((unparsedStructuredField = mODCAParser.readNextStructuredField()) == null) {
                throw new IOException("Requested resource '" + string + "' not found. Encountered resource names: " + hashSet);
            }
            if (unparsedStructuredField.getSfTypeCode() != -88) continue;
            object = AFPResourceUtil.getResourceName(unparsedStructuredField);
            hashSet.add((String)object);
            if (((String)object).equals(string)) break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start of requested structured field found:\n" + unparsedStructuredField));
        }
        final UnparsedStructuredField unparsedStructuredField2 = unparsedStructuredField;
        if (unparsedStructuredField2.getSfCategoryCode() == 95) {
            bl = true;
        } else if (unparsedStructuredField2.getSfCategoryCode() == -50) {
            bl = false;
        } else {
            throw new IOException("Cannot handle resource: " + unparsedStructuredField2);
        }
        if (bl) {
            object = new ResourceObject(string){

                protected void writeContent(OutputStream outputStream2) throws IOException {
                    AFPResourceUtil.copyNamedStructuredFields(this.name, unparsedStructuredField2, mODCAParser, outputStream);
                }
            };
            ((ResourceObject)object).setType((byte)-5);
            ((AbstractStructuredObject)object).writeToStream(outputStream);
        } else {
            AFPResourceUtil.copyNamedStructuredFields(string, unparsedStructuredField2, mODCAParser, outputStream);
        }
    }

    private static void copyNamedStructuredFields(String string, UnparsedStructuredField unparsedStructuredField, MODCAParser mODCAParser, OutputStream outputStream) throws IOException {
        UnparsedStructuredField unparsedStructuredField2 = unparsedStructuredField;
        while (true) {
            if (unparsedStructuredField2 == null) {
                throw new IOException("Ending structured field not found for resource " + string);
            }
            outputStream.write(90);
            unparsedStructuredField2.writeTo(outputStream);
            if (unparsedStructuredField2.getSfTypeCode() == -87 && unparsedStructuredField.getSfCategoryCode() == unparsedStructuredField2.getSfCategoryCode() && string.equals(AFPResourceUtil.getResourceName(unparsedStructuredField2))) break;
            unparsedStructuredField2 = mODCAParser.readNextStructuredField();
        }
    }
}

