/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.afp.util.SimpleResourceAccessor;
import org.apache.fop.apps.FOUserAgent;

public class DefaultFOPResourceAccessor
extends SimpleResourceAccessor {
    private FOUserAgent userAgent;
    private String categoryBaseURI;

    public DefaultFOPResourceAccessor(FOUserAgent fOUserAgent, String string, URI uRI) {
        super(uRI);
        this.userAgent = fOUserAgent;
        this.categoryBaseURI = string;
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        Object object;
        URI uRI2 = this.resolveAgainstBase(uRI);
        String string = this.categoryBaseURI != null ? this.categoryBaseURI : this.userAgent.getBaseURL();
        Source source = this.userAgent.resolveURI(uRI2.toASCIIString(), string);
        if (source == null) {
            throw new FileNotFoundException("Resource not found: " + uRI.toASCIIString());
        }
        if (source instanceof StreamSource) {
            object = (StreamSource)source;
            InputStream inputStream = ((StreamSource)object).getInputStream();
            if (inputStream != null) {
                return inputStream;
            }
            if (((StreamSource)object).getReader() != null) {
                IOUtils.closeQuietly((Reader)((StreamSource)object).getReader());
            }
        }
        object = new URL(source.getSystemId());
        return ((URL)object).openStream();
    }
}

