/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.xml.sax.SAXException;

public class FopFactoryConfigurator {
    public static final boolean DEFAULT_BREAK_INDENT_INHERITANCE = false;
    public static final boolean DEFAULT_STRICT_USERCONFIG_VALIDATION = true;
    public static final boolean DEFAULT_STRICT_FO_VALIDATION = true;
    public static final String DEFAULT_PAGE_WIDTH = "8.26in";
    public static final String DEFAULT_PAGE_HEIGHT = "11in";
    public static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    public static final boolean DEFAULT_COMPLEX_SCRIPT_FEATURES = true;
    private static final String PREFER_RENDERER = "prefer-renderer";
    private final Log log = LogFactory.getLog(FopFactoryConfigurator.class);
    private FopFactory factory = null;
    private Configuration cfg = null;
    private URI baseURI = null;

    public FopFactoryConfigurator(FopFactory fopFactory) {
        this.factory = fopFactory;
    }

    public void configure(FopFactory fopFactory) throws FOPException {
        Configuration configuration;
        Configuration configuration2;
        Object object;
        if (this.cfg.getChild("strict-configuration", false) != null) {
            try {
                fopFactory.setStrictUserConfigValidation(this.cfg.getChild("strict-configuration").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(this.log, (Exception)((Object)configurationException), false);
            }
        }
        boolean bl = fopFactory.validateUserConfigStrictly();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing FopFactory Configurationwith " + (bl ? "strict" : "permissive") + " validation"));
        }
        if (this.cfg.getChild("accessibility", false) != null) {
            try {
                this.factory.setAccessibility(this.cfg.getChild("accessibility").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(this.log, (Exception)((Object)configurationException), bl);
            }
        }
        if (this.cfg.getChild("strict-validation", false) != null) {
            try {
                fopFactory.setStrictValidation(this.cfg.getChild("strict-validation").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(this.log, (Exception)((Object)configurationException), bl);
            }
        }
        if (this.cfg.getChild("base", false) != null) {
            object = this.cfg.getChild("base").getValue(null);
            if (this.baseURI != null) {
                object = this.baseURI.resolve((String)object).normalize().toString();
            }
            try {
                fopFactory.setBaseURL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtil.handleException(this.log, malformedURLException, bl);
            }
        }
        if (this.cfg.getChild("hyphenation-base", false) != null) {
            object = this.cfg.getChild("hyphenation-base").getValue(null);
            if (this.baseURI != null) {
                object = this.baseURI.resolve((String)object).normalize().toString();
            }
            try {
                fopFactory.setHyphenBaseURL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtil.handleException(this.log, malformedURLException, bl);
            }
        }
        if (((Configuration[])(object = this.cfg.getChildren("hyphenation-pattern"))).length != 0) {
            configuration2 = new HashMap();
            for (int i = 0; i < ((Configuration[])object).length; ++i) {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = object[i].getLocation();
                String string3 = object[i].getAttribute("lang", null);
                if (string3 == null) {
                    FopFactoryConfigurator.addError("The lang attribute of a hyphenation-pattern configuration element must exist (" + string2 + ")", stringBuffer);
                } else if (!string3.matches("[a-zA-Z]{2}")) {
                    FopFactoryConfigurator.addError("The lang attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + string2 + ")", stringBuffer);
                }
                string3 = string3.toLowerCase();
                String string4 = object[i].getAttribute("country", null);
                if ("".equals(string4)) {
                    string4 = null;
                }
                if (string4 != null) {
                    if (!string4.matches("[a-zA-Z]{2}")) {
                        FopFactoryConfigurator.addError("The country attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + string2 + ")", stringBuffer);
                    }
                    string4 = string4.toUpperCase();
                }
                if ((string = object[i].getValue(null)) == null) {
                    FopFactoryConfigurator.addError("The value of a hyphenation-pattern configuration element may not be empty (" + string2 + ")", stringBuffer);
                }
                if (stringBuffer.length() != 0) {
                    LogUtil.handleError(this.log, stringBuffer.toString(), bl);
                    continue;
                }
                String string5 = HyphenationTreeCache.constructLlccKey(string3, string4);
                configuration2.put(string5, string);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Using hyphenation pattern filename " + string + " for lang=\"" + string3 + "\"" + (string4 != null ? ", country=\"" + string4 + "\"" : "")));
            }
            fopFactory.setHyphPatNames((Map)configuration2);
        }
        if (this.cfg.getChild("source-resolution", false) != null) {
            fopFactory.setSourceResolution(this.cfg.getChild("source-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("source-resolution set to: " + fopFactory.getSourceResolution() + "dpi (px2mm=" + fopFactory.getSourcePixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("target-resolution", false) != null) {
            fopFactory.setTargetResolution(this.cfg.getChild("target-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("target-resolution set to: " + fopFactory.getTargetResolution() + "dpi (px2mm=" + fopFactory.getTargetPixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("break-indent-inheritance", false) != null) {
            try {
                fopFactory.setBreakIndentInheritanceOnReferenceAreaBoundary(this.cfg.getChild("break-indent-inheritance").getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(this.log, (Exception)((Object)configurationException), bl);
            }
        }
        if ((configuration2 = this.cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            fopFactory.setPageHeight(configuration2.getAttribute("height", DEFAULT_PAGE_HEIGHT));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-height set to: " + fopFactory.getPageHeight()));
            }
        }
        if (configuration2.getAttribute("width", null) != null) {
            fopFactory.setPageWidth(configuration2.getAttribute("width", DEFAULT_PAGE_WIDTH));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-width set to: " + fopFactory.getPageWidth()));
            }
        }
        if (this.cfg.getChild(PREFER_RENDERER, false) != null) {
            try {
                fopFactory.getRendererFactory().setRendererPreferred(this.cfg.getChild(PREFER_RENDERER).getValueAsBoolean());
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(this.log, (Exception)((Object)configurationException), bl);
            }
        }
        if ((configuration = this.cfg.getChild("complex-scripts")) != null) {
            this.factory.setComplexScriptFeaturesEnabled(!configuration.getAttributeAsBoolean("disabled", false));
        }
        new FontManagerConfigurator(this.cfg, this.baseURI).configure(fopFactory.getFontManager(), bl);
        this.configureImageLoading(this.cfg.getChild("image-loading", false), bl);
    }

    private static void addError(String string, StringBuffer stringBuffer) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(". ");
        }
        stringBuffer.append(string);
    }

    private void configureImageLoading(Configuration configuration, boolean bl) throws FOPException {
        if (configuration == null) {
            return;
        }
        ImageImplRegistry imageImplRegistry = this.factory.getImageManager().getRegistry();
        Configuration[] configurationArray = configuration.getChildren("penalty");
        try {
            for (Configuration configuration2 : configurationArray) {
                String string = configuration2.getAttribute("class");
                String string2 = configuration2.getAttribute("value");
                Penalty penalty = null;
                if (string2.toUpperCase().startsWith("INF")) {
                    penalty = Penalty.INFINITE_PENALTY;
                } else {
                    try {
                        penalty = Penalty.toPenalty((int)Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogUtil.handleException(this.log, numberFormatException, bl);
                    }
                }
                if (penalty == null) continue;
                imageImplRegistry.setAdditionalPenalty(string, penalty);
            }
        }
        catch (ConfigurationException configurationException) {
            LogUtil.handleException(this.log, (Exception)((Object)configurationException), bl);
        }
    }

    public void setUserConfig(File file) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder defaultConfigurationBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(defaultConfigurationBuilder.buildFromFile(file));
        }
        catch (ConfigurationException configurationException) {
            throw new FOPException((Exception)((Object)configurationException));
        }
    }

    public void setUserConfig(String string) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder defaultConfigurationBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(defaultConfigurationBuilder.build(string));
        }
        catch (ConfigurationException configurationException) {
            throw new FOPException((Exception)((Object)configurationException));
        }
    }

    public void setUserConfig(Configuration configuration) throws FOPException {
        this.cfg = configuration;
        this.setBaseURI();
        this.configure(this.factory);
    }

    public Configuration getUserConfig() {
        return this.cfg;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI uRI) {
        this.baseURI = uRI;
    }

    private void setBaseURI() throws FOPException {
        String string = this.cfg.getLocation();
        try {
            if (string != null && string.startsWith("file:")) {
                this.baseURI = new URI(string);
                this.baseURI = this.baseURI.resolve(".").normalize();
            }
            if (this.baseURI == null) {
                this.baseURI = new File(System.getProperty("user.dir")).toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new FOPException(uRISyntaxException);
        }
    }
}

