/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.List;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class BodyRegion
extends RegionReference {
    private static final long serialVersionUID = -1848872997724078080L;
    private BeforeFloat beforeFloat;
    private MainReference mainReference;
    private Footnote footnote;
    private int columnGap;
    private int columnCount;

    public BodyRegion(RegionBody regionBody, RegionViewport regionViewport) {
        this(regionBody.getNameId(), regionBody.getRegionName(), regionViewport, regionBody.getColumnCount(), regionBody.getColumnGap());
    }

    public BodyRegion(int n, String string, RegionViewport regionViewport, int n2, int n3) {
        super(n, string, regionViewport);
        this.columnCount = n2;
        this.columnGap = n3;
        this.mainReference = new MainReference(this);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnGap() {
        return this.columnGap;
    }

    public MainReference getMainReference() {
        return this.mainReference;
    }

    public boolean isEmpty() {
        return !(this.mainReference != null && !this.mainReference.isEmpty() || this.footnote != null && !this.footnote.isEmpty() || this.beforeFloat != null && !this.beforeFloat.isEmpty());
    }

    public BeforeFloat getBeforeFloat() {
        if (this.beforeFloat == null) {
            this.beforeFloat = new BeforeFloat();
        }
        return this.beforeFloat;
    }

    public Footnote getFootnote() {
        if (this.footnote == null) {
            this.footnote = new Footnote();
        }
        return this.footnote;
    }

    public int getRemainingBPD() {
        int n = 0;
        List list = this.getMainReference().getSpans();
        int n2 = list.size() - 1;
        for (int i = 0; i < n2; ++i) {
            n += ((Span)list.get(i)).getHeight();
        }
        return this.getBPD() - n;
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
        if (this.getMainReference() != null) {
            this.getMainReference().setWritingModeTraits(writingModeTraitsGetter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BodyRegion bodyRegion = (BodyRegion)super.clone();
        bodyRegion.mainReference = new MainReference(bodyRegion);
        return bodyRegion;
    }
}

