/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkResolver
implements Resolvable,
Serializable {
    private static final long serialVersionUID = -7102134165192960718L;
    private boolean resolved = false;
    private String idRef;
    private Area area;
    private transient List<Resolvable> dependents = null;

    public LinkResolver(String string, Area area) {
        this.idRef = string;
        this.area = area;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public String[] getIDRefs() {
        return new String[]{this.idRef};
    }

    @Override
    public void resolveIDRef(String string, List<PageViewport> list) {
        this.resolveIDRef(string, list.get(0));
    }

    public void resolveIDRef(String string, PageViewport pageViewport) {
        if (this.idRef.equals(string) && pageViewport != null) {
            this.resolved = true;
            if (this.area != null) {
                Trait.InternalLink internalLink = new Trait.InternalLink(pageViewport.getKey(), this.idRef);
                this.area.addTrait(Trait.INTERNAL_LINK, internalLink);
                this.area = null;
            }
            this.resolveDependents(string, pageViewport);
        }
    }

    public void addDependent(Resolvable resolvable) {
        if (this.dependents == null) {
            this.dependents = new ArrayList<Resolvable>();
        }
        this.dependents.add(resolvable);
    }

    private void resolveDependents(String string, PageViewport pageViewport) {
        if (this.dependents != null) {
            ArrayList<PageViewport> arrayList = new ArrayList<PageViewport>();
            arrayList.add(pageViewport);
            for (Resolvable resolvable : this.dependents) {
                resolvable.resolveIDRef(string, arrayList);
            }
        }
    }
}

