/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineParent
extends InlineArea {
    private static final long serialVersionUID = -3047168298770354813L;
    protected List<InlineArea> inlines = new ArrayList<InlineArea>();
    protected transient boolean autoSize;
    protected int minChildOffset;
    private int maxAfterEdge;

    @Override
    public void addChildArea(Area area) {
        assert (area instanceof InlineArea);
        if (this.inlines.size() == 0) {
            this.autoSize = this.getIPD() == 0;
        }
        InlineArea inlineArea = (InlineArea)area;
        this.inlines.add(inlineArea);
        inlineArea.setParentArea(this);
        if (this.autoSize) {
            this.increaseIPD(inlineArea.getAllocIPD());
        }
        this.updateLevel(inlineArea.getBidiLevel());
        int n = inlineArea.getVirtualOffset();
        this.minChildOffset = Math.min(this.minChildOffset, n);
        this.maxAfterEdge = Math.max(this.maxAfterEdge, n + inlineArea.getVirtualBPD());
    }

    @Override
    int getVirtualOffset() {
        return this.getBlockProgressionOffset() + this.minChildOffset;
    }

    @Override
    int getVirtualBPD() {
        return this.maxAfterEdge - this.minChildOffset;
    }

    public List<InlineArea> getChildAreas() {
        return this.inlines;
    }

    @Override
    public boolean applyVariationFactor(double d, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = this.inlines.size();
        for (int i = 0; i < n4; ++i) {
            InlineArea inlineArea = this.inlines.get(i);
            bl |= inlineArea.applyVariationFactor(d, n, n2);
            n3 += inlineArea.getIPD();
        }
        this.setIPD(n3);
        return bl;
    }

    @Override
    public List collectInlineRuns(List list) {
        for (InlineArea inlineArea : this.getChildAreas()) {
            list = inlineArea.collectInlineRuns(list);
        }
        return list;
    }

    public void resetChildrenLevel() {
        Iterator<InlineArea> iterator = this.inlines.iterator();
        while (iterator.hasNext()) {
            iterator.next().resetBidiLevel();
        }
    }

    private void updateLevel(int n) {
        if (n >= 0) {
            int n2 = this.getBidiLevel();
            if (n2 >= 0) {
                if (n < n2) {
                    this.setBidiLevel(n);
                }
            } else {
                this.setBidiLevel(n);
            }
        }
    }
}

