/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import org.apache.fop.area.Area;
import org.apache.fop.area.Viewport;
import org.apache.fop.area.inline.InlineArea;

public class InlineViewport
extends InlineArea
implements Viewport {
    private static final long serialVersionUID = 813338534627918689L;
    private Area content;
    private boolean clip = false;
    private Rectangle2D contentPosition;

    public InlineViewport(Area area) {
        this(area, -1);
    }

    public InlineViewport(Area area, int n) {
        super(0, n);
        this.content = area;
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    public boolean hasClip() {
        return this.clip;
    }

    public Rectangle getClipRectangle() {
        if (this.clip) {
            return new Rectangle(this.getIPD(), this.getBPD());
        }
        return null;
    }

    public void setContentPosition(Rectangle2D rectangle2D) {
        this.contentPosition = rectangle2D;
    }

    public Rectangle2D getContentPosition() {
        return this.contentPosition;
    }

    public void setContent(Area area) {
        this.content = area;
    }

    public Area getContent() {
        return this.content;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.contentPosition != null);
        if (this.contentPosition != null) {
            objectOutputStream.writeFloat((float)this.contentPosition.getX());
            objectOutputStream.writeFloat((float)this.contentPosition.getY());
            objectOutputStream.writeFloat((float)this.contentPosition.getWidth());
            objectOutputStream.writeFloat((float)this.contentPosition.getHeight());
        }
        objectOutputStream.writeBoolean(this.clip);
        objectOutputStream.writeObject(this.traits);
        objectOutputStream.writeObject(this.content);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readBoolean()) {
            this.contentPosition = new Rectangle2D.Float(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
        }
        this.clip = objectInputStream.readBoolean();
        this.traits = (TreeMap)objectInputStream.readObject();
        this.content = (Area)objectInputStream.readObject();
    }
}

