/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.area.Area;
import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.inline.BasicLinkArea;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnflattenProcessor {
    private List<InlineArea> il;
    private List<InlineArea> ilNew;
    private int iaLevelLast;
    private TextArea tcOrig;
    private TextArea tcNew;
    private Stack<InlineParent> icOrig;
    private Stack<InlineParent> icNew;

    UnflattenProcessor(List<InlineArea> list) {
        this.il = list;
        this.ilNew = new ArrayList<InlineArea>();
        this.iaLevelLast = -1;
        this.icOrig = new Stack();
        this.icNew = new Stack();
    }

    List unflatten() {
        if (this.il != null) {
            Iterator<InlineArea> iterator = this.il.iterator();
            while (iterator.hasNext()) {
                this.process(iterator.next());
            }
        }
        this.finishAll();
        return this.ilNew;
    }

    private void process(InlineArea inlineArea) {
        this.process(this.findInlineContainers(inlineArea), this.findTextContainer(inlineArea), inlineArea);
    }

    private void process(List<InlineParent> list, TextArea textArea, InlineArea inlineArea) {
        if (this.tcNew == null || textArea != this.tcNew) {
            this.maybeFinishTextContainer(textArea, inlineArea);
            this.maybeFinishInlineContainers(list, textArea, inlineArea);
            this.update(list, textArea, inlineArea);
        }
    }

    private boolean shouldFinishTextContainer(TextArea textArea, InlineArea inlineArea) {
        if (this.tcOrig != null && textArea != this.tcOrig) {
            return true;
        }
        return this.iaLevelLast != -1 && inlineArea.getBidiLevel() != this.iaLevelLast;
    }

    private void finishTextContainer() {
        this.finishTextContainer(null, null);
    }

    private void finishTextContainer(TextArea textArea, InlineArea inlineArea) {
        if (this.tcNew != null) {
            this.updateIPD(this.tcNew);
            if (!this.icNew.empty()) {
                this.icNew.peek().addChildArea(this.tcNew);
            } else {
                this.ilNew.add(this.tcNew);
            }
        }
        this.tcNew = null;
    }

    private void maybeFinishTextContainer(TextArea textArea, InlineArea inlineArea) {
        if (this.shouldFinishTextContainer(textArea, inlineArea)) {
            this.finishTextContainer(textArea, inlineArea);
        }
    }

    private boolean shouldFinishInlineContainer(List<InlineParent> list, TextArea textArea, InlineArea inlineArea) {
        if (list == null || list.isEmpty()) {
            return !this.icOrig.empty();
        }
        if (!this.icOrig.empty()) {
            InlineParent inlineParent;
            InlineParent inlineParent2 = list.get(0);
            return inlineParent2 != (inlineParent = this.icOrig.peek()) && !this.isInlineParentOf(inlineParent2, inlineParent);
        }
        return false;
    }

    private void finishInlineContainer() {
        this.finishInlineContainer(null, null, null);
    }

    private void finishInlineContainer(List<InlineParent> list, TextArea textArea, InlineArea inlineArea) {
        if (list != null && !list.isEmpty()) {
            for (InlineParent inlineParent : list) {
                InlineParent inlineParent2;
                InlineParent inlineParent3 = inlineParent2 = this.icOrig.empty() ? null : this.icOrig.peek();
                if (inlineParent2 == null) {
                    assert (this.icNew.empty());
                    continue;
                }
                if (inlineParent == inlineParent2) break;
                assert (!this.icNew.empty());
                InlineParent inlineParent4 = this.icOrig.pop();
                InlineParent inlineParent5 = this.icNew.pop();
                assert (inlineParent4 != null);
                assert (inlineParent5 != null);
                if (this.icNew.empty()) {
                    this.ilNew.add(inlineParent5);
                } else {
                    this.icNew.peek().addChildArea(inlineParent5);
                }
                if (this.icOrig.empty() || this.icOrig.peek() != inlineParent) continue;
                break;
            }
        } else {
            while (!this.icNew.empty()) {
                InlineParent inlineParent = this.icOrig.pop();
                InlineParent inlineParent6 = this.icNew.pop();
                assert (inlineParent != null);
                assert (inlineParent6 != null);
                if (this.icNew.empty()) {
                    this.ilNew.add(inlineParent6);
                    continue;
                }
                this.icNew.peek().addChildArea(inlineParent6);
            }
        }
    }

    private void maybeFinishInlineContainers(List<InlineParent> list, TextArea textArea, InlineArea inlineArea) {
        if (this.shouldFinishInlineContainer(list, textArea, inlineArea)) {
            this.finishInlineContainer(list, textArea, inlineArea);
        }
    }

    private void finishAll() {
        this.finishTextContainer();
        this.finishInlineContainer();
    }

    private void update(List<InlineParent> list, TextArea textArea, InlineArea inlineArea) {
        if (!this.alreadyUnflattened(inlineArea)) {
            if (list != null && !list.isEmpty()) {
                this.pushInlineContainers(list);
            }
            if (textArea != null) {
                this.pushTextContainer(textArea, inlineArea);
            } else {
                this.pushNonTextInline(inlineArea);
            }
            this.iaLevelLast = inlineArea.getBidiLevel();
            this.tcOrig = textArea;
        } else if (this.tcNew != null) {
            this.finishTextContainer();
            this.tcOrig = null;
        } else {
            this.tcOrig = null;
        }
    }

    private boolean alreadyUnflattened(InlineArea inlineArea) {
        Iterator<InlineArea> iterator = this.ilNew.iterator();
        while (iterator.hasNext()) {
            if (!inlineArea.isAncestorOrSelf(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void pushInlineContainers(List<InlineParent> list) {
        LinkedList<InlineParent> linkedList = new LinkedList<InlineParent>();
        for (InlineParent inlineParent : list) {
            if (this.icOrig.search(inlineParent) >= 0) break;
            linkedList.addFirst(inlineParent);
        }
        for (InlineParent inlineParent : linkedList) {
            this.icOrig.push(inlineParent);
            this.icNew.push(this.generateInlineContainer(inlineParent));
        }
    }

    private void pushTextContainer(TextArea textArea, InlineArea inlineArea) {
        if (textArea instanceof UnresolvedPageNumber) {
            this.tcNew = textArea;
        } else {
            if (this.tcNew == null) {
                this.tcNew = this.generateTextContainer(textArea);
            }
            this.tcNew.addChildArea(inlineArea);
        }
    }

    private void pushNonTextInline(InlineArea inlineArea) {
        if (this.icNew.empty()) {
            this.ilNew.add(inlineArea);
        } else {
            this.icNew.peek().addChildArea(inlineArea);
        }
    }

    private InlineParent generateInlineContainer(InlineParent inlineParent) {
        if (inlineParent instanceof BasicLinkArea) {
            return this.generateBasicLinkArea((BasicLinkArea)inlineParent);
        }
        if (inlineParent instanceof FilledArea) {
            return this.generateFilledArea((FilledArea)inlineParent);
        }
        return this.generateInlineContainer0(inlineParent);
    }

    private InlineParent generateBasicLinkArea(BasicLinkArea basicLinkArea) {
        BasicLinkArea basicLinkArea2 = new BasicLinkArea();
        if (basicLinkArea != null) {
            this.initializeInlineContainer(basicLinkArea2, basicLinkArea);
            this.initializeLinkArea(basicLinkArea2, basicLinkArea);
        }
        return basicLinkArea2;
    }

    private void initializeLinkArea(BasicLinkArea basicLinkArea, BasicLinkArea basicLinkArea2) {
        String[] stringArray;
        assert (basicLinkArea != null);
        assert (basicLinkArea2 != null);
        LinkResolver linkResolver = basicLinkArea2.getResolver();
        if (linkResolver != null && (stringArray = linkResolver.getIDRefs()).length > 0) {
            String string = stringArray[0];
            LinkResolver linkResolver2 = new LinkResolver(string, basicLinkArea);
            basicLinkArea.setResolver(linkResolver2);
            linkResolver.addDependent(linkResolver2);
        }
    }

    private InlineParent generateFilledArea(FilledArea filledArea) {
        FilledArea filledArea2 = new FilledArea();
        if (filledArea != null) {
            this.initializeInlineContainer(filledArea2, filledArea);
            this.initializeFilledArea(filledArea2, filledArea);
        }
        return filledArea2;
    }

    private void initializeFilledArea(FilledArea filledArea, FilledArea filledArea2) {
        assert (filledArea != null);
        assert (filledArea2 != null);
        filledArea.setIPD(filledArea2.getIPD());
        filledArea.setUnitWidth(filledArea2.getUnitWidth());
    }

    private InlineParent generateInlineContainer0(InlineParent inlineParent) {
        InlineParent inlineParent2 = new InlineParent();
        if (inlineParent != null) {
            this.initializeInlineContainer(inlineParent2, inlineParent);
        }
        return inlineParent2;
    }

    private void initializeInlineContainer(InlineParent inlineParent, InlineParent inlineParent2) {
        assert (inlineParent != null);
        assert (inlineParent2 != null);
        inlineParent.setTraits(inlineParent2.getTraits());
        inlineParent.setBPD(inlineParent2.getBPD());
        inlineParent.setBlockProgressionOffset(inlineParent2.getBlockProgressionOffset());
    }

    private TextArea generateTextContainer(TextArea textArea) {
        TextArea textArea2 = new TextArea();
        if (textArea != null) {
            textArea2.setTraits(textArea.getTraits());
            textArea2.setBPD(textArea.getBPD());
            textArea2.setBlockProgressionOffset(textArea.getBlockProgressionOffset());
            textArea2.setBaselineOffset(textArea.getBaselineOffset());
            textArea2.setTextWordSpaceAdjust(textArea.getTextWordSpaceAdjust());
            textArea2.setTextLetterSpaceAdjust(textArea.getTextLetterSpaceAdjust());
        }
        return textArea2;
    }

    private void updateIPD(TextArea textArea) {
        int n = 0;
        for (InlineArea inlineArea : textArea.getChildAreas()) {
            SpaceArea spaceArea;
            if (!(inlineArea instanceof SpaceArea) || !(spaceArea = (SpaceArea)inlineArea).isAdjustable()) continue;
            ++n;
        }
        if (n > 0) {
            textArea.setIPD(textArea.getIPD() + n * textArea.getTextWordSpaceAdjust());
        }
    }

    private TextArea findTextContainer(InlineArea inlineArea) {
        assert (inlineArea != null);
        TextArea textArea = null;
        while (textArea == null) {
            if (inlineArea instanceof TextArea) {
                textArea = (TextArea)inlineArea;
                continue;
            }
            Area area = inlineArea.getParentArea();
            if (!(area instanceof InlineArea)) break;
            inlineArea = (InlineArea)area;
        }
        return textArea;
    }

    private List<InlineParent> findInlineContainers(InlineArea inlineArea) {
        assert (inlineArea != null);
        ArrayList<InlineParent> arrayList = new ArrayList<InlineParent>();
        Area area = inlineArea.getParentArea();
        while (area != null) {
            if (area instanceof InlineArea) {
                if (area instanceof InlineParent && !(area instanceof TextArea)) {
                    arrayList.add((InlineParent)area);
                }
                area = ((InlineArea)area).getParentArea();
                continue;
            }
            area = null;
        }
        return arrayList;
    }

    private boolean isInlineParentOf(InlineParent inlineParent, InlineParent inlineParent2) {
        assert (inlineParent != null);
        return inlineParent.getParentArea() == inlineParent2;
    }
}

