/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;

public class GlyphDefinitionTable
extends GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphDefinitionTable.class);
    public static final int GDEF_LOOKUP_TYPE_GLYPH_CLASS = 1;
    public static final int GDEF_LOOKUP_TYPE_ATTACHMENT_POINT = 2;
    public static final int GDEF_LOOKUP_TYPE_LIGATURE_CARET = 3;
    public static final int GDEF_LOOKUP_TYPE_MARK_ATTACHMENT = 4;
    public static final int GLYPH_CLASS_BASE = 1;
    public static final int GLYPH_CLASS_LIGATURE = 2;
    public static final int GLYPH_CLASS_MARK = 3;
    public static final int GLYPH_CLASS_COMPONENT = 4;
    private GlyphClassSubtable gct;
    private MarkAttachmentSubtable mat;

    public GlyphDefinitionTable(List list) {
        super(null, new HashMap(0));
        if (list == null || list.size() == 0) {
            throw new AdvancedTypographicTableFormatException("subtables must be non-empty");
        }
        for (Object e : list) {
            if (e instanceof GlyphDefinitionSubtable) {
                this.addSubtable((GlyphSubtable)e);
                continue;
            }
            throw new AdvancedTypographicTableFormatException("subtable must be a glyph definition subtable");
        }
        this.freezeSubtables();
    }

    public GlyphSequence reorderCombiningMarks(GlyphSequence glyphSequence, int[][] nArray, String string, String string2) {
        ScriptProcessor scriptProcessor = ScriptProcessor.getInstance(string);
        return scriptProcessor.reorderCombiningMarks(this, glyphSequence, nArray, string, string2);
    }

    protected void addSubtable(GlyphSubtable glyphSubtable) {
        if (glyphSubtable instanceof GlyphClassSubtable) {
            this.gct = (GlyphClassSubtable)glyphSubtable;
        } else if (!(glyphSubtable instanceof AttachmentPointSubtable) && !(glyphSubtable instanceof LigatureCaretSubtable)) {
            if (glyphSubtable instanceof MarkAttachmentSubtable) {
                this.mat = (MarkAttachmentSubtable)glyphSubtable;
            } else {
                throw new UnsupportedOperationException("unsupported glyph definition subtable type: " + glyphSubtable);
            }
        }
    }

    public boolean isGlyphClass(int n, int n2) {
        if (this.gct != null) {
            return this.gct.isGlyphClass(n, n2);
        }
        return false;
    }

    public int getGlyphClass(int n) {
        if (this.gct != null) {
            return this.gct.getGlyphClass(n);
        }
        return -1;
    }

    public boolean isMarkAttachClass(int n, int n2) {
        if (this.mat != null) {
            return this.mat.isMarkAttachClass(n, n2);
        }
        return false;
    }

    public int getMarkAttachClass(int n) {
        if (this.mat != null) {
            return this.mat.getMarkAttachClass(n);
        }
        return -1;
    }

    public static int getLookupTypeFromName(String string) {
        String string2 = string.toLowerCase();
        int n = "glyphclass".equals(string2) ? 1 : ("attachmentpoint".equals(string2) ? 2 : ("ligaturecaret".equals(string2) ? 3 : ("markattachment".equals(string2) ? 4 : -1)));
        return n;
    }

    public static String getLookupTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "glyphclass";
                break;
            }
            case 2: {
                string = "attachmentpoint";
                break;
            }
            case 3: {
                string = "ligaturecaret";
                break;
            }
            case 4: {
                string = "markattachment";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public static GlyphSubtable createSubtable(int n, String string, int n2, int n3, int n4, GlyphMappingTable glyphMappingTable, List list) {
        GlyphDefinitionSubtable glyphDefinitionSubtable = null;
        switch (n) {
            case 1: {
                glyphDefinitionSubtable = GlyphClassSubtable.create(string, n2, n3, n4, glyphMappingTable, list);
                break;
            }
            case 2: {
                glyphDefinitionSubtable = AttachmentPointSubtable.create(string, n2, n3, n4, glyphMappingTable, list);
                break;
            }
            case 3: {
                glyphDefinitionSubtable = LigatureCaretSubtable.create(string, n2, n3, n4, glyphMappingTable, list);
                break;
            }
            case 4: {
                glyphDefinitionSubtable = MarkAttachmentSubtable.create(string, n2, n3, n4, glyphMappingTable, list);
                break;
            }
        }
        return glyphDefinitionSubtable;
    }

    private static class MarkAttachmentSubtableFormat1
    extends MarkAttachmentSubtable {
        MarkAttachmentSubtableFormat1(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable, list);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof MarkAttachmentSubtable;
        }

        public boolean isMarkAttachClass(int n, int n2) {
            GlyphClassMapping glyphClassMapping = this.getClasses();
            if (glyphClassMapping != null) {
                return glyphClassMapping.getClassIndex(n, 0) == n2;
            }
            return false;
        }

        public int getMarkAttachClass(int n) {
            GlyphClassMapping glyphClassMapping = this.getClasses();
            if (glyphClassMapping != null) {
                return glyphClassMapping.getClassIndex(n, 0);
            }
            return -1;
        }
    }

    private static abstract class MarkAttachmentSubtable
    extends GlyphDefinitionSubtable {
        MarkAttachmentSubtable(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable);
        }

        public int getType() {
            return 4;
        }

        public abstract boolean isMarkAttachClass(int var1, int var2);

        public abstract int getMarkAttachClass(int var1);

        static GlyphDefinitionSubtable create(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            if (n3 == 1) {
                return new MarkAttachmentSubtableFormat1(string, n, n2, n3, glyphMappingTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class LigatureCaretSubtableFormat1
    extends LigatureCaretSubtable {
        LigatureCaretSubtableFormat1(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable, list);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof LigatureCaretSubtable;
        }
    }

    private static abstract class LigatureCaretSubtable
    extends GlyphDefinitionSubtable {
        LigatureCaretSubtable(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable);
        }

        public int getType() {
            return 3;
        }

        static GlyphDefinitionSubtable create(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            if (n3 == 1) {
                return new LigatureCaretSubtableFormat1(string, n, n2, n3, glyphMappingTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class AttachmentPointSubtableFormat1
    extends AttachmentPointSubtable {
        AttachmentPointSubtableFormat1(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable, list);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof AttachmentPointSubtable;
        }
    }

    private static abstract class AttachmentPointSubtable
    extends GlyphDefinitionSubtable {
        AttachmentPointSubtable(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable);
        }

        public int getType() {
            return 2;
        }

        static GlyphDefinitionSubtable create(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            if (n3 == 1) {
                return new AttachmentPointSubtableFormat1(string, n, n2, n3, glyphMappingTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class GlyphClassSubtableFormat1
    extends GlyphClassSubtable {
        GlyphClassSubtableFormat1(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable, list);
        }

        public List getEntries() {
            return null;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof GlyphClassSubtable;
        }

        public boolean isGlyphClass(int n, int n2) {
            GlyphClassMapping glyphClassMapping = this.getClasses();
            if (glyphClassMapping != null) {
                return glyphClassMapping.getClassIndex(n, 0) == n2;
            }
            return false;
        }

        public int getGlyphClass(int n) {
            GlyphClassMapping glyphClassMapping = this.getClasses();
            if (glyphClassMapping != null) {
                return glyphClassMapping.getClassIndex(n, 0);
            }
            return -1;
        }
    }

    private static abstract class GlyphClassSubtable
    extends GlyphDefinitionSubtable {
        GlyphClassSubtable(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            super(string, n, n2, n3, glyphMappingTable);
        }

        public int getType() {
            return 1;
        }

        public abstract boolean isGlyphClass(int var1, int var2);

        public abstract int getGlyphClass(int var1);

        static GlyphDefinitionSubtable create(String string, int n, int n2, int n3, GlyphMappingTable glyphMappingTable, List list) {
            if (n3 == 1) {
                return new GlyphClassSubtableFormat1(string, n, n2, n3, glyphMappingTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }
}

