/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassTable;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningState;
import org.apache.fop.complexscripts.fonts.GlyphPositioningSubtable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.GlyphTester;

public class GlyphPositioningTable
extends GlyphTable {
    private static final Log log = LogFactory.getLog(GlyphPositioningTable.class);
    public static final int GPOS_LOOKUP_TYPE_SINGLE = 1;
    public static final int GPOS_LOOKUP_TYPE_PAIR = 2;
    public static final int GPOS_LOOKUP_TYPE_CURSIVE = 3;
    public static final int GPOS_LOOKUP_TYPE_MARK_TO_BASE = 4;
    public static final int GPOS_LOOKUP_TYPE_MARK_TO_LIGATURE = 5;
    public static final int GPOS_LOOKUP_TYPE_MARK_TO_MARK = 6;
    public static final int GPOS_LOOKUP_TYPE_CONTEXTUAL = 7;
    public static final int GPOS_LOOKUP_TYPE_CHAINED_CONTEXTUAL = 8;
    public static final int GPOS_LOOKUP_TYPE_EXTENSION_POSITIONING = 9;

    public GlyphPositioningTable(GlyphDefinitionTable glyphDefinitionTable, Map map, List list) {
        super(glyphDefinitionTable, map);
        if (list == null || list.size() == 0) {
            throw new AdvancedTypographicTableFormatException("subtables must be non-empty");
        }
        for (Object e : list) {
            if (e instanceof GlyphPositioningSubtable) {
                this.addSubtable((GlyphSubtable)e);
                continue;
            }
            throw new AdvancedTypographicTableFormatException("subtable must be a glyph positioning subtable");
        }
        this.freezeSubtables();
    }

    public static int getLookupTypeFromName(String string) {
        String string2 = string.toLowerCase();
        int n = "single".equals(string2) ? 1 : ("pair".equals(string2) ? 2 : ("cursive".equals(string2) ? 3 : ("marktobase".equals(string2) ? 4 : ("marktoligature".equals(string2) ? 5 : ("marktomark".equals(string2) ? 6 : ("contextual".equals(string2) ? 7 : ("chainedcontextual".equals(string2) ? 8 : ("extensionpositioning".equals(string2) ? 9 : -1))))))));
        return n;
    }

    public static String getLookupTypeName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "single";
                break;
            }
            case 2: {
                string = "pair";
                break;
            }
            case 3: {
                string = "cursive";
                break;
            }
            case 4: {
                string = "marktobase";
                break;
            }
            case 5: {
                string = "marktoligature";
                break;
            }
            case 6: {
                string = "marktomark";
                break;
            }
            case 7: {
                string = "contextual";
                break;
            }
            case 8: {
                string = "chainedcontextual";
                break;
            }
            case 9: {
                string = "extensionpositioning";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public static GlyphSubtable createSubtable(int n, String string, int n2, int n3, int n4, GlyphCoverageTable glyphCoverageTable, List list) {
        GlyphPositioningSubtable glyphPositioningSubtable = null;
        switch (n) {
            case 1: {
                glyphPositioningSubtable = SingleSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 2: {
                glyphPositioningSubtable = PairSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 3: {
                glyphPositioningSubtable = CursiveSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 4: {
                glyphPositioningSubtable = MarkToBaseSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 5: {
                glyphPositioningSubtable = MarkToLigatureSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 6: {
                glyphPositioningSubtable = MarkToMarkSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 7: {
                glyphPositioningSubtable = ContextualSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
            case 8: {
                glyphPositioningSubtable = ChainedContextualSubtable.create(string, n2, n3, n4, glyphCoverageTable, list);
                break;
            }
        }
        return glyphPositioningSubtable;
    }

    public static GlyphSubtable createSubtable(int n, String string, int n2, int n3, int n4, List list, List list2) {
        return GlyphPositioningTable.createSubtable(n, string, n2, n3, n4, GlyphCoverageTable.createCoverageTable(list), list2);
    }

    public boolean position(GlyphSequence glyphSequence, String string, String string2, int n, int[] nArray, int[][] nArray2) {
        Map map = this.matchLookups(string, string2, "*");
        if (map != null && map.size() > 0) {
            ScriptProcessor scriptProcessor = ScriptProcessor.getInstance(string);
            return scriptProcessor.position(this, glyphSequence, string, string2, n, map, nArray, nArray2);
        }
        return false;
    }

    public static class MarkAnchor
    extends Anchor {
        private final int markClass;

        public MarkAnchor(int n, Anchor anchor) {
            super(anchor);
            this.markClass = n;
        }

        public int getMarkClass() {
            return this.markClass;
        }

        public String toString() {
            return "{ markClass = " + this.markClass + ", anchor = " + super.toString() + " }";
        }
    }

    public static class Anchor {
        private final int x;
        private final int y;
        private final int anchorPoint;
        private final DeviceTable xDevice;
        private final DeviceTable yDevice;

        public Anchor(int n, int n2) {
            this(n, n2, -1, null, null);
        }

        public Anchor(int n, int n2, int n3) {
            this(n, n2, n3, null, null);
        }

        public Anchor(int n, int n2, DeviceTable deviceTable, DeviceTable deviceTable2) {
            this(n, n2, -1, deviceTable, deviceTable2);
        }

        protected Anchor(Anchor anchor) {
            this(anchor.x, anchor.y, anchor.anchorPoint, anchor.xDevice, anchor.yDevice);
        }

        private Anchor(int n, int n2, int n3, DeviceTable deviceTable, DeviceTable deviceTable2) {
            assert (n3 >= 0 || n3 == -1);
            this.x = n;
            this.y = n2;
            this.anchorPoint = n3;
            this.xDevice = deviceTable;
            this.yDevice = deviceTable2;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getAnchorPoint() {
            return this.anchorPoint;
        }

        public DeviceTable getXDevice() {
            return this.xDevice;
        }

        public DeviceTable getYDevice() {
            return this.yDevice;
        }

        public Value getAlignmentAdjustment(Anchor anchor) {
            assert (anchor != null);
            return new Value(this.x - anchor.x, this.y - anchor.y, 0, 0, null, null, null, null);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ [" + this.x + "," + this.y + "]");
            if (this.anchorPoint != -1) {
                stringBuffer.append(", anchorPoint = " + this.anchorPoint);
            }
            if (this.xDevice != null) {
                stringBuffer.append(", xDevice = " + this.xDevice);
            }
            if (this.yDevice != null) {
                stringBuffer.append(", yDevice = " + this.yDevice);
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class PairValues {
        private final int glyph;
        private final Value value1;
        private final Value value2;

        public PairValues(int n, Value value, Value value2) {
            assert (n >= 0);
            this.glyph = n;
            this.value1 = value;
            this.value2 = value2;
        }

        public int getGlyph() {
            return this.glyph;
        }

        public Value getValue1() {
            return this.value1;
        }

        public Value getValue2() {
            return this.value2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append("{ ");
            if (this.glyph != 0) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("glyph = " + this.glyph);
            }
            if (this.value1 != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("value1 = " + this.value1);
            }
            if (this.value2 != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("value2 = " + this.value2);
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class Value {
        public static final int X_PLACEMENT = 1;
        public static final int Y_PLACEMENT = 2;
        public static final int X_ADVANCE = 4;
        public static final int Y_ADVANCE = 8;
        public static final int X_PLACEMENT_DEVICE = 16;
        public static final int Y_PLACEMENT_DEVICE = 32;
        public static final int X_ADVANCE_DEVICE = 64;
        public static final int Y_ADVANCE_DEVICE = 128;
        public static final int IDX_X_PLACEMENT = 0;
        public static final int IDX_Y_PLACEMENT = 1;
        public static final int IDX_X_ADVANCE = 2;
        public static final int IDX_Y_ADVANCE = 3;
        private int xPlacement;
        private int yPlacement;
        private int xAdvance;
        private int yAdvance;
        private final DeviceTable xPlaDevice;
        private final DeviceTable yPlaDevice;
        private final DeviceTable xAdvDevice;
        private final DeviceTable yAdvDevice;

        public Value(int n, int n2, int n3, int n4, DeviceTable deviceTable, DeviceTable deviceTable2, DeviceTable deviceTable3, DeviceTable deviceTable4) {
            this.xPlacement = n;
            this.yPlacement = n2;
            this.xAdvance = n3;
            this.yAdvance = n4;
            this.xPlaDevice = deviceTable;
            this.yPlaDevice = deviceTable2;
            this.xAdvDevice = deviceTable3;
            this.yAdvDevice = deviceTable4;
        }

        public int getXPlacement() {
            return this.xPlacement;
        }

        public int getYPlacement() {
            return this.yPlacement;
        }

        public int getXAdvance() {
            return this.xAdvance;
        }

        public int getYAdvance() {
            return this.yAdvance;
        }

        public DeviceTable getXPlaDevice() {
            return this.xPlaDevice;
        }

        public DeviceTable getYPlaDevice() {
            return this.yPlaDevice;
        }

        public DeviceTable getXAdvDevice() {
            return this.xAdvDevice;
        }

        public DeviceTable getYAdvDevice() {
            return this.yAdvDevice;
        }

        public void adjust(int n, int n2, int n3, int n4) {
            this.xPlacement += n;
            this.yPlacement += n2;
            this.xAdvance += n3;
            this.yAdvance += n4;
        }

        public boolean adjust(int[] nArray, int n) {
            boolean bl = false;
            int n2 = this.xPlacement;
            if (n2 != 0) {
                nArray[0] = nArray[0] + n2;
                bl = true;
            }
            if ((n2 = this.yPlacement) != 0) {
                nArray[1] = nArray[1] + n2;
                bl = true;
            }
            if ((n2 = this.xAdvance) != 0) {
                nArray[2] = nArray[2] + n2;
                bl = true;
            }
            if ((n2 = this.yAdvance) != 0) {
                nArray[3] = nArray[3] + n2;
                bl = true;
            }
            if (n != 0) {
                DeviceTable deviceTable = this.xPlaDevice;
                if (deviceTable != null && (n2 = deviceTable.findAdjustment(n)) != 0) {
                    nArray[0] = nArray[0] + n2;
                    bl = true;
                }
                if ((deviceTable = this.yPlaDevice) != null && (n2 = deviceTable.findAdjustment(n)) != 0) {
                    nArray[1] = nArray[1] + n2;
                    bl = true;
                }
                if ((deviceTable = this.xAdvDevice) != null && (n2 = deviceTable.findAdjustment(n)) != 0) {
                    nArray[2] = nArray[2] + n2;
                    bl = true;
                }
                if ((deviceTable = this.yAdvDevice) != null && (n2 = deviceTable.findAdjustment(n)) != 0) {
                    nArray[3] = nArray[3] + n2;
                    bl = true;
                }
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append("{ ");
            if (this.xPlacement != 0) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xPlacement = " + this.xPlacement);
            }
            if (this.yPlacement != 0) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("yPlacement = " + this.yPlacement);
            }
            if (this.xAdvance != 0) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xAdvance = " + this.xAdvance);
            }
            if (this.yAdvance != 0) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("yAdvance = " + this.yAdvance);
            }
            if (this.xPlaDevice != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xPlaDevice = " + this.xPlaDevice);
            }
            if (this.yPlaDevice != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xPlaDevice = " + this.yPlaDevice);
            }
            if (this.xAdvDevice != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xAdvDevice = " + this.xAdvDevice);
            }
            if (this.yAdvDevice != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("xAdvDevice = " + this.yAdvDevice);
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
    }

    public static class DeviceTable {
        private final int startSize;
        private final int endSize;
        private final int[] deltas;

        public DeviceTable(int n, int n2, int[] nArray) {
            assert (n >= 0);
            assert (n <= n2);
            assert (nArray != null);
            assert (nArray.length == n2 - n + 1);
            this.startSize = n;
            this.endSize = n2;
            this.deltas = nArray;
        }

        public int getStartSize() {
            return this.startSize;
        }

        public int getEndSize() {
            return this.endSize;
        }

        public int[] getDeltas() {
            return this.deltas;
        }

        public int findAdjustment(int n) {
            int n2 = n / 1000;
            if (n2 < this.startSize) {
                return 0;
            }
            if (n2 <= this.endSize) {
                return this.deltas[n2 - this.startSize] * 1000;
            }
            return 0;
        }

        public String toString() {
            return "{ start = " + this.startSize + ", end = " + this.endSize + ", deltas = " + Arrays.toString(this.deltas) + "}";
        }
    }

    private static class ChainedContextualSubtableFormat3
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat3(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphCoverageTable[] glyphCoverageTableArray;
                    GlyphCoverageTable[] glyphCoverageTableArray2;
                    GlyphTable.ChainedCoverageSequenceRule chainedCoverageSequenceRule;
                    GlyphCoverageTable[] glyphCoverageTableArray3;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedCoverageSequenceRule) || !this.matches(glyphPositioningState, glyphCoverageTableArray3 = (chainedCoverageSequenceRule = (GlyphTable.ChainedCoverageSequenceRule)rule).getCoverages(), 0, nArray) || !this.matches(glyphPositioningState, glyphCoverageTableArray2 = chainedCoverageSequenceRule.getBacktrackCoverages(), -1, null) || !this.matches(glyphPositioningState, glyphCoverageTableArray = chainedCoverageSequenceRule.getLookaheadCoverages(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphPositioningState glyphPositioningState, GlyphCoverageTable[] glyphCoverageTableArray, int n, int[] nArray) {
            return ContextualSubtableFormat3.matches(glyphPositioningState, glyphCoverageTableArray, n, nArray);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static class ChainedContextualSubtableFormat2
    extends ChainedContextualSubtable {
        private GlyphClassTable icdt;
        private GlyphClassTable bcdt;
        private GlyphClassTable lcdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(5);
                arrayList.add(this.icdt);
                arrayList.add(this.bcdt);
                arrayList.add(this.lcdt);
                arrayList.add(this.ngc);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    int[] nArray2;
                    int[] nArray3;
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int[] nArray4;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedClassSequenceRule) || !this.matches(glyphPositioningState, this.icdt, nArray4 = (chainedClassSequenceRule = (GlyphTable.ChainedClassSequenceRule)rule).getClasses(this.icdt.getClassIndex(n2, glyphPositioningState.getClassMatchSet(n2))), 0, nArray) || !this.matches(glyphPositioningState, this.bcdt, nArray3 = chainedClassSequenceRule.getBacktrackClasses(), -1, null) || !this.matches(glyphPositioningState, this.lcdt, nArray2 = chainedClassSequenceRule.getLookaheadClasses(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphPositioningState glyphPositioningState, GlyphClassTable glyphClassTable, int[] nArray, int n, int[] nArray2) {
            return ContextualSubtableFormat2.matches(glyphPositioningState, glyphClassTable, nArray, n, nArray2);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 5) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 5 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.icdt = (GlyphClassTable)e;
            e = list.get(1);
            if (e != null && !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an GlyphClassTable, but is: " + e.getClass());
            }
            this.bcdt = (GlyphClassTable)e;
            e = list.get(2);
            if (e != null && !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an GlyphClassTable, but is: " + e.getClass());
            }
            this.lcdt = (GlyphClassTable)e;
            e = list.get(3);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.ngc = (Integer)e;
            e = list.get(4);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fifth entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ChainedContextualSubtableFormat1
    extends ChainedContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ChainedContextualSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    int[] nArray2;
                    int[] nArray3;
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int[] nArray4;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedGlyphSequenceRule) || !this.matches(glyphPositioningState, nArray4 = (chainedGlyphSequenceRule = (GlyphTable.ChainedGlyphSequenceRule)rule).getGlyphs(n2), 0, nArray) || !this.matches(glyphPositioningState, nArray3 = chainedGlyphSequenceRule.getBacktrackGlyphs(), -1, null) || !this.matches(glyphPositioningState, nArray2 = chainedGlyphSequenceRule.getLookaheadGlyphs(), nArray[0], null)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        private boolean matches(GlyphPositioningState glyphPositioningState, int[] nArray, int n, int[] nArray2) {
            return ContextualSubtableFormat1.matches(glyphPositioningState, nArray, n, nArray2);
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static abstract class ChainedContextualSubtable
    extends GlyphPositioningSubtable {
        ChainedContextualSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 8;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof ChainedContextualSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            int[] nArray;
            GlyphTable.RuleLookup[] ruleLookupArray;
            boolean bl = false;
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 >= 0 && (ruleLookupArray = this.getLookups(n2, n, glyphPositioningState, nArray = new int[1])) != null) {
                glyphPositioningState.apply(ruleLookupArray, nArray[0]);
                bl = true;
            }
            return bl;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphPositioningState var3, int[] var4);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new ChainedContextualSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new ChainedContextualSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 3) {
                return new ChainedContextualSubtableFormat3(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ContextualSubtableFormat3
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat3(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedCoverageSequenceRule chainedCoverageSequenceRule;
                    GlyphCoverageTable[] glyphCoverageTableArray;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedCoverageSequenceRule) || !ContextualSubtableFormat3.matches(glyphPositioningState, glyphCoverageTableArray = (chainedCoverageSequenceRule = (GlyphTable.ChainedCoverageSequenceRule)rule).getCoverages(), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphPositioningState glyphPositioningState, GlyphCoverageTable[] glyphCoverageTableArray, int n, int[] nArray) {
            int n2;
            GlyphTester glyphTester;
            if (glyphCoverageTableArray == null || glyphCoverageTableArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray2 = glyphPositioningState.getGlyphsAvailable(n, bl, glyphTester = glyphPositioningState.getIgnoreDefault());
            int n3 = nArray2[0];
            if (n3 < (n2 = glyphCoverageTableArray.length)) {
                return false;
            }
            int[] nArray3 = glyphPositioningState.getGlyphs(n, n2, bl, glyphTester, null, nArray2);
            for (int i = 0; i < n2; ++i) {
                GlyphCoverageTable glyphCoverageTable = glyphCoverageTableArray[i];
                if (glyphCoverageTable == null || glyphCoverageTable.getCoverageIndex(nArray3[i]) >= 0) continue;
                return false;
            }
            if (nArray != null) {
                nArray[0] = nArray2[0] + nArray2[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static class ContextualSubtableFormat2
    extends ContextualSubtable {
        private GlyphClassTable cdt;
        private int ngc;
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(3);
                arrayList.add(this.cdt);
                arrayList.add(this.ngc);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int[] nArray2;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedClassSequenceRule) || !ContextualSubtableFormat2.matches(glyphPositioningState, this.cdt, nArray2 = (chainedClassSequenceRule = (GlyphTable.ChainedClassSequenceRule)rule).getClasses(this.cdt.getClassIndex(n2, glyphPositioningState.getClassMatchSet(n2))), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphPositioningState glyphPositioningState, GlyphClassTable glyphClassTable, int[] nArray, int n, int[] nArray2) {
            int n2;
            GlyphTester glyphTester;
            if (glyphClassTable == null || nArray == null || nArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray3 = glyphPositioningState.getGlyphsAvailable(n, bl, glyphTester = glyphPositioningState.getIgnoreDefault());
            int n3 = nArray3[0];
            if (n3 < (n2 = nArray.length)) {
                return false;
            }
            int[] nArray4 = glyphPositioningState.getGlyphs(n, n2, bl, glyphTester, null, nArray3);
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray4[i];
                int n5 = glyphPositioningState.getClassMatchSet(n4);
                int n6 = glyphClassTable.getClassIndex(n4, n5);
                if (n6 < 0 || n6 >= glyphClassTable.getClassSize(n5)) {
                    return false;
                }
                if (n6 == nArray[i]) continue;
                return false;
            }
            if (nArray2 != null) {
                nArray2[0] = nArray3[0] + nArray3[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 3) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 3 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.cdt = (GlyphClassTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.ngc = (Integer)e;
            e = list.get(2);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
            if (this.rsa.length != this.ngc) {
                throw new AdvancedTypographicTableFormatException("illegal entries, RuleSet[] length is " + this.rsa.length + ", but expected " + this.ngc + " glyph classes");
            }
        }
    }

    private static class ContextualSubtableFormat1
    extends ContextualSubtable {
        private GlyphTable.RuleSet[] rsa;

        ContextualSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.rsa != null) {
                ArrayList<GlyphTable.RuleSet[]> arrayList = new ArrayList<GlyphTable.RuleSet[]>(1);
                arrayList.add(this.rsa);
                return arrayList;
            }
            return null;
        }

        public void resolveLookupReferences(Map map) {
            GlyphTable.resolveLookupReferences(this.rsa, map);
        }

        public GlyphTable.RuleLookup[] getLookups(int n, int n2, GlyphPositioningState glyphPositioningState, int[] nArray) {
            GlyphTable.RuleSet ruleSet;
            assert (glyphPositioningState != null);
            assert (nArray != null && nArray.length > 0);
            assert (this.rsa != null);
            if (this.rsa.length > 0 && (ruleSet = this.rsa[0]) != null) {
                for (GlyphTable.Rule rule : ruleSet.getRules()) {
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int[] nArray2;
                    if (rule == null || !(rule instanceof GlyphTable.ChainedGlyphSequenceRule) || !ContextualSubtableFormat1.matches(glyphPositioningState, nArray2 = (chainedGlyphSequenceRule = (GlyphTable.ChainedGlyphSequenceRule)rule).getGlyphs(n2), 0, nArray)) continue;
                    return rule.getLookups();
                }
            }
            return null;
        }

        static boolean matches(GlyphPositioningState glyphPositioningState, int[] nArray, int n, int[] nArray2) {
            int n2;
            GlyphTester glyphTester;
            if (nArray == null || nArray.length == 0) {
                return true;
            }
            boolean bl = n < 0;
            int[] nArray3 = glyphPositioningState.getGlyphsAvailable(n, bl, glyphTester = glyphPositioningState.getIgnoreDefault());
            int n3 = nArray3[0];
            if (n3 < (n2 = nArray.length)) {
                return false;
            }
            int[] nArray4 = glyphPositioningState.getGlyphs(n, n2, bl, glyphTester, null, nArray3);
            for (int i = 0; i < n2; ++i) {
                if (nArray4[i] == nArray[i]) continue;
                return false;
            }
            if (nArray2 != null) {
                nArray2[0] = nArray3[0] + nArray3[1];
            }
            return true;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphTable.RuleSet[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an RuleSet[], but is: " + (e != null ? e.getClass() : null));
            }
            this.rsa = (GlyphTable.RuleSet[])e;
        }
    }

    private static abstract class ContextualSubtable
    extends GlyphPositioningSubtable {
        ContextualSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 7;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof ContextualSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            int[] nArray;
            GlyphTable.RuleLookup[] ruleLookupArray;
            boolean bl = false;
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 >= 0 && (ruleLookupArray = this.getLookups(n2, n, glyphPositioningState, nArray = new int[1])) != null) {
                glyphPositioningState.apply(ruleLookupArray, nArray[0]);
                bl = true;
            }
            return bl;
        }

        public abstract GlyphTable.RuleLookup[] getLookups(int var1, int var2, GlyphPositioningState var3, int[] var4);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new ContextualSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new ContextualSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 3) {
                return new ContextualSubtableFormat3(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class MarkToMarkSubtableFormat1
    extends MarkToMarkSubtable {
        private GlyphCoverageTable mct2;
        private int nmc;
        private MarkAnchor[] maa;
        private Anchor[][] mam;

        MarkToMarkSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.mct2 != null && this.maa != null && this.nmc > 0 && this.mam != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(4);
                arrayList.add(this.mct2);
                arrayList.add(this.nmc);
                arrayList.add(this.maa);
                arrayList.add(this.mam);
                return arrayList;
            }
            return null;
        }

        public MarkAnchor getMark1Anchor(int n, int n2) {
            if (this.maa != null && n < this.maa.length) {
                return this.maa[n];
            }
            return null;
        }

        public Anchor getMark2Anchor(int n, int n2) {
            Anchor[] anchorArray;
            int n3;
            if (this.mct2 != null && (n3 = this.mct2.getCoverageIndex(n)) >= 0 && this.mam != null && n3 < this.mam.length && (anchorArray = this.mam[n3]) != null && n2 < anchorArray.length) {
                return anchorArray[n2];
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 4) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 4 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphCoverageTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphCoverageTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.mct2 = (GlyphCoverageTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.nmc = (Integer)e;
            e = list.get(2);
            if (e == null || !(e instanceof MarkAnchor[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be a MarkAnchor[], but is: " + (e != null ? e.getClass() : null));
            }
            this.maa = (MarkAnchor[])e;
            e = list.get(3);
            if (e == null || !(e instanceof Anchor[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be a Anchor[][], but is: " + (e != null ? e.getClass() : null));
            }
            this.mam = (Anchor[][])e;
        }
    }

    private static abstract class MarkToMarkSubtable
    extends GlyphPositioningSubtable {
        MarkToMarkSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 6;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof MarkToMarkSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            MarkAnchor markAnchor;
            boolean bl = false;
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 >= 0 && (markAnchor = this.getMark1Anchor(n2, n)) != null && glyphPositioningState.hasPrev()) {
                Anchor anchor = this.getMark2Anchor(glyphPositioningState.getGlyph(-1), markAnchor.getMarkClass());
                if (anchor != null && glyphPositioningState.adjust(anchor.getAlignmentAdjustment(markAnchor))) {
                    glyphPositioningState.setAdjusted(true);
                }
                glyphPositioningState.consume(1);
                bl = true;
            }
            return bl;
        }

        public abstract MarkAnchor getMark1Anchor(int var1, int var2);

        public abstract Anchor getMark2Anchor(int var1, int var2);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new MarkToMarkSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class MarkToLigatureSubtableFormat1
    extends MarkToLigatureSubtable {
        private GlyphCoverageTable lct;
        private int nmc;
        private int mxc;
        private MarkAnchor[] maa;
        private Anchor[][][] lam;

        MarkToLigatureSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.lam != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(5);
                arrayList.add(this.lct);
                arrayList.add(this.nmc);
                arrayList.add(this.mxc);
                arrayList.add(this.maa);
                arrayList.add(this.lam);
                return arrayList;
            }
            return null;
        }

        public MarkAnchor getMarkAnchor(int n, int n2) {
            if (this.maa != null && n < this.maa.length) {
                return this.maa[n];
            }
            return null;
        }

        public int getMaxComponentCount() {
            return this.mxc;
        }

        public Anchor getLigatureAnchor(int n, int n2, int n3, int n4) {
            int n5;
            if (this.lct != null && (n5 = this.lct.getCoverageIndex(n)) >= 0 && this.lam != null && n5 < this.lam.length) {
                Anchor[] anchorArray;
                Anchor[][] anchorArray2 = this.lam[n5];
                if (n3 < n2 && (anchorArray = anchorArray2[n3]) != null && n4 < anchorArray.length) {
                    return anchorArray[n4];
                }
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 5) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 5 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphCoverageTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphCoverageTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.lct = (GlyphCoverageTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.nmc = (Integer)e;
            e = list.get(2);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.mxc = (Integer)e;
            e = list.get(3);
            if (e == null || !(e instanceof MarkAnchor[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be a MarkAnchor[], but is: " + (e != null ? e.getClass() : null));
            }
            this.maa = (MarkAnchor[])e;
            e = list.get(4);
            if (e == null || !(e instanceof Anchor[][][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fifth entry must be a Anchor[][][], but is: " + (e != null ? e.getClass() : null));
            }
            this.lam = (Anchor[][][])e;
        }
    }

    private static abstract class MarkToLigatureSubtable
    extends GlyphPositioningSubtable {
        MarkToLigatureSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 5;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof MarkToLigatureSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            boolean bl = false;
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 >= 0) {
                MarkAnchor markAnchor = this.getMarkAnchor(n2, n);
                int n3 = this.getMaxComponentCount();
                if (markAnchor != null) {
                    int n4 = glyphPositioningState.getPosition();
                    for (int i = 0; i < n4; ++i) {
                        int n5 = glyphPositioningState.getGlyph(-(i + 1));
                        if (glyphPositioningState.isMark(n5)) continue;
                        Anchor anchor = this.getLigatureAnchor(n5, n3, i, markAnchor.getMarkClass());
                        if (anchor != null && glyphPositioningState.adjust(anchor.getAlignmentAdjustment(markAnchor))) {
                            glyphPositioningState.setAdjusted(true);
                        }
                        glyphPositioningState.consume(1);
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        public abstract MarkAnchor getMarkAnchor(int var1, int var2);

        public abstract int getMaxComponentCount();

        public abstract Anchor getLigatureAnchor(int var1, int var2, int var3, int var4);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new MarkToLigatureSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class MarkToBaseSubtableFormat1
    extends MarkToBaseSubtable {
        private GlyphCoverageTable bct;
        private int nmc;
        private MarkAnchor[] maa;
        private Anchor[][] bam;

        MarkToBaseSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.bct != null && this.maa != null && this.nmc > 0 && this.bam != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(4);
                arrayList.add(this.bct);
                arrayList.add(this.nmc);
                arrayList.add(this.maa);
                arrayList.add(this.bam);
                return arrayList;
            }
            return null;
        }

        public MarkAnchor getMarkAnchor(int n, int n2) {
            if (this.maa != null && n < this.maa.length) {
                return this.maa[n];
            }
            return null;
        }

        public Anchor getBaseAnchor(int n, int n2) {
            Anchor[] anchorArray;
            int n3;
            if (this.bct != null && (n3 = this.bct.getCoverageIndex(n)) >= 0 && this.bam != null && n3 < this.bam.length && (anchorArray = this.bam[n3]) != null && n2 < anchorArray.length) {
                return anchorArray[n2];
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 4) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 4 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphCoverageTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphCoverageTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.bct = (GlyphCoverageTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.nmc = (Integer)e;
            e = list.get(2);
            if (e == null || !(e instanceof MarkAnchor[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be a MarkAnchor[], but is: " + (e != null ? e.getClass() : null));
            }
            this.maa = (MarkAnchor[])e;
            e = list.get(3);
            if (e == null || !(e instanceof Anchor[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be a Anchor[][], but is: " + (e != null ? e.getClass() : null));
            }
            this.bam = (Anchor[][])e;
        }
    }

    private static abstract class MarkToBaseSubtable
    extends GlyphPositioningSubtable {
        MarkToBaseSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 4;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof MarkToBaseSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            MarkAnchor markAnchor;
            boolean bl = false;
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 >= 0 && (markAnchor = this.getMarkAnchor(n2, n)) != null) {
                int n3 = glyphPositioningState.getPosition();
                for (int i = 0; i < n3; ++i) {
                    int n4 = glyphPositioningState.getGlyph(-(i + 1));
                    if (glyphPositioningState.isMark(n4)) continue;
                    Anchor anchor = this.getBaseAnchor(n4, markAnchor.getMarkClass());
                    if (anchor != null) {
                        Value value = anchor.getAlignmentAdjustment(markAnchor);
                        int[] nArray = glyphPositioningState.getAdjustment();
                        if (nArray[2] == 0) {
                            value.adjust(0, 0, -glyphPositioningState.getWidth(n), 0);
                        }
                        if (glyphPositioningState.adjust(value)) {
                            glyphPositioningState.setAdjusted(true);
                        }
                    }
                    glyphPositioningState.consume(1);
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public abstract MarkAnchor getMarkAnchor(int var1, int var2);

        public abstract Anchor getBaseAnchor(int var1, int var2);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new MarkToBaseSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class CursiveSubtableFormat1
    extends CursiveSubtable {
        private Anchor[] aa;

        CursiveSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.aa != null) {
                ArrayList<Anchor[]> arrayList = new ArrayList<Anchor[]>(1);
                arrayList.add(this.aa);
                return arrayList;
            }
            return null;
        }

        public Anchor[] getExitEntryAnchors(int n, int n2) {
            if (n >= 0 && n2 >= 0) {
                int n3 = n * 2 + 1;
                int n4 = n2 * 2 + 0;
                if (this.aa != null && n3 < this.aa.length && n4 < this.aa.length) {
                    Anchor anchor = this.aa[n3];
                    Anchor anchor2 = this.aa[n4];
                    if (anchor != null && anchor2 != null) {
                        return new Anchor[]{anchor, anchor2};
                    }
                }
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof Anchor[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first (and only) entry must be a Anchor[], but is: " + (e != null ? e.getClass() : null));
            }
            if (((Anchor[])e).length % 2 != 0) {
                throw new AdvancedTypographicTableFormatException("illegal entries, Anchor[] array must have an even number of entries, but has: " + ((Anchor[])e).length);
            }
            this.aa = (Anchor[])e;
        }
    }

    private static abstract class CursiveSubtable
    extends GlyphPositioningSubtable {
        CursiveSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 3;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof CursiveSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            int n;
            int n2;
            int n3;
            Anchor[] anchorArray;
            int[] nArray;
            int[] nArray2;
            int n4;
            boolean bl = false;
            int n5 = glyphPositioningState.getGlyph(0);
            int n6 = this.getCoverageIndex(n5);
            if (n6 >= 0 && (n4 = (nArray2 = glyphPositioningState.getGlyphsAvailable(0))[0]) > 1 && (nArray = glyphPositioningState.getGlyphs(0, 2, null, nArray2)) != null && nArray.length == 2 && (anchorArray = this.getExitEntryAnchors(n3 = n6, n2 = this.getCoverageIndex(n = nArray[1]))) != null) {
                Anchor anchor = anchorArray[0];
                Anchor anchor2 = anchorArray[1];
                int n7 = glyphPositioningState.getWidth(n);
                if (anchor != null && anchor2 != null) {
                    Value value = anchor2.getAlignmentAdjustment(anchor);
                    value.adjust(-n7, 0, 0, 0);
                    if (glyphPositioningState.adjust(value)) {
                        glyphPositioningState.setAdjusted(true);
                    }
                }
                glyphPositioningState.consume(1);
                bl = true;
            }
            return bl;
        }

        public abstract Anchor[] getExitEntryAnchors(int var1, int var2);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new CursiveSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class PairSubtableFormat2
    extends PairSubtable {
        private GlyphClassTable cdt1;
        private GlyphClassTable cdt2;
        private int nc1;
        private int nc2;
        private PairValues[][] pvm;

        PairSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.pvm != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(5);
                arrayList.add(this.cdt1);
                arrayList.add(this.cdt2);
                arrayList.add(this.nc1);
                arrayList.add(this.nc2);
                arrayList.add(this.pvm);
                return arrayList;
            }
            return null;
        }

        public PairValues getPairValues(int n, int n2, int n3) {
            int n4;
            PairValues[] pairValuesArray;
            int n5;
            if (this.pvm != null && (n5 = this.cdt1.getClassIndex(n2, 0)) >= 0 && n5 < this.nc1 && n5 < this.pvm.length && (pairValuesArray = this.pvm[n5]) != null && (n4 = this.cdt2.getClassIndex(n3, 0)) >= 0 && n4 < this.nc2 && n4 < pairValuesArray.length) {
                return pairValuesArray[n4];
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 5) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 5 entries");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.cdt1 = (GlyphClassTable)e;
            e = list.get(1);
            if (e == null || !(e instanceof GlyphClassTable)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, second entry must be an GlyphClassTable, but is: " + (e != null ? e.getClass() : null));
            }
            this.cdt2 = (GlyphClassTable)e;
            e = list.get(2);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, third entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.nc1 = (Integer)e;
            e = list.get(3);
            if (e == null || !(e instanceof Integer)) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fourth entry must be an Integer, but is: " + (e != null ? e.getClass() : null));
            }
            this.nc2 = (Integer)e;
            e = list.get(4);
            if (e == null || !(e instanceof PairValues[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, fifth entry must be a PairValues[][], but is: " + (e != null ? e.getClass() : null));
            }
            this.pvm = (PairValues[][])e;
        }
    }

    private static class PairSubtableFormat1
    extends PairSubtable {
        private PairValues[][] pvm;

        PairSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.pvm != null) {
                ArrayList<PairValues[][]> arrayList = new ArrayList<PairValues[][]>(1);
                arrayList.add(this.pvm);
                return arrayList;
            }
            return null;
        }

        public PairValues getPairValues(int n, int n2, int n3) {
            if (this.pvm != null && n < this.pvm.length) {
                for (PairValues pairValues : this.pvm[n]) {
                    int n4;
                    if (pairValues == null || (n4 = pairValues.getGlyph()) < n3) continue;
                    if (n4 != n3) break;
                    return pairValues;
                }
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof PairValues[][])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, first (and only) entry must be a PairValues[][], but is: " + (e != null ? e.getClass() : null));
            }
            this.pvm = (PairValues[][])e;
        }
    }

    private static abstract class PairSubtable
    extends GlyphPositioningSubtable {
        PairSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 2;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof PairSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            PairValues pairValues;
            int[] nArray;
            int[] nArray2;
            int n;
            boolean bl = false;
            int n2 = glyphPositioningState.getGlyph(0);
            int n3 = this.getCoverageIndex(n2);
            if (n3 >= 0 && (n = (nArray2 = glyphPositioningState.getGlyphsAvailable(0))[0]) > 1 && (nArray = glyphPositioningState.getGlyphs(0, 2, null, nArray2)) != null && nArray.length == 2 && (pairValues = this.getPairValues(n3, nArray[0], nArray[1])) != null) {
                Value value;
                Value value2 = pairValues.getValue1();
                if (value2 != null && glyphPositioningState.adjust(value2, 0)) {
                    glyphPositioningState.setAdjusted(true);
                }
                if ((value = pairValues.getValue2()) != null && glyphPositioningState.adjust(value, 1)) {
                    glyphPositioningState.setAdjusted(true);
                }
                glyphPositioningState.consume(nArray2[0] + nArray2[1]);
                bl = true;
            }
            return bl;
        }

        public abstract PairValues getPairValues(int var1, int var2, int var3);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new PairSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new PairSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class SingleSubtableFormat2
    extends SingleSubtable {
        private Value[] values;

        SingleSubtableFormat2(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.values != null) {
                ArrayList<Value> arrayList = new ArrayList<Value>(this.values.length);
                int n = this.values.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.values[i]);
                }
                return arrayList;
            }
            return null;
        }

        public Value getValue(int n, int n2) {
            if (this.values != null && n < this.values.length) {
                return this.values[n];
            }
            return null;
        }

        private void populate(List list) {
            if (list == null) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null");
            }
            if (list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, " + list.size() + " entries present, but requires 1 entry");
            }
            Object e = list.get(0);
            if (e == null || !(e instanceof Value[])) {
                throw new AdvancedTypographicTableFormatException("illegal entries, single entry must be a Value[], but is: " + (e != null ? e.getClass() : null));
            }
            Value[] valueArray = (Value[])e;
            if (valueArray.length != this.getCoverageSize()) {
                throw new AdvancedTypographicTableFormatException("illegal values array, " + list.size() + " values present, but requires " + this.getCoverageSize() + " values");
            }
            assert (this.values == null);
            this.values = valueArray;
        }
    }

    private static class SingleSubtableFormat1
    extends SingleSubtable {
        private Value value;
        private int ciMax;

        SingleSubtableFormat1(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable, list);
            this.populate(list);
        }

        public List getEntries() {
            if (this.value != null) {
                ArrayList<Value> arrayList = new ArrayList<Value>(1);
                arrayList.add(this.value);
                return arrayList;
            }
            return null;
        }

        public Value getValue(int n, int n2) {
            if (this.value != null && n <= this.ciMax) {
                return this.value;
            }
            return null;
        }

        private void populate(List list) {
            if (list == null || list.size() != 1) {
                throw new AdvancedTypographicTableFormatException("illegal entries, must be non-null and contain exactly one entry");
            }
            Object e = list.get(0);
            if (!(e instanceof Value)) {
                throw new AdvancedTypographicTableFormatException("illegal entries entry, must be Value, but is: " + (e != null ? e.getClass() : null));
            }
            Value value = (Value)e;
            assert (this.value == null);
            this.value = value;
            this.ciMax = this.getCoverageSize() - 1;
        }
    }

    private static abstract class SingleSubtable
    extends GlyphPositioningSubtable {
        SingleSubtable(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            super(string, n, n2, n3, glyphCoverageTable);
        }

        public int getType() {
            return 1;
        }

        public boolean isCompatible(GlyphSubtable glyphSubtable) {
            return glyphSubtable instanceof SingleSubtable;
        }

        public boolean position(GlyphPositioningState glyphPositioningState) {
            int n = glyphPositioningState.getGlyph();
            int n2 = this.getCoverageIndex(n);
            if (n2 < 0) {
                return false;
            }
            Value value = this.getValue(n2, n);
            if (value != null) {
                if (glyphPositioningState.adjust(value)) {
                    glyphPositioningState.setAdjusted(true);
                }
                glyphPositioningState.consume(1);
            }
            return true;
        }

        public abstract Value getValue(int var1, int var2);

        static GlyphPositioningSubtable create(String string, int n, int n2, int n3, GlyphCoverageTable glyphCoverageTable, List list) {
            if (n3 == 1) {
                return new SingleSubtableFormat1(string, n, n2, n3, glyphCoverageTable, list);
            }
            if (n3 == 2) {
                return new SingleSubtableFormat2(string, n, n2, n3, glyphCoverageTable, list);
            }
            throw new UnsupportedOperationException();
        }
    }
}

